/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.e2stream.server;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class ServerIP {
    public static String getAllNonLoopbackIps() {
        String string = "";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    string = String.valueOf(string) + inetAddress.getHostAddress() + "\n";
                }
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        return string;
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress inetAddress = null;
            Object object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                NetworkInterface networkInterface = object.nextElement();
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration.nextElement();
                    if (inetAddress2.isLoopbackAddress()) continue;
                    if (inetAddress2.isSiteLocalAddress()) {
                        return inetAddress2;
                    }
                    if (inetAddress != null) continue;
                    inetAddress = inetAddress2;
                }
            }
            if (inetAddress != null) {
                return inetAddress;
            }
            object = InetAddress.getLocalHost();
            if (object == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return object;
        }
        catch (Exception exception) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + exception);
            unknownHostException.initCause(exception);
            throw unknownHostException;
        }
    }
}

