/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.e2stream.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import uk.co.pembo.browser.Browser;
import uk.co.pembo.e2stream.server.AlternateDirectory;
import uk.co.pembo.e2stream.server.ServerIP;
import uk.co.pembo.e2stream.server.Settings;
import uk.co.pembo.e2stream.server.handlers.AboutResponse;
import uk.co.pembo.e2stream.server.handlers.AddDirectoryResponse;
import uk.co.pembo.e2stream.server.handlers.E2Response;
import uk.co.pembo.e2stream.server.handlers.ImgResponse;
import uk.co.pembo.e2stream.server.handlers.InfoResponse;
import uk.co.pembo.e2stream.server.handlers.LogResponse;
import uk.co.pembo.e2stream.server.handlers.OtherWidgetDownload;
import uk.co.pembo.e2stream.server.handlers.QuitResponse;
import uk.co.pembo.e2stream.server.handlers.StringBasedResponse;
import uk.co.pembo.e2stream.server.handlers.WidgetDownload;
import uk.co.pembo.e2stream.server.handlers.WidgetList;
import uk.co.pembo.e2stream.widget.WidgetContainer;
import uk.co.pembo.utils.JarFileExtractor;
import uk.co.pembo.utils.Logger;

public class Startup {
    public static void setConstants() throws Exception {
        InetAddress inetAddress = ServerIP.getLocalHostLANAddress();
        Settings.setIpAddress(inetAddress.getHostAddress());
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            Settings.setAdditionalAppsDir(stringArray[0]);
        }
        Startup.setConstants();
        Startup.printStartupText();
        if (Settings.getAdditionalAppsDir() != null) {
            Logger.logInfo("Additional Apps Directory Provided: [" + Settings.getAdditionalAppsDir() + "]");
            AlternateDirectory.loadFilesInDirectory(Settings.getAdditionalAppsDir());
        }
        Logger.logInfo("Waiting for connection from TV");
        Startup startup = new Startup();
        WidgetContainer.setFile(JarFileExtractor.getWidget());
        byte[] byArray = WidgetContainer.getFile();
        WidgetContainer.setFile(byArray);
        HttpServer httpServer = null;
        try {
            httpServer = HttpServer.create(new InetSocketAddress(80), 0);
            httpServer.createContext("/widgetlist.xml", new WidgetList());
            httpServer.createContext("/Widget/" + Settings.getFilename(), new WidgetDownload());
            httpServer.createContext("/index.html", new InfoResponse());
            httpServer.createContext("/index.htm", new InfoResponse());
            httpServer.createContext("/index.php", new InfoResponse());
            httpServer.createContext("/adddirectory.html", new AddDirectoryResponse());
            httpServer.createContext("/exit.html", new QuitResponse());
            httpServer.createContext("/about.html", new AboutResponse());
            httpServer.createContext("/web/getallservices", new E2Response("C:/temp/e2logs/getallServices.xml"));
            httpServer.createContext("/web/getlocations", new E2Response("C:/temp/e2logs/getlocations.xml"));
            httpServer.createContext("/web/movielist", new E2Response("C:/temp/e2logs/movielist.xml"));
            httpServer.createContext("/about.html", new AboutResponse());
            httpServer.createContext("/style.css", new StringBasedResponse("style.css"));
            httpServer.createContext("/jquerymin.css", new StringBasedResponse("jquerymin.css"));
            httpServer.createContext("/dropdown.css", new StringBasedResponse("dropdown.css"));
            httpServer.createContext("/logo.png", new ImgResponse("logo.png"));
            httpServer.createContext("/jquery.js", new StringBasedResponse("jquery.js"));
            httpServer.createContext("/jquery-ui.js", new StringBasedResponse("jquery-ui.js"));
            httpServer.createContext("/dropdown.js", new StringBasedResponse("dropdown.js"));
            httpServer.createContext("/logs.html", new LogResponse());
            if (Settings.getAdditionalAppsDir() != null) {
                List list = AlternateDirectory.getFilenames();
                for (int i = 0; i < list.size(); ++i) {
                    HttpContext httpContext = httpServer.createContext("/Widget/" + (String)list.get(i), new OtherWidgetDownload());
                    httpContext.getAttributes().put("idx", i);
                }
            }
            httpServer.setExecutor(null);
            httpServer.start();
            Browser.openBrowser("http://localhost/index.html");
        }
        catch (BindException bindException) {
            Settings.setLastError(bindException.toString());
            Startup.fatalError("Unable to bind server to port 80, please close down any webservers or other server running on Port 80 and start this installer again");
            System.in.read();
        }
        catch (Exception exception) {
            Startup.fatalError("An unkown error occurred.  Please see the information below and report this at http://www.pembo.co.uk/bugs");
            exception.printStackTrace();
            System.in.read();
        }
    }

    private static void printStartupText() throws UnknownHostException {
        Logger.logInfo("______________________________________________________________");
        Logger.logInfo(" ");
        Logger.logInfo("E2Stream Installer ");
        Logger.logInfo("______________________________________________________________");
        Logger.logInfo(" ");
        Logger.logInfo("Installer version: " + Settings.getInstallerVersion());
        Logger.logInfo("E2Stream version : " + Settings.getE2StreamVersion());
        Logger.logInfo("(C)2014 Pembo.co.uk");
        Logger.logInfo("http://www.pembo.co.uk/e2stream/");
        Logger.logInfo("______________________________________________________________");
        Logger.logInfo(" ");
        Logger.logInfo("Please configure your samsung SMART TV as documented here:");
        Logger.logInfo("* http://www.pembo.co.uk/e2stream/");
        Logger.logInfo("Using the following IP Address on your TV:");
        Logger.logInfo("* " + ServerIP.getLocalHostLANAddress().getHostAddress());
        Logger.logInfo("______________________________________________________________");
    }

    private static void fatalError(String string) {
        Logger.logError(string);
    }
}

