/**
 *
 * Skinned Console Applications C++/Wii Library
 * (C)2009 http://www.pembo.co.uk
 *
 **/

//------------------------------------------------------------------------------
// Headers
//------------------------------------------------------------------------------

# include "SkinController.h"

//------------------------------------------------------------------------------
// Externals
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// Globals
//------------------------------------------------------------------------------


//_______________________________________________________________________________
/**
 * Default Constructor - assumes filename is skins.xml in the same location
 * as the application.  This only works if the loader correctly sets the current
 * working directory when the application is launched, otherwise you'll need to
 * provide the path to the skins XML file using the alternative constructor
 */
SkinController::SkinController()
{
	skinsFile = strdup("skins.xml");
	initialiseSkinsArray();
	loadSkinsFile();
}

//_______________________________________________________________________________
/**
 * Constructor - path (including name) to the skins file can be provided
 * @param[in] skinsXmlFile the full path the the skins file, e.g. SD:/apps/test/skins.xml
 */
SkinController::SkinController(char* skinsXmlFile)
{
	skinsFile = strdup(skinsXmlFile);
	initialiseSkinsArray();
	loadSkinsFile();	
}
 
//_______________________________________________________________________________
/**
 * destructor
 */
SkinController::~SkinController()
{
}

//_______________________________________________________________________________
/**
 * Initialise the SkinsArray with empty values
 */
void SkinController::initialiseSkinsArray()
{
	int i=0;
	for (i = 0;i<10;i++)
	{
		const char* empty = "*NA*";
		skins_desc[i]=strdup(empty);
		skins_code[i]=strdup(empty);
	}
}

//_______________________________________________________________________________
/**
 * Load the skins file.
 */
void SkinController::loadSkinsFile()
{
	FILE *fp = fopen(getSkinsFileName(), "rb");

	mxml_node_t *skinstree;
	mxml_node_t *skinsnode;


			
	if (fp == NULL) 
	{
	
		fclose(fp);
		printf("Unable to open skins file [skins.xml]");
	}
	
	else
	{
		fseek (fp , 0, SEEK_END);
		long settings_size = ftell (fp);
		rewind (fp);
		
		if (settings_size > 0) 
		{
			
			skinstree = mxmlLoadFile(NULL, fp, MXML_NO_CALLBACK);
			fclose(fp);	
			
			
			//First Count Skins!
			
			int skinCount = 0;
			for (skinsnode = mxmlFindElement(skinstree, skinstree,"skindetail",NULL, NULL,MXML_DESCEND);skinsnode != NULL;skinsnode = mxmlFindElement(skinsnode, skinstree,"skindetail",NULL, NULL,MXML_DESCEND))
			{
				skins_code[skinCount]=strdup(mxmlElementGetAttr(skinsnode,"id"));
				skins_desc[skinCount]=strdup(mxmlElementGetAttr(skinsnode,"name"));
				//if(strcmp(skins_code[skinCount],selected_skin)==0)selSkinOption=(skinCount+0);
				skinCount++;
				printf("Found skin [%s]-[%s]\n",strdup(mxmlElementGetAttr(skinsnode,"id")),strdup(mxmlElementGetAttr(skinsnode,"name")));
			}
			numberSkins=skinCount;
			
			//Now populate the Skin object for each skin!
			skinCount=0;
			for (skinsnode = mxmlFindElement(skinstree, skinstree,"skindetail",NULL, NULL,MXML_DESCEND);skinsnode != NULL;skinsnode = mxmlFindElement(skinsnode, skinstree,"skindetail",NULL, NULL,MXML_DESCEND))
			{
				printf("Parsing skin [%s]-[%s]\n",strdup(mxmlElementGetAttr(skinsnode,"id")),strdup(mxmlElementGetAttr(skinsnode,"name")));			
				skins[skinCount].populateSkinValues(skinsnode);
				skinCount++;
			}
		}			

		else 
		{
			fclose(fp);
			//unlink("sd:/apps/bootmii/bce_messages.xml");
			printf("Unable to read skins file [skins.xml]");
			
		}		
	}//*/	
}

//_______________________________________________________________________________
/**
 * Returns the skin at skin number provided
 * @param[in] skinNo integer containing skin number to return
 **/
Skin SkinController::getSkin(int skinNo)
{
	return skins[skinNo];
}



 
