/**
 *
 * Skinned Console Applications C++/Wii Library
 * (C)2009 http://www.pembo.co.uk
 *
 **/
 
//------------------------------------------------------------------------------
// Headers
//------------------------------------------------------------------------------
# include "FileIO.h"



//------------------------------------------------------------------------------
// Externals
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// Globals
//------------------------------------------------------------------------------


//_______________________________________________________________________________
/**
 * Constructor
 */
 FileIO::FileIO()
 {
	initialiseFat();
 }
 

//_______________________________________________________________________________
/**
 * destructor
 */
 FileIO::~FileIO()
 {
 }
 
 
//_______________________________________________________________________________
/**
 * Check to see if the SD card can be opened.
 * @return bool to indicate whether the SD can be opened or not.
 */

bool FileIO::can_open_root_fs() 
{
	DIR_ITER *root = diropen("SD:/");
	if (root) 
	{
		dirclose(root);
		return true;
	}
	return false;
}


//_______________________________________________________________________________
/*
* Initialise the FAT subsystem
*/
void FileIO::initialiseFat()
{
	printf(" Initialising FAT ......... ");
	if (!fatInitDefault())
	{
		//drawError(15,11,11,50,err1_initFatErr);
		printf("Unable to initialise FAT subsystem, exiting.\n");
		sleep(2);
		exit(-1);
	}
	
	//If you want to check the SD card.
	if (!can_open_root_fs()) 
	{
		printf("Unable to open SD card, exiting.\n");
		sleep(2);
		exit(-1);
	}
	printf("Done\n");

}

