/**
 *
 * Skinned Console Applications C++/Wii Library
 * (C)2009 http://www.pembo.co.uk
 *
 **/
 
//------------------------------------------------------------------------------
// Headers
//------------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>
#include <gccore.h>
#include <mxml.h>


#ifndef SKIN_HPP
#define SKIN_HPP
class Skin
{
	public:
		Skin();
		~Skin();
		

		char* getSkinId(){return skinId;};
		char* getSkinName(){return skinName;};
		
		int getSkinConsoleBgColor(){return skin_console_bgcolor;};
		int getSkinConsoleTextColor(){return skin_console_textcolor;};
		
		int getSkinPrimaryBgColor(){return skin_main_bgcolor;};
		int getSkinPrimaryTextColor(){return skin_main_textcolor;};
		int getSkinPrimaryTextColorAlternate(){return skin_main_textcolor2;};
		int getSkinPrimaryTitleTextColor(){return skin_main_titlecolor;};
		int getSkinPrimaryTitleRowColor(){return skin_main_titlelinecolor;};
		int getSkinPrimarySelectionIndicatorColor(){return skin_main_selectedIndicatorcolor;};
		int getSkinPrimarySelectionIndicatorColorAlternate(){return skin_main_selectedOptioncolor;};
		int getSkinPrimaryShadow(){return skin_main_shadow;};
		int getSkinPrimaryDecalsColour(){return skin_main_decl;};
		
		int getSkinSecondaryBgColor(){return skin_dialog_bgcolor;};
		int getSkinSecondaryTextColor(){return skin_dialog_textcolor;};
		int getSkinSecondaryTextColorAlternate(){return skin_dialog_textcolor2;};
		int getSkinSecondaryTitleTextColor(){return skin_dialog_titlecolor;};
		int getSkinSecondaryTitleRowColor(){return skin_dialog_titlelinecolor;};
		int getSkinSecondarySelectionIndicatorColor(){return skin_dialog_selectedIndicatorcolor;};
		int getSkinSecondarySelectionIndicatorColorAlternate(){return skin_dialog_selectedOptioncolor;};
		int getSkinSecondaryShadow(){return skin_dialog_shadow;};
		int getSkinSecondaryDecalsColour(){return skin_dialog_decl;};	

		void populateSkinValues(mxml_node_t *skinsdata);
		
		
	private:
		
		char* skinId;
		char* skinName;
		
		int skin_console_bgcolor;
		int skin_console_textcolor;
		int skin_main_bgcolor;
		int skin_main_textcolor;
		int skin_main_textcolor2;
		int skin_main_titlecolor;
		int skin_main_titlelinecolor;
		int skin_main_selectedIndicatorcolor;
		int skin_main_selectedOptioncolor;
		int skin_main_shadow;
		int skin_dialog_bgcolor;
		int skin_dialog_textcolor;
		int skin_dialog_textcolor2;
		int skin_dialog_titlecolor;
		int skin_dialog_titlelinecolor;
		int skin_dialog_selectedIndicatorcolor;
		int skin_dialog_selectedOptioncolor;
		int skin_dialog_shadow;
		int skin_main_decl;
		int skin_dialog_decl;
	
};
#endif

