/**
 *
 * Skinned Console Applications C++/Wii Library
 * (C)2009 http://www.pembo.co.uk
 *
 **/
 
#ifndef CONSOLE_HPP
#define CONSOLE_HPP

//------------------------------------------------------------------------------
// Headers
//------------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gccore.h>
#include "../skins/skin.h"

class Console
{
	public:	
		Console();
		~Console();
		
		static const int BLACK 			= 0;
		static const int DARK_RED 		= 1;
		static const int DARK_GREEN 	= 2;
		static const int DARK_YELLOW 	= 3;
		static const int DARK_BLUE 		= 4;
		static const int DARK_MAGENTA	= 5;
		static const int DARK_CYAN 		= 6;
		static const int GRAY 			= 7;
		static const int DARK_GRAY 		= 10;
		static const int RED 			= 11;
		static const int GREEN 			= 12;
		static const int YELLOW 		= 13;
		static const int BLUE 			= 14;
		static const int MAGENTA	 	= 15;
		static const int CYAN 			= 16;
		static const int WHITE 			=17;
				
		//Console position/clearing
		void clearConsole(int bgcolor);
		void clearArea(int startX,int startY, int rows, int cols, int bgcolor);
		void moveCursor (int row, int column);
		void backspace();
		
		//Colours
		void setColor(int fgcolor,int bgcolor);
		
		//Text
		void drawString (int x, int y, int color, int bgcolor, const char *msg);
		void centerString (int y, int color, int bgcolor, const char *msg);
		
		//Windows
		void drawWindow (int startX,int startY,int rows,int cols, int bgColor,int title_textColor,int title_textlineColor,int title_bgColor, int shadowColor, int declColor, const char* windowTitle);
		
		
		//--------------------Skin functions
		
		//Console position/clearing
		void clearConsole();
		void clearConsoleArea(int startX,int startY, int rows, int cols);
		void clearPrimaryArea(int startX,int startY, int rows, int cols);
		void clearSecondaryArea(int startX,int startY, int rows, int cols);
		
		//text
		void drawStringPrimary (int x, int y, const char *msg);
		void drawStringPrimaryAlternate (int x, int y, const char *msg);
		void drawStringSecondary (int x, int y, const char *msg);
		void drawStringSecondaryAlternate (int x, int y, const char *msg);
		
		void centerStringPrimary (int y, const char *msg);
		void centerStringPrimaryAlternate (int y, const char *msg);
		void centerStringSecondary (int y, const char *msg);
		void centerStringSecondaryAlternate (int y, const char *msg);
		
		//Windows
		void drawPrimaryWindow (int startX,int startY,int rows,int cols, const char* windowTitle);
		void drawSecondaryWindow (int startX,int startY,int rows,int cols, const char* windowTitle);
		
		void registerSkin(Skin skin);
		
		
		
					
	private:
		int translateColor(int color);
		bool isBrightColor(int color);
		bool skinRegistered;
		bool isSkinRegistered(){return skinRegistered;};
		void handleSkinRegistrationError();
		
		Skin registeredSkin;
		
};

#endif
