/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import uk.co.pembo.util.PersistentSettings;

public class FileUtils {
    public static void copyFile(String source, String dest) throws IOException {
        int c;
        File inputFile = new File(source);
        File outputFile = new File(dest);
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static String getPathOnlyFromFullFilename(String filename) {
        return filename.substring(0, filename.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
    }

    public static String getFilenameOnlyFromFullFilename(String filename) {
        return filename.substring(filename.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
    }

    public static void rename(String file, String newName) throws IOException {
        File f = new File(file);
        String path = f.getAbsolutePath();
        if (newName.indexOf(PersistentSettings.FILE_SEPARATOR) < 0) {
            newName = String.valueOf(path) + newName;
        }
        f.renameTo(new File(newName));
    }

    public static void delete(String file) throws IOException {
        File f = new File(file);
        f.delete();
    }

    public static void writeStringToFile(String str, String filename) throws IOException {
        FileWriter outFile = new FileWriter(filename);
        PrintWriter out = new PrintWriter(outFile);
        out.print(str);
        out.flush();
        out.close();
    }
}

