/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.ui;

import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import uk.co.pembo.agemame.render.HierarchyTreePopulator;
import uk.co.pembo.agemame.ui.DetailsPanel;
import uk.co.pembo.agemame.ui.EditableTableItem;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.agemame.xmlbinding.DragAndDropController;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Screen;
import uk.co.pembo.agemame.xmlbinding.mamelayout.View;

public class ItemsTree
extends Composite {
    private ToolBar itemsToolbar;
    private MameLayoutManager mameLayoutManager;
    private DetailsPanel details;
    private GC gc;
    private Canvas preview;
    private Shell mainShell;
    private Composite self;
    private TreeItem lastSelected;
    private Tree itemsTree;
    private TreeItem MameLayout;
    private TreeItem backdropsTreeItem;
    private TreeItem bezelsTreeItem;
    private TreeItem screenTreeItem;
    private TreeItem viewsTreeItem;
    private TreeItem viewTreeItem;
    private TreeItem elements;
    private Composite parent;
    Menu treeContext;
    private ToolItem bringToFront;
    private ToolItem sendToBack;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;

    public ItemsTree(Composite parent, int style) {
        super(parent, style);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.lastSelected = null;
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.setLayout((Layout)gridLayout);
        this.setData("newKey", null);
        this.parent = parent;
        this.initialize();
    }

    private void bringForward() {
        TreeItem[] items = this.itemsTree.getSelection();
        System.out.println("MOVE UP!");
        int cfr_ignored_0 = items.length;
    }

    private void sendBackward() {
        TreeItem[] items = this.itemsTree.getSelection();
        System.out.println("MOVE DOWN!");
        int cfr_ignored_0 = items.length;
    }

    void createTreeContextMenu(String type) {
        System.out.println("MENU TYPE [" + type + "]");
        int orientation = 0;
        orientation |= 0x2000000;
        this.treeContext = new Menu((Decorations)this.mainShell, 8);
        MenuItem item = new MenuItem(this.treeContext, 8);
        item.setText("Move up");
        item.setImage(SWTResourceManager.getImage("icons/moveUp.gif"));
        if (!type.equals("BACKDROPS")) {
            item.setEnabled(false);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ItemsTree.this.bringForward();
            }
        });
        item = new MenuItem(this.treeContext, 8);
        item.setText("Move down");
        item.setImage(SWTResourceManager.getImage("icons/moveDown.gif"));
        if (!type.equals("BACKDROPS")) {
            item.setEnabled(false);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ItemsTree.this.sendBackward();
            }
        });
        new MenuItem(this.treeContext, 2);
    }

    private void enableToolBarItems() {
        boolean enabled = true;
        if (this.bringToFront.getEnabled()) {
            enabled = false;
        }
        this.enableToolBarItems(enabled);
    }

    private void enableToolBarItems(boolean enabled) {
        this.bringToFront.setEnabled(enabled);
        this.sendToBack.setEnabled(enabled);
        this.moveUpItem.setEnabled(enabled);
        this.moveDownItem.setEnabled(enabled);
    }

    private void initialize() {
        this.itemsToolbar = new ToolBar((Composite)this, 0);
        this.itemsToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.itemsToolbar.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, 22);
        this.bringToFront = new ToolItem(this.itemsToolbar, 0);
        this.bringToFront.setToolTipText("Bring To Front");
        this.bringToFront.setImage(SWTResourceManager.getImage("icons/toolbar/bringToFront.gif"));
        this.sendToBack = new ToolItem(this.itemsToolbar, 0);
        this.sendToBack.setToolTipText("Send To Back");
        this.sendToBack.setImage(SWTResourceManager.getImage("icons/toolbar/sendToBack.gif"));
        this.moveUpItem = new ToolItem(this.itemsToolbar, 0);
        this.moveUpItem.setToolTipText("Bring Forward");
        this.moveUpItem.setImage(SWTResourceManager.getImage("icons/toolbar/bringForward.gif"));
        this.moveDownItem = new ToolItem(this.itemsToolbar, 0);
        this.moveDownItem.setToolTipText("Send Backward");
        this.moveDownItem.setImage(SWTResourceManager.getImage("icons/toolbar/sendBackward.gif"));
        this.enableToolBarItems(false);
        this.itemsTree = new Tree((Composite)this, 2048);
        this.itemsTree.setLayoutData((Object)new GridData(1808));
        this.itemsTree.addListener(1, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.itemsTree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Object items;
                if (ItemsTree.this.itemsTree.getSelectionCount() > 0) {
                    ItemsTree.this.enableToolBarItems(true);
                }
                if (event.button > 1 && ItemsTree.this.itemsTree.getSelectionCount() > 0) {
                    System.out.println("Right mouse button");
                    items = ItemsTree.this.itemsTree.getSelection();
                    ItemsTree.this.treeContext = new Menu((Decorations)items[0].getParent().getShell(), 8);
                    ItemsTree.this.createTreeContextMenu(items[0].getParentItem().getData().toString());
                    ItemsTree.this.treeContext.setVisible(true);
                }
                if (ItemsTree.this.itemsTree.getSelectionCount() > 0) {
                    if (ItemsTree.this.lastSelected != null && !ItemsTree.this.lastSelected.isDisposed() && ItemsTree.this.lastSelected.getData() instanceof Backdrop) {
                        items = (Backdrop)ItemsTree.this.lastSelected.getData();
                    }
                    if ((items = ItemsTree.this.itemsTree.getSelection()) != null && ((TreeItem[])items).length > 0 && items[0] != ItemsTree.this.lastSelected) {
                        Object data = items[0].getData();
                        EditableTableItem[] eti = new EditableTableItem[]{};
                        if (!(data instanceof String)) {
                            if (data instanceof Backdrop) {
                                Backdrop bd = (Backdrop)data;
                                if (ItemsTree.this.preview != null) {
                                    ItemsTree.this.preview.redraw();
                                }
                                eti = new EditableTableItem[6];
                                eti[0] = new EditableTableItem("Name", bd.getName());
                                String stateStr = "";
                                if (bd != null && bd.getState() != null) {
                                    stateStr = bd.getState().toString();
                                }
                                eti[1] = new EditableTableItem("State", stateStr);
                                String x = "";
                                String y = "";
                                String width = "";
                                String height = "";
                                if (bd.getBounds() != null) {
                                    x = bd.getBounds().getX();
                                    y = bd.getBounds().getY();
                                    width = bd.getBounds().getWidth();
                                    height = bd.getBounds().getHeight();
                                }
                                eti[2] = new EditableTableItem("X", x);
                                eti[3] = new EditableTableItem("Y", y);
                                eti[4] = new EditableTableItem("Width", width);
                                eti[5] = new EditableTableItem("Height", height);
                            } else if (data instanceof Image) {
                                Image img = (Image)data;
                                img.getAlphafile();
                                img.getFile();
                                img.getState();
                                eti = new EditableTableItem[]{img != null && img.getState() != null ? new EditableTableItem("State", img.getState().toString()) : new EditableTableItem("State", ""), new EditableTableItem("Filename", img.getFile()), new EditableTableItem("Alpha File", img.getAlphafile())};
                            } else if (data instanceof Element) {
                                Element elem = (Element)data;
                                eti = new EditableTableItem[2];
                                eti[0] = new EditableTableItem("Name", elem.getName());
                                eti[1] = elem.getDefstate() != null ? new EditableTableItem("Default State", elem.getDefstate().toString()) : new EditableTableItem("Default State", "");
                            } else if (data instanceof Screen) {
                                Screen screen = (Screen)data;
                                eti = new EditableTableItem[5];
                                eti[0] = new EditableTableItem("Index", screen.getIndex().toString());
                                String x = "";
                                String y = "";
                                String width = "";
                                String height = "";
                                if (screen.getBounds() != null) {
                                    x = screen.getBounds().getX();
                                    y = screen.getBounds().getY();
                                    width = screen.getBounds().getWidth();
                                    height = screen.getBounds().getHeight();
                                }
                                eti[1] = new EditableTableItem("X", x);
                                eti[2] = new EditableTableItem("Y", y);
                                eti[3] = new EditableTableItem("Width", width);
                                eti[4] = new EditableTableItem("Height", height);
                            } else if (data instanceof Mamelayout) {
                                Mamelayout lay = (Mamelayout)data;
                                eti = new EditableTableItem[]{new EditableTableItem("Version", lay.getVersion().toString())};
                            } else if (data instanceof View) {
                                View view = (View)data;
                                eti = new EditableTableItem[]{new EditableTableItem("Name", view.getName())};
                            } else {
                                eti = new EditableTableItem[]{};
                            }
                        }
                        if (ItemsTree.this.details != null) {
                            if (eti.length > 0) {
                                ItemsTree.this.details.setContent(eti, data);
                            }
                            ItemsTree.this.details.setDataObject(data);
                            ItemsTree.this.details.redraw();
                        }
                        ItemsTree.this.lastSelected = items[0];
                    }
                }
            }
        });
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource((Control)this.itemsTree, operations);
        source.setTransfer(types);
        final TreeItem[] dragSourceItem = new TreeItem[1];
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                System.out.println("dragStart");
                TreeItem[] selection = ItemsTree.this.itemsTree.getSelection();
                if (selection.length > 0 && selection[0].getItemCount() == 0) {
                    event.doit = true;
                    dragSourceItem[0] = selection[0];
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                System.out.println("DRAG SET DATA");
                String text = "<!NON-DRAGGABLE!>";
                event.data = text;
            }

            public void dragFinished(DragSourceEvent event) {
                System.out.println("DRAG FINISHED!");
            }
        });
        DropTarget target = new DropTarget((Control)this.itemsTree, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                System.out.println("DROP!");
                DragAndDropController dndController = new DragAndDropController(ItemsTree.this.mameLayoutManager);
                dndController.dragDropEvent(event);
                ItemsTree.this.populateTree();
            }
        });
    }

    public Tree getItemsTree() {
        return this.itemsTree;
    }

    public TreeItem getMameLayout() {
        return this.MameLayout;
    }

    public TreeItem getElements() {
        return this.elements;
    }

    public TreeItem getViewTreeItem() {
        return this.viewTreeItem;
    }

    public TreeItem getBackdropsTreeItem() {
        return this.backdropsTreeItem;
    }

    public void registerSelf(Composite panel) {
        this.self = panel;
    }

    public void registerDetailsPanel(DetailsPanel panel) {
        this.details = panel;
    }

    public void registerCanvas(Canvas preview) {
        this.preview = preview;
    }

    public void registerShell(Shell shell) {
        this.mainShell = shell;
    }

    public void registerGC(GC gc) {
        this.gc = gc;
    }

    public void registerLayoutManager(MameLayoutManager mameLayoutManager) {
        this.mameLayoutManager = mameLayoutManager;
    }

    public void registerDependencies(MameLayoutManager mameLayoutManager, GC gc, Shell shell, Canvas previewCanvas, DetailsPanel details, Composite self) {
        this.registerLayoutManager(mameLayoutManager);
        this.registerGC(gc);
        this.registerCanvas(previewCanvas);
        this.registerDetailsPanel(details);
        this.registerSelf(self);
        this.registerShell(shell);
    }

    public void empty() {
        if (this.itemsTree != null) {
            this.itemsTree.removeAll();
        }
    }

    public void populateTree() {
        this.empty();
        HierarchyTreePopulator treePop = new HierarchyTreePopulator(this.itemsTree, this.mameLayoutManager);
        treePop.createNodes();
    }

    private void reorgBackdropsTree() {
    }

    public TreeItem getLastSelected() {
        return this.lastSelected;
    }
}

