/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.xmlbinding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.swt.graphics.Device;
import uk.co.pembo.agemame.exception.LayoutParseException;
import uk.co.pembo.agemame.xmlbinding.LayoutChanger;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;

public class MameLayoutManager {
    private static final String fileSeparator = System.getProperty("file.separator");
    private Mamelayout mamelayout;
    private String rootPath = null;

    public MameLayoutManager(File f) throws FileNotFoundException, LayoutParseException {
        FileInputStream fis = new FileInputStream(f);
        this.rootPath = MameLayoutManager.getRootPath(f.getAbsolutePath());
        this.createDataObjects(fis);
    }

    public MameLayoutManager(String filename) throws FileNotFoundException, LayoutParseException {
        this.rootPath = MameLayoutManager.getRootPath(filename);
        File f = new File(filename);
        FileInputStream fis = new FileInputStream(f);
        this.createDataObjects(fis);
    }

    public MameLayoutManager(StringBuffer xml) throws LayoutParseException {
        System.out.println("CREATING XML OBJECTS FROM:" + xml);
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.toString().getBytes());
        this.createDataObjects(bais);
    }

    public void updateXml(String xml) throws LayoutParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        this.createDataObjects(bais);
    }

    public Mamelayout getMameLayout() {
        return this.mamelayout;
    }

    private void createDataObjects(InputStream is) throws LayoutParseException {
        this.createDataObjects(is, true);
    }

    private void createDataObjects(InputStream is, boolean validate) throws LayoutParseException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"uk.co.pembo.agemame.xmlbinding.mamelayout");
            Unmarshaller u = jc.createUnmarshaller();
            this.mamelayout = (Mamelayout)u.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new LayoutParseException("Problem parsing layout: \n" + e.toString(), e);
        }
    }

    public String toXml() throws LayoutParseException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"uk.co.pembo.agemame.xmlbinding.mamelayout");
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal((Object)this.mamelayout, (OutputStream)baos);
            return baos.toString();
        }
        catch (PropertyException e) {
            e.printStackTrace();
            throw new LayoutParseException("Problem marshalling layout (setting property)", e);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new LayoutParseException("Problem marshalling layout", e);
        }
    }

    public Element getElementByName(String elementName) {
        List<Element> elements = this.mamelayout.getElement();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) != null && elements.get(i).getName().equals(elementName)) {
                return elements.get(i);
            }
            ++i;
        }
        return null;
    }

    public org.eclipse.swt.graphics.Image getAlphaImage(Device display, Image imageBinding) {
        org.eclipse.swt.graphics.Image image = this.loadSWTImage(String.valueOf(this.rootPath) + imageBinding.getAlphafile(), display);
        return image;
    }

    public org.eclipse.swt.graphics.Image getImage(Device display, Image imageBinding) {
        org.eclipse.swt.graphics.Image image = this.loadSWTImage(String.valueOf(this.rootPath) + imageBinding.getFile(), display);
        return image;
    }

    private org.eclipse.swt.graphics.Image loadSWTImage(String fileName, Device display) {
        org.eclipse.swt.graphics.Image swtImg = new org.eclipse.swt.graphics.Image(display, fileName);
        return swtImg;
    }

    private static String getRootPath(String layoutFile) {
        String rootPath = "";
        int lastPos = layoutFile.lastIndexOf(fileSeparator);
        rootPath = lastPos > 0 ? String.valueOf(layoutFile.substring(0, lastPos)) + fileSeparator : "";
        return rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public LayoutChanger getLayoutChanger() {
        return new LayoutChanger(this);
    }
}

