/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.render;

import java.util.List;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Disk;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Rect;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Text;
import uk.co.pembo.agemame.xmlbinding.mamelayout.View;

public class HierarchyTreePopulator {
    private MameLayoutManager mameLayoutManager;
    private Tree itemsTree;

    public HierarchyTreePopulator(Tree itemsTree, MameLayoutManager mameLayoutManager) {
        this.itemsTree = itemsTree;
        this.mameLayoutManager = mameLayoutManager;
    }

    public void createNodes() {
        TreeItem mameLayout = new TreeItem(this.itemsTree, 0);
        mameLayout.setText("MameLayout");
        mameLayout.setData((Object)this.mameLayoutManager.getMameLayout());
        mameLayout.setImage(SWTResourceManager.getImage("icons/MameLayout.gif"));
        TreeItem elements = new TreeItem(mameLayout, 0);
        elements.setText("Elements");
        elements.setData((Object)"<ELEMENTS>");
        elements.setImage(SWTResourceManager.getImage("icons/elements.gif"));
        this.createElements(elements);
        this.createViews(mameLayout);
    }

    public void createElements(TreeItem elements) {
        List<Element> jaxbElements = this.mameLayoutManager.getMameLayout().getElement();
        int elementCount = 0;
        while (elementCount < jaxbElements.size()) {
            String state;
            Element jaxbElement = jaxbElements.get(elementCount);
            String key = jaxbElement.getName();
            TreeItem element = new TreeItem(elements, 0);
            element.setText(key);
            element.setData((Object)jaxbElement);
            element.setImage(SWTResourceManager.getImage("icons/element.gif"));
            List<Image> images = jaxbElement.getImage();
            List<Rect> rects = jaxbElement.getRect();
            List<Disk> disks = jaxbElement.getDisk();
            List<Text> texts = jaxbElement.getText();
            if (jaxbElement.getLed7Seg() != null) {
                TreeItem image = new TreeItem(element, 0);
                image.setText("led7seg");
                image.setImage(SWTResourceManager.getImage("icons/led7seg.gif"));
                image.setData((Object)jaxbElement.getLed7Seg());
            }
            if (jaxbElement.getRect().size() > 0) {
                int i = 0;
                while (i < rects.size()) {
                    state = rects.get(i).getState();
                    TreeItem rect = new TreeItem(element, 0);
                    rect.setText("[" + state + "]" + "rect");
                    rect.setImage(SWTResourceManager.getImage("icons/rect.gif"));
                    rect.setData((Object)rects.get(i));
                    ++i;
                }
            }
            if (jaxbElement.getDisk().size() > 0) {
                int i = 0;
                while (i < disks.size()) {
                    state = disks.get(i).getState();
                    TreeItem disk = new TreeItem(element, 0);
                    disk.setText("[" + state + "]" + "disk");
                    disk.setImage(SWTResourceManager.getImage("icons/disk.gif"));
                    disk.setData((Object)disks.get(i));
                    ++i;
                }
            }
            if (jaxbElement.getText().size() > 0) {
                int i = 0;
                while (i < texts.size()) {
                    state = texts.get(i).getState();
                    String stringValue = texts.get(i).getString();
                    TreeItem text = new TreeItem(element, 0);
                    text.setText("[" + state + "]" + stringValue);
                    text.setImage(SWTResourceManager.getImage("icons/text.gif"));
                    text.setData((Object)texts.get(i));
                    ++i;
                }
            }
            if (jaxbElement.getImage().size() > 0) {
                int i = 0;
                while (i < images.size()) {
                    int state2 = 0;
                    if (images.get(i).getState() != null) {
                        state2 = images.get(i).getState().intValue();
                    }
                    String file = images.get(i).getFile();
                    TreeItem image = new TreeItem(element, 0);
                    image.setText("[" + state2 + "]" + file);
                    image.setImage(SWTResourceManager.getImage("icons/image.gif"));
                    image.setData((Object)images.get(i));
                    ++i;
                }
            }
            ++elementCount;
        }
    }

    public void createViews(TreeItem mameLayout) {
        TreeItem viewsTreeItem = new TreeItem(mameLayout, 0);
        viewsTreeItem.setText("Views");
        viewsTreeItem.setData((Object)"");
        viewsTreeItem.setImage(SWTResourceManager.getImage("icons/views.gif"));
        List<View> views = this.mameLayoutManager.getMameLayout().getView();
        int i = 0;
        while (i < views.size()) {
            View view = views.get(i);
            TreeItem treeView = new TreeItem(viewsTreeItem, 0);
            treeView.setText(view.getName());
            treeView.setImage(SWTResourceManager.getImage("icons/view.gif"));
            treeView.setData((Object)view);
            if (view.getBackdrop().size() > 0) {
                TreeItem backdropsTreeItem = new TreeItem(treeView, 0);
                backdropsTreeItem.setText("Backdrops");
                backdropsTreeItem.setData((Object)"");
                backdropsTreeItem.setImage(SWTResourceManager.getImage("icons/backdrops.gif"));
                this.populateBackdropsTree(backdropsTreeItem, view);
            }
            if (view.getScreen().size() > 0) {
                int screenCount = 0;
                while (screenCount < view.getScreen().size()) {
                    TreeItem screenTreeItem = new TreeItem(treeView, 0);
                    screenTreeItem.setText("[ " + view.getScreen().get(screenCount).getIndex().intValue() + "]Screen");
                    screenTreeItem.setData((Object)view.getScreen().get(screenCount));
                    screenTreeItem.setImage(SWTResourceManager.getImage("icons/screen.gif"));
                    ++screenCount;
                }
            }
            if (view.getBezel().size() > 0) {
                this.populateBezelsTree(treeView, view);
            }
            if (view.getOverlay().size() > 0) {
                this.populateOverlaysTree(treeView, view);
            }
            ++i;
        }
    }

    private void populateOverlaysTree(TreeItem p_backdropsTreeItem, View view) {
        int i = 0;
        while (i < view.getOverlay().size()) {
            View.Overlay overlay = view.getOverlay().get(i);
            TreeItem overlaytree = new TreeItem(p_backdropsTreeItem, 0);
            overlaytree.setImage(SWTResourceManager.getImage("icons/overlay.gif"));
            overlaytree.setText("Overlay");
            overlaytree.setData((Object)overlay);
            ++i;
        }
    }

    private void populateBezelsTree(TreeItem p_backdropsTreeItem, View view) {
        int i = 0;
        while (i < view.getBezel().size()) {
            View.Bezel bd = view.getBezel().get(i);
            String name = bd.getName();
            TreeItem bezel = new TreeItem(p_backdropsTreeItem, 0);
            bezel.setImage(SWTResourceManager.getImage("icons/bezel.gif"));
            bezel.setText(name);
            bezel.setData((Object)bd);
            ++i;
        }
    }

    private void populateBackdropsTree(TreeItem p_backdropsTreeItem, View view) {
        int i = 0;
        while (i < view.getBackdrop().size()) {
            Backdrop bd = view.getBackdrop().get(i);
            int state = 0;
            if (bd.getState() != null) {
                state = bd.getState();
            }
            String name = bd.getName();
            TreeItem backdrop = new TreeItem(p_backdropsTreeItem, 0);
            backdrop.setImage(SWTResourceManager.getImage("icons/backdrop.gif"));
            backdrop.setText("[" + state + "]" + name);
            backdrop.setData((Object)bd);
            ++i;
        }
    }
}

