/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.ui;

import java.io.File;
import java.util.Arrays;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import uk.co.pembo.agemame.ui.DetailsPanel;
import uk.co.pembo.agemame.ui.EditableTableItem;
import uk.co.pembo.agemame.userinterface.RenameFile;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Screen;
import uk.co.pembo.agemame.xmlbinding.mamelayout.View;
import uk.co.pembo.io.FileUtils;
import uk.co.pembo.util.PersistentSettings;

public class ExplorerTree
extends Composite {
    public static final String[] IMPORT_FILTER_EXTENSIONS = new String[]{"*.png; *.jpg;", "*.png"};
    public static final String[] IMPORT_FILTER_NAMES = new String[]{"All Image Files (png)", "PNG Image (*.png)"};
    public String lastpath = null;
    private ToolBar itemsToolbar;
    private MameLayoutManager mameLayoutManager;
    private DetailsPanel details;
    private GC gc;
    private Canvas preview;
    private Shell mainShell;
    private Composite self;
    private TreeItem lastSelected;
    private Tree itemsTree;
    private TreeItem root;
    private Composite parent;
    Menu treeContext;
    private ToolItem bringToFront;
    private ToolItem sendToBack;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private String wholePath;

    public ExplorerTree(Composite parent, int style) {
        super(parent, style);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.lastSelected = null;
        this.wholePath = null;
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.setLayout((Layout)gridLayout);
        this.setData("newKey", null);
        this.parent = parent;
        this.initialize();
    }

    void createTreeContextMenu(String type) {
        System.out.println("MENU TYPE [" + type + "]");
        int orientation = 0;
        orientation |= 0x2000000;
        this.treeContext = new Menu((Decorations)this.mainShell, 8);
        MenuItem item = new MenuItem(this.treeContext, 8);
        item.setText("Import New Image(s)");
        item.setImage(SWTResourceManager.getImage("icons/toolbar/import.gif"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExplorerTree.this.importFile(ExplorerTree.this.wholePath);
            }
        });
        item = new MenuItem(this.treeContext, 8);
        item.setText("Refresh File List");
        item.setImage(SWTResourceManager.getImage("icons/toolbar/refresh.gif"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExplorerTree.this.populateTree(ExplorerTree.this.wholePath);
            }
        });
        new MenuItem(this.treeContext, 2);
        item = new MenuItem(this.treeContext, 8);
        item.setText("Rename");
        if (type.equals("root")) {
            item.setEnabled(false);
        }
        if (type.toLowerCase().endsWith(".lay")) {
            item.setEnabled(false);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExplorerTree.this.renameFile(ExplorerTree.this.wholePath);
            }
        });
        item = new MenuItem(this.treeContext, 8);
        item.setText("Delete");
        item.setImage(SWTResourceManager.getImage("icons/toolbar/delete.gif"));
        if (type.equals("root")) {
            item.setEnabled(false);
        }
        if (type.toLowerCase().endsWith(".lay")) {
            item.setEnabled(false);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExplorerTree.this.deleteFile(ExplorerTree.this.wholePath);
            }
        });
        new MenuItem(this.treeContext, 2);
    }

    private void initialize() {
        this.itemsToolbar = new ToolBar((Composite)this, 0);
        this.itemsToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.itemsToolbar.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, 22);
        this.itemsTree = new Tree((Composite)this, 2050);
        this.itemsTree.setLayoutData((Object)new GridData(1808));
        this.itemsTree.addListener(1, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.itemsTree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Object items;
                ExplorerTree.this.itemsTree.getSelectionCount();
                if (event.button > 1 && ExplorerTree.this.itemsTree.getSelectionCount() > 0) {
                    System.out.println("Right mouse button");
                    items = ExplorerTree.this.itemsTree.getSelection();
                    ExplorerTree.this.treeContext = new Menu((Decorations)items[0].getParent().getShell(), 8);
                    ExplorerTree.this.createTreeContextMenu(items[0].getData().toString());
                    ExplorerTree.this.treeContext.setVisible(true);
                }
                if (ExplorerTree.this.itemsTree.getSelectionCount() > 0) {
                    if (ExplorerTree.this.lastSelected != null && !ExplorerTree.this.lastSelected.isDisposed() && ExplorerTree.this.lastSelected.getData() instanceof Backdrop) {
                        items = (Backdrop)ExplorerTree.this.lastSelected.getData();
                    }
                    if ((items = ExplorerTree.this.itemsTree.getSelection()) != null && ((TreeItem[])items).length > 0 && items[0] != ExplorerTree.this.lastSelected) {
                        Object data = items[0].getData();
                        EditableTableItem[] eti = new EditableTableItem[]{};
                        if (!(data instanceof String)) {
                            if (data instanceof Backdrop) {
                                Backdrop bd = (Backdrop)data;
                                if (ExplorerTree.this.preview != null) {
                                    ExplorerTree.this.preview.redraw();
                                }
                                eti = new EditableTableItem[6];
                                eti[0] = new EditableTableItem("Name", bd.getName());
                                String stateStr = "";
                                if (bd != null && bd.getState() != null) {
                                    stateStr = bd.getState().toString();
                                }
                                eti[1] = new EditableTableItem("State", stateStr);
                                String x = "";
                                String y = "";
                                String width = "";
                                String height = "";
                                if (bd.getBounds() != null) {
                                    x = bd.getBounds().getX();
                                    y = bd.getBounds().getY();
                                    width = bd.getBounds().getWidth();
                                    height = bd.getBounds().getHeight();
                                }
                                eti[2] = new EditableTableItem("X", x);
                                eti[3] = new EditableTableItem("Y", y);
                                eti[4] = new EditableTableItem("Width", width);
                                eti[5] = new EditableTableItem("Height", height);
                            } else if (data instanceof Image) {
                                Image img = (Image)data;
                                img.getAlphafile();
                                img.getFile();
                                img.getState();
                                eti = new EditableTableItem[]{img != null && img.getState() != null ? new EditableTableItem("State", img.getState().toString()) : new EditableTableItem("State", ""), new EditableTableItem("Filename", img.getFile()), new EditableTableItem("Alpha File", img.getAlphafile())};
                            } else if (data instanceof Element) {
                                Element elem = (Element)data;
                                eti = new EditableTableItem[2];
                                eti[0] = new EditableTableItem("Name", elem.getName());
                                eti[1] = elem.getDefstate() != null ? new EditableTableItem("Default State", elem.getDefstate().toString()) : new EditableTableItem("Default State", "");
                            } else if (data instanceof Screen) {
                                Screen screen = (Screen)data;
                                eti = new EditableTableItem[5];
                                eti[0] = new EditableTableItem("Index", screen.getIndex().toString());
                                String x = "";
                                String y = "";
                                String width = "";
                                String height = "";
                                if (screen.getBounds() != null) {
                                    x = screen.getBounds().getX();
                                    y = screen.getBounds().getY();
                                    width = screen.getBounds().getWidth();
                                    height = screen.getBounds().getHeight();
                                }
                                eti[1] = new EditableTableItem("X", x);
                                eti[2] = new EditableTableItem("Y", y);
                                eti[3] = new EditableTableItem("Width", width);
                                eti[4] = new EditableTableItem("Height", height);
                            } else if (data instanceof Mamelayout) {
                                Mamelayout lay = (Mamelayout)data;
                                eti = new EditableTableItem[]{new EditableTableItem("Version", lay.getVersion().toString())};
                            } else if (data instanceof View) {
                                View view = (View)data;
                                eti = new EditableTableItem[]{new EditableTableItem("Name", view.getName())};
                            } else {
                                eti = new EditableTableItem[]{};
                            }
                        }
                        if (ExplorerTree.this.details != null) {
                            if (eti.length > 0) {
                                ExplorerTree.this.details.setContent(eti, data);
                            }
                            ExplorerTree.this.details.setDataObject(data);
                            ExplorerTree.this.details.redraw();
                        }
                        ExplorerTree.this.lastSelected = items[0];
                    }
                }
            }
        });
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource((Control)this.itemsTree, operations);
        source.setTransfer(types);
        final TreeItem[] dragSourceItem = new TreeItem[1];
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = ExplorerTree.this.itemsTree.getSelection();
                if (selection.length > 0 && selection[0].getItemCount() == 0) {
                    event.doit = true;
                    dragSourceItem[0] = selection[0];
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                String dragData = "<DRAG-FROM-EXPLORER-TREE>";
                TreeItem[] selection = ExplorerTree.this.itemsTree.getSelection();
                int i = 0;
                while (i < selection.length) {
                    String value = selection[i].getData().toString();
                    dragData = String.valueOf(dragData) + value;
                    if (i < selection.length - 1) {
                        dragData = String.valueOf(dragData) + "*";
                    }
                    ++i;
                }
                event.data = dragData;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)this.itemsTree, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
            }
        });
    }

    public Tree getItemsTree() {
        return this.itemsTree;
    }

    public TreeItem getMameLayout() {
        return this.root;
    }

    public void registerSelf(Composite panel) {
        this.self = panel;
    }

    public void registerDetailsPanel(DetailsPanel panel) {
        this.details = panel;
    }

    public void registerCanvas(Canvas preview) {
        this.preview = preview;
    }

    public void registerShell(Shell shell) {
        this.mainShell = shell;
    }

    public void registerGC(GC gc) {
        this.gc = gc;
    }

    public void registerLayoutManager(MameLayoutManager mameLayoutManager) {
        this.mameLayoutManager = mameLayoutManager;
    }

    public void registerDependencies(MameLayoutManager mameLayoutManager, GC gc, Shell shell, Canvas previewCanvas, DetailsPanel details, Composite self) {
        this.registerLayoutManager(mameLayoutManager);
        this.registerGC(gc);
        this.registerCanvas(previewCanvas);
        this.registerDetailsPanel(details);
        this.registerSelf(self);
        this.registerShell(shell);
    }

    public void empty() {
        if (this.itemsTree != null) {
            this.itemsTree.removeAll();
        }
    }

    public void populateTree(String path) {
        this.wholePath = path;
        this.empty();
        String fullPath = path = path.substring(0, path.lastIndexOf(PersistentSettings.FILE_SEPARATOR));
        path = path.substring(path.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
        this.root = new TreeItem(this.itemsTree, 0);
        this.root.setText(path);
        this.root.setData((Object)"root");
        this.root.setImage(SWTResourceManager.getImage("icons/file/folder.png"));
        this.listDirectory(fullPath);
    }

    public void listDirectory(String directory) {
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("FileLister: no such directory");
        }
        Object[] files = dir.list();
        Arrays.sort(files);
        int i = 0;
        while (i < files.length) {
            TreeItem file = new TreeItem(this.root, 0);
            file.setText((String)files[i]);
            file.setData((Object)(String.valueOf(directory) + PersistentSettings.FILE_SEPARATOR + (String)files[i]));
            String ext = ((String)files[i]).toUpperCase();
            ext = ext.substring(ext.length() - 3);
            if (ext.endsWith("PNG")) {
                file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
            } else if (ext.endsWith("GIF")) {
                file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
            } else if (ext.endsWith("JPG")) {
                file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
            } else if (ext.endsWith("BMP")) {
                file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
            } else if (ext.endsWith("LAY")) {
                file.setImage(SWTResourceManager.getImage("icons/file/lay.png"));
            } else {
                file.setImage(SWTResourceManager.getImage("icons/file/file.png"));
            }
            ++i;
        }
        this.root.setExpanded(true);
    }

    public TreeItem getLastSelected() {
        return this.lastSelected;
    }

    public void importFile(String fullPath) {
        String path = FileUtils.getPathOnlyFromFullFilename(fullPath);
        String filename = "";
        FileDialog fileChooser = null;
        if (fullPath != null) {
            fileChooser = new FileDialog(this.mainShell, 2);
            if (this.lastpath != null) {
                fileChooser.setFilterPath(this.lastpath);
            } else {
                fileChooser.setFilterPath(path);
            }
            fileChooser.setFilterExtensions(IMPORT_FILTER_EXTENSIONS);
            fileChooser.setFilterNames(IMPORT_FILTER_NAMES);
            filename = fileChooser.open();
            this.lastpath = fileChooser.getFilterPath();
        }
        String[] files = fileChooser.getFileNames();
        System.out.println(">>NO FILES: " + files.length);
        if (files == null || files.length <= 0) {
            return;
        }
        String filenameOnly = "";
        String copyFrom = "";
        String copyTo = "";
        int i = 0;
        int n = files.length;
        while (i < n) {
            filenameOnly = FileUtils.getFilenameOnlyFromFullFilename(files[i]);
            copyFrom = String.valueOf(this.lastpath) + PersistentSettings.FILE_SEPARATOR + files[i];
            copyTo = String.valueOf(path) + filenameOnly;
            File copyToFile = new File(copyTo);
            if (!copyToFile.exists()) {
                System.out.println(">>copyFrom    : " + copyFrom);
                System.out.println(">>copyTO    : " + copyTo);
                try {
                    FileUtils.copyFile(String.valueOf(this.lastpath) + PersistentSettings.FILE_SEPARATOR + files[i], String.valueOf(path) + filenameOnly);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                MessageBox messageBox = new MessageBox(this.mainShell, 33);
                messageBox.setMessage("File: " + copyTo + " already exists in the project");
                messageBox.setText("Error");
                messageBox.open();
            }
            ++i;
        }
        this.populateTree(this.wholePath);
    }

    public void renameFile(String fullPath) {
        TreeItem[] items = this.itemsTree.getSelection();
        if (items.length > 0) {
            TreeItem item = items[0];
            String fileName = FileUtils.getFilenameOnlyFromFullFilename(item.getData().toString());
            String path = FileUtils.getPathOnlyFromFullFilename(item.getData().toString());
            RenameFile dlg = new RenameFile(this.mainShell);
            String value = dlg.open(fileName);
            if (value != null && value.length() > 0 && value != fileName) {
                try {
                    FileUtils.rename(item.getData().toString(), String.valueOf(path) + value);
                }
                catch (Exception e) {
                    MessageBox messageBox = new MessageBox(this.mainShell, 33);
                    messageBox.setMessage("Unable to rename file: " + item.getData().toString() + "\n\nReason\n" + e.getMessage());
                    messageBox.setText("Error");
                    messageBox.open();
                }
            }
        }
        this.populateTree(this.wholePath);
    }

    public void deleteFile(String fullPath) {
        TreeItem[] items = this.itemsTree.getSelection();
        if (items.length > 0) {
            TreeItem item = items[0];
            String fileName = item.getData().toString();
            try {
                MessageBox messageBox = new MessageBox(this.mainShell, 292);
                messageBox.setMessage("Are you sure you want to delete the file: " + fileName + "?");
                messageBox.setText("Confirmation?");
                int ret = messageBox.open();
                if (ret == 32) {
                    FileUtils.delete(fileName);
                }
            }
            catch (Exception e) {
                MessageBox messageBox = new MessageBox(this.mainShell, 33);
                messageBox.setMessage("Unable to delete file: " + item.getData().toString() + "\n\nReason\n" + e.getMessage());
                messageBox.setText("Error");
                messageBox.open();
            }
        }
        this.populateTree(this.wholePath);
    }
}

