/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.ui;

import java.math.BigInteger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import uk.co.pembo.agemame.ui.EditableTableItem;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Bounds;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;

public class DetailsPanel
extends Composite {
    private EditableTableItem[] content = new EditableTableItem[0];
    private Canvas preview;
    private static final String NAME_PROPERTY = "Name";
    private static final String VALUE_PROPERTY = "Value";
    private TableViewer viewer;
    private Object dataObject;

    public DetailsPanel(Composite parent) {
        super(parent, 0);
        this.buildControls();
    }

    protected void buildControls() {
        FillLayout compositeLayout = new FillLayout();
        this.setLayout((Layout)compositeLayout);
        Table table = new Table((Composite)this, 67584);
        this.viewer = this.buildAndLayoutTable(table);
        this.attachContentProvider(this.viewer);
        this.attachLabelProvider(this.viewer);
        this.attachCellEditors(this.viewer, (Composite)table);
        this.viewer.setInput((Object)this.content);
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((EditableTableItem)element).name;
                    }
                    case 1: {
                        return ((EditableTableItem)element).value;
                    }
                }
                return "Invalid column: " + columnIndex;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener lpl) {
            }
        });
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    private TableViewer buildAndLayoutTable(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        table.setLayout((Layout)layout);
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(NAME_PROPERTY);
        TableColumn valColumn = new TableColumn(table, 16384);
        valColumn.setText(VALUE_PROPERTY);
        table.setHeaderVisible(true);
        return tableViewer;
    }

    private void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return !property.equals(DetailsPanel.NAME_PROPERTY);
            }

            public Object getValue(Object element, String property) {
                if (DetailsPanel.NAME_PROPERTY.equals(property)) {
                    return ((EditableTableItem)element).name;
                }
                return ((EditableTableItem)element).value;
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                EditableTableItem data = (EditableTableItem)tableItem.getData();
                if (DetailsPanel.NAME_PROPERTY.equals(property)) {
                    data.name = value.toString();
                } else {
                    data.value = value.toString();
                }
                viewer.refresh((Object)data);
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), new TextCellEditor(parent)});
        viewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY});
    }

    public EditableTableItem[] getContent() {
        return this.content;
    }

    public void setContent(EditableTableItem[] content, Object data) {
        if (this.content.length > 0 && data != this.dataObject) {
            if (this.dataObject instanceof Mamelayout) {
                Mamelayout layout = (Mamelayout)this.dataObject;
                layout.setVersion(new BigInteger(this.content[0].value));
            } else if (this.dataObject instanceof Backdrop) {
                Backdrop backdrop = (Backdrop)this.dataObject;
                backdrop.setName(this.content[0].value);
                try {
                    backdrop.setState(Integer.parseInt(this.content[1].value));
                }
                catch (NumberFormatException e) {
                    backdrop.setState(0);
                }
                Bounds b = new Bounds();
                b.setX(this.content[2].value);
                b.setY(this.content[3].value);
                b.setWidth(this.content[4].value);
                b.setHeight(this.content[5].value);
                backdrop.setBounds(b);
            }
        }
        this.content = content;
        this.dataObject = data;
        this.viewer.setInput((Object)content);
    }

    public void registerCanvas(Canvas preview) {
        this.preview = preview;
    }

    public void setDataObject(Object obj) {
        this.dataObject = obj;
    }
}

