/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.swtrender;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Bounds;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Disk;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Screen;
import uk.co.pembo.agemame.xmlbinding.mamelayout.View;

public class LayoutRenderer {
    public int largestWidth = 0;
    public int largestHeight = 0;
    private Display display;
    private MameLayoutManager mameLayoutManager;
    private static Logger log = Logger.getLogger(LayoutRenderer.class.getPackage().getName());

    public LayoutRenderer(Display display, MameLayoutManager mameLayoutManager) {
        this.display = display;
        this.mameLayoutManager = mameLayoutManager;
    }

    public void paintLayout(GC gc) {
        Mamelayout layout = this.mameLayoutManager.getMameLayout();
        List<View> views = layout.getView();
        int viewIndex = 0;
        while (viewIndex < views.size()) {
            View view = views.get(viewIndex);
            this.paintView(gc, view);
            ++viewIndex;
        }
    }

    private void paintView(GC gc, View view) {
        log.finest("Rendering view [" + view.getName() + "]");
        List<Screen> screens = view.getScreen();
        List<Backdrop> backdrops = view.getBackdrop();
        int backdropIndex = 0;
        while (backdropIndex < backdrops.size()) {
            Backdrop backdrop = backdrops.get(backdropIndex);
            this.paintBackdrop(gc, backdrop);
            ++backdropIndex;
        }
        int screenIndex = 0;
        while (screenIndex < screens.size()) {
            Screen screen = screens.get(screenIndex);
            this.paintScreen(gc, screen);
            ++screenIndex;
        }
    }

    private void paintScreen(GC gc, Screen screen) {
        Bounds b = screen.getBounds();
        Coordinates coords = new Coordinates(b);
        gc.setLineStyle(1);
        gc.setLineWidth(3);
        gc.setForeground(new Color(gc.getDevice(), 255, 0, 0));
        gc.drawRectangle(coords.x, coords.y, coords.width, coords.height);
    }

    private void paintBackdrop(GC gc, Backdrop backdrop) {
        String elementName = backdrop.getElement();
        if (backdrop.getBounds() != null) {
            Coordinates coords = new Coordinates(backdrop.getBounds());
            Element element = this.mameLayoutManager.getElementByName(elementName);
            this.paintElement(gc, element, coords);
        }
    }

    private void paintElement(GC gc, Element element, Coordinates coords) {
        List<uk.co.pembo.agemame.xmlbinding.mamelayout.Image> images = element.getImage();
        List<Disk> disks = element.getDisk();
        disks.size();
        if (images.size() >= 1) {
            uk.co.pembo.agemame.xmlbinding.mamelayout.Image image = images.get(0);
            this.paintImage(gc, image, coords);
        }
    }

    private void paintImage(GC gc, uk.co.pembo.agemame.xmlbinding.mamelayout.Image image, Coordinates coords) {
        int srcHeight = -1;
        int srcWidth = -1;
        Image swtImage = this.mameLayoutManager.getImage((Device)this.display, image);
        srcHeight = swtImage.getBounds().height;
        srcWidth = swtImage.getBounds().width;
        gc.drawImage(swtImage, 0, 0, srcWidth, srcHeight, coords.x, coords.y, coords.width, coords.height);
    }

    class Coordinates {
        public int x = 0;
        public int y = 0;
        public int width = 0;
        public int height = 0;

        public Coordinates(Bounds b, GC gc) {
        }

        public Coordinates(Bounds b) {
            if (b.getLeft() != null && b.getLeft().length() > 0) {
                this.x = new Float(b.getLeft()).intValue();
                this.y = new Float(b.getTop()).intValue();
                this.width = new Float(b.getRight()).intValue() - new Float(b.getLeft()).intValue();
                this.height = new Float(b.getBottom()).intValue() - new Float(b.getTop()).intValue();
            } else {
                this.x = new Float(b.getX()).intValue();
                this.y = new Float(b.getY()).intValue();
                this.width = new Float(b.getWidth()).intValue();
                this.height = new Float(b.getHeight()).intValue();
            }
            if (this.width > LayoutRenderer.this.largestWidth) {
                LayoutRenderer.this.largestWidth = this.width;
            }
            if (this.height > LayoutRenderer.this.largestHeight) {
                LayoutRenderer.this.largestHeight = this.height;
            }
        }
    }
}

