/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.xmlbinding;

import java.math.BigInteger;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;
import uk.co.pembo.agemame.xmlbinding.LayoutChanger;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.util.PersistentSettings;

public class DragAndDropController {
    public static final String ELEMENT_TREE_ITEM = "<ELEMENTS>";
    public static final String DRAG_FROM_EXPLORER_TREE = "<DRAG-FROM-EXPLORER-TREE>";
    public MameLayoutManager mameLayoutManager;

    public DragAndDropController(MameLayoutManager mameLayoutManager) {
        this.mameLayoutManager = mameLayoutManager;
    }

    public void dragDropEvent(DropTargetEvent event) {
        if (event.item == null) {
            return;
        }
        TreeItem itemDroppedOn = (TreeItem)event.item;
        String dataDropped = (String)event.data;
        this.checkForDragFromExplorerToElements(itemDroppedOn, dataDropped);
    }

    private void checkForDragFromExplorerToElements(TreeItem itemDroppedOn, String dataDropped) {
        String fileName;
        int i;
        LayoutChanger changer;
        String newElementData;
        String droppedItemData;
        if (itemDroppedOn.getData() instanceof String && (droppedItemData = itemDroppedOn.getData().toString()).equals(ELEMENT_TREE_ITEM) && dataDropped.startsWith(DRAG_FROM_EXPLORER_TREE)) {
            newElementData = dataDropped;
            newElementData = newElementData.substring(DRAG_FROM_EXPLORER_TREE.length());
            String[] elements = newElementData.split("\\*");
            changer = this.mameLayoutManager.getLayoutChanger();
            i = 0;
            while (i < elements.length) {
                fileName = elements[i];
                fileName = fileName.substring(fileName.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
                String name = fileName.substring(0, fileName.indexOf("."));
                Element elem = changer.newElement(name, new BigInteger("0"));
                Image image = changer.newImage(fileName, null, new BigInteger("1"));
                changer.addImageToElement(elem, image);
                changer.addElement(elem);
                ++i;
            }
        }
        if (itemDroppedOn.getData() instanceof Element && dataDropped.startsWith(DRAG_FROM_EXPLORER_TREE)) {
            Element elem = (Element)itemDroppedOn.getData();
            newElementData = dataDropped;
            newElementData = newElementData.substring(DRAG_FROM_EXPLORER_TREE.length());
            String[] images = newElementData.split("\\*");
            changer = this.mameLayoutManager.getLayoutChanger();
            i = 0;
            while (i < images.length) {
                fileName = images[i];
                fileName = fileName.substring(fileName.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
                BigInteger lastState = elem.getImage().get(elem.getImage().size() - 1).getState();
                lastState = lastState.add(new BigInteger("1"));
                Image image = changer.newImage(fileName, null, lastState);
                changer.addImageToElement(elem, image);
                ++i;
            }
        }
    }
}

