/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.userinterface;

import java.io.IOException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.util.PersistentSettings;

public class ManageConfiguration
extends Dialog {
    private Text proxyPort;
    private Text proxyHost;
    private Text updateSavePath;
    private Button noButton;
    private Button yesButton;
    private Button cancelButton;
    private Button finishButton;
    private Text updateURL;
    protected Object result;
    protected Shell shell;
    private String updateURLStr = PersistentSettings.getPropertyValue("UPDATE.URL", "http://www.dpembo.ukfsn.org/agemame/release/update/");
    private String savePathStr;
    private String autoUpdateStr = PersistentSettings.getPropertyValue("UPDATE.AUTO", "./lib/");
    private String proxyHostStr;
    private String proxyPortStr;

    public ManageConfiguration(Shell parent, int style) {
        super(parent, style);
        this.savePathStr = PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION", "false");
        this.proxyHostStr = PersistentSettings.getPropertyValue("proxyHost", "");
        this.proxyPortStr = PersistentSettings.getPropertyValue("proxyPort", "");
    }

    public ManageConfiguration(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setSize(600, 550);
        this.shell.setText("Install/Update");
        int guessWidth = 600;
        int guessHeigh = 550;
        this.shell.setLocation((this.getParent().getSize().x - guessWidth) / 2, (this.getParent().getSize().y - guessHeigh) / 2);
        Composite composite = new Composite((Composite)this.shell, 0x1000800);
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        composite.setBounds(0, 0, 594, 67);
        Canvas canvas = new Canvas(composite, 0);
        canvas.setBackground(Display.getCurrent().getSystemColor(1));
        canvas.setBounds(515, 0, 77, 64);
        canvas.setBackgroundImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "dialogs/findAndInstall.gif"));
        Label updateAgemameLayoutLabel = new Label(composite, 0);
        updateAgemameLayoutLabel.setFont(SWTResourceManager.getFont("", 10, 1));
        updateAgemameLayoutLabel.setBackground(Display.getCurrent().getSystemColor(1));
        updateAgemameLayoutLabel.setText("Manage Configuration");
        updateAgemameLayoutLabel.setBounds(10, 10, 237, 16);
        Label checkForLaterLabel = new Label(composite, 0);
        checkForLaterLabel.setBackground(Display.getCurrent().getSystemColor(1));
        checkForLaterLabel.setText("Manage Update Configuration for AGEMAME Layout Editor");
        checkForLaterLabel.setBounds(10, 30, 378, 13);
        Group configurationGroup = new Group((Composite)this.shell, 0);
        configurationGroup.setText("Update Configuration");
        configurationGroup.setBounds(10, 87, 574, 106);
        Label updateServerLabel = new Label((Composite)configurationGroup, 0);
        updateServerLabel.setText("Update Server URL:");
        updateServerLabel.setBounds(10, 32, 96, 13);
        this.updateURL = new Text((Composite)configurationGroup, 2048);
        this.updateURL.setBounds(114, 27, 452, 25);
        this.updateURL.setText(this.updateURLStr);
        Label checkForNewLabel = new Label((Composite)configurationGroup, 0);
        checkForNewLabel.setText("Check for New Version on Start Up:");
        checkForNewLabel.setBounds(10, 67, 175, 13);
        this.yesButton = new Button((Composite)configurationGroup, 16);
        this.yesButton.setText("Yes");
        this.yesButton.setBounds(191, 65, 38, 16);
        this.noButton = new Button((Composite)configurationGroup, 16);
        this.noButton.setText("No");
        this.noButton.setBounds(239, 65, 38, 16);
        if (this.autoUpdateStr.equals("true")) {
            this.yesButton.setSelection(true);
            this.noButton.setSelection(false);
        } else {
            this.yesButton.setSelection(false);
            this.noButton.setSelection(true);
        }
        this.cancelButton = new Button((Composite)this.shell, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ManageConfiguration.this.shell.close();
            }
        });
        this.cancelButton.setBounds(494, 456, 90, 23);
        this.cancelButton.setText("Cancel");
        this.finishButton = new Button((Composite)this.shell, 0);
        this.finishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String val = ManageConfiguration.this.yesButton.getSelection() ? "true" : "false";
                PersistentSettings.setProperty("UPDATE.AUTO", val);
                PersistentSettings.setProperty("UPDATE.SAVELOCATION", ManageConfiguration.this.updateSavePath.getText());
                PersistentSettings.setProperty("UPDATE.URL", ManageConfiguration.this.updateURL.getText());
                PersistentSettings.setProperty("proxyHost", ManageConfiguration.this.getProxyHost().getText());
                PersistentSettings.setProperty("proxyPort", ManageConfiguration.this.getProxyPort().getText());
                PersistentSettings.setProxyIfRequired();
                ManageConfiguration.this.shell.close();
            }
        });
        this.finishButton.setBounds(398, 456, 90, 23);
        this.finishButton.setText("Finish");
        Group advanceConfigurationGroup = new Group((Composite)this.shell, 0);
        advanceConfigurationGroup.setText("Advanced Configuration");
        advanceConfigurationGroup.setBounds(10, 311, 574, 90);
        Label updatePathLabel = new Label((Composite)advanceConfigurationGroup, 0);
        updatePathLabel.setText("Update Save Path:");
        updatePathLabel.setBounds(12, 45, 96, 13);
        this.updateSavePath = new Text((Composite)advanceConfigurationGroup, 2048);
        this.updateSavePath.setBounds(114, 42, 450, 25);
        this.updateSavePath.setText(this.savePathStr);
        Group proxyServerSettingsGroup = new Group((Composite)this.shell, 0);
        proxyServerSettingsGroup.setText("Proxy Server Settings");
        proxyServerSettingsGroup.setBounds(10, 199, 574, 99);
        Label httpProxyServerLabel = new Label((Composite)proxyServerSettingsGroup, 0);
        httpProxyServerLabel.setText("Proxy Host:");
        httpProxyServerLabel.setBounds(10, 32, 93, 13);
        Label portLabel = new Label((Composite)proxyServerSettingsGroup, 0);
        portLabel.setText("Proxy Port:");
        portLabel.setBounds(10, 58, 87, 13);
        this.proxyHost = new Text((Composite)proxyServerSettingsGroup, 2048);
        this.proxyHost.setBounds(114, 26, 449, 25);
        this.proxyHost.setText(this.proxyHostStr);
        this.proxyPort = new Text((Composite)proxyServerSettingsGroup, 2048);
        this.proxyPort.setBounds(114, 54, 141, 25);
        this.proxyPort.setText(this.proxyPortStr);
    }

    public void downloadLatestVersion(Text text) {
        try {
            this.checkForLaterVersion(text);
            text.redraw();
            if (text.getText().indexOf("UPDATE REQUIRED") >= 0) {
                text.setText(String.valueOf(text.getText()) + "\r\nDownloading update from server...\r\n");
                text.redraw();
                UpdateDetails d = CheckForUpdates.checkLatestVersion(this.updateURL.getText());
                CheckForUpdates.downloadUpdate(this.updateURL.getText());
                text.setText(String.valueOf(text.getText()) + "Update download completed\r\n");
            } else {
                text.setText(String.valueOf(text.getText()) + "\r\nNo update downloaded\r\n");
            }
            text.redraw();
        }
        catch (Exception e) {
            e.printStackTrace();
            text.setText(String.valueOf(text.getText()) + "Error Contacting Update Server: " + this.updateURL.getText() + "\n\n" + e.toString());
        }
    }

    public void checkForLaterVersion(Text text) {
        try {
            text.setEnabled(true);
            text.setText("AGEMAME Layout Editor Update Check\r\n");
            text.setText(String.valueOf(text.getText()) + "Current Version: " + Version.getVersion() + "[" + Version.getNumericVersion() + "] \r\n");
            text.setText(String.valueOf(text.getText()) + "Contacting Update Server [" + this.updateURL.getText() + "]... \r\n");
            text.redraw();
            UpdateDetails d = CheckForUpdates.checkLatestVersion(this.updateURL.getText());
            text.setText(String.valueOf(text.getText()) + "Version on update server: " + d.getVersion() + "\r\n\r\n");
            boolean isUptoDate = CheckForUpdates.isVersionUptoDate(d);
            if (!isUptoDate) {
                text.setText(String.valueOf(text.getText()) + "*****************************************\r\n");
                text.setText(String.valueOf(text.getText()) + "AGEMAME Layout Editor UPDATE REQUIRED!\r\n");
                text.setText(String.valueOf(text.getText()) + "*****************************************\r\n");
            } else {
                text.setText(String.valueOf(text.getText()) + "AGEMAME Layout Editor is the latest version.  Update NOT required.\r\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            text.setText(String.valueOf(text.getText()) + "Error Contacting Update Server: " + this.updateURL.getText() + "\n\n" + e.toString());
        }
    }

    public Text getUpdateURL() {
        return this.updateURL;
    }

    public Button getFinishButton() {
        return this.finishButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getYesButton() {
        return this.yesButton;
    }

    public Button getNoButton() {
        return this.noButton;
    }

    public Text getUpdateSavePath() {
        return this.updateSavePath;
    }

    public Text getProxyHost() {
        return this.proxyHost;
    }

    public Text getProxyPort() {
        return this.proxyPort;
    }
}

