/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.userinterface;

import java.io.IOException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.util.PersistentSettings;

public class FindAndInstall
extends Dialog {
    private StyledText styledText;
    private Button checkLaterVersion;
    private Button checkAndUpdateButton;
    private Button cancelButton;
    private Button finishButton;
    private Text updateURL;
    protected Object result;
    protected Shell shell;
    protected boolean updated = false;
    private String updateURLStr = PersistentSettings.getPropertyValue("UPDATE.URL");

    public FindAndInstall(Shell parent, int style) {
        super(parent, style);
        if (this.updateURLStr == null || this.updateURLStr.length() == 0) {
            this.updateURLStr = "http://www.dpembo.ukfsn.org/agemame/release/update/";
        }
    }

    public FindAndInstall(Shell parent) {
        this(parent, 0);
    }

    public Object open(boolean runAutoCheck) {
        this.createContents(runAutoCheck);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents(boolean runAutoCheck) {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setSize(600, 550);
        this.shell.setText("Install/Update");
        int guessWidth = 600;
        int guessHeigh = 550;
        this.shell.setLocation((this.getParent().getSize().x - guessWidth) / 2, (this.getParent().getSize().y - guessHeigh) / 2);
        Composite composite = new Composite((Composite)this.shell, 0x1000800);
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        composite.setBounds(0, 0, 594, 67);
        Canvas canvas = new Canvas(composite, 0);
        canvas.setBackground(Display.getCurrent().getSystemColor(1));
        canvas.setBounds(515, 0, 77, 64);
        canvas.setBackgroundImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "dialogs/findAndInstall.gif"));
        Label updateAgemameLayoutLabel = new Label(composite, 0);
        updateAgemameLayoutLabel.setFont(SWTResourceManager.getFont("", 10, 1));
        updateAgemameLayoutLabel.setBackground(Display.getCurrent().getSystemColor(1));
        updateAgemameLayoutLabel.setText("Update AGEMAME Layout Editor");
        updateAgemameLayoutLabel.setBounds(10, 10, 237, 13);
        Label checkForLaterLabel = new Label(composite, 0);
        checkForLaterLabel.setBackground(Display.getCurrent().getSystemColor(1));
        checkForLaterLabel.setText("Check for later versions of AGEMAME Layout Editor and update if required");
        checkForLaterLabel.setBounds(10, 30, 378, 13);
        this.checkAndUpdateButton = new Button((Composite)this.shell, 0);
        this.checkAndUpdateButton.setEnabled(true);
        this.checkAndUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindAndInstall.this.downloadLatestVersion(FindAndInstall.this.getStyledText());
                FindAndInstall.this.finishButton.setEnabled(true);
            }
        });
        this.checkAndUpdateButton.setText("Check and Update");
        this.checkAndUpdateButton.setBounds(292, 456, 100, 23);
        this.checkLaterVersion = new Button((Composite)this.shell, 0);
        this.checkLaterVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindAndInstall.this.checkForLaterVersion(FindAndInstall.this.getStyledText());
                FindAndInstall.this.finishButton.setEnabled(true);
            }
        });
        this.checkLaterVersion.setBounds(163, 456, 124, 23);
        this.checkLaterVersion.setText("Check for Later Version");
        this.cancelButton = new Button((Composite)this.shell, 0);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindAndInstall.this.shell.close();
            }
        });
        this.cancelButton.setBounds(494, 456, 90, 23);
        this.cancelButton.setText("Cancel");
        this.finishButton = new Button((Composite)this.shell, 0);
        this.finishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PersistentSettings.setProperty("UPDATE.URL", FindAndInstall.this.updateURL.getText());
                if (FindAndInstall.this.updated) {
                    PersistentSettings.writePropertiesFile();
                    System.exit(0);
                }
                FindAndInstall.this.shell.close();
            }
        });
        this.finishButton.setEnabled(false);
        this.finishButton.setBounds(398, 456, 90, 23);
        this.finishButton.setText("Finish");
        Group updateDetailsGroup = new Group((Composite)this.shell, 0);
        updateDetailsGroup.setBounds(10, 73, 584, 362);
        updateDetailsGroup.setText("Check/Update Details");
        this.styledText = new StyledText((Composite)updateDetailsGroup, 2626);
        this.styledText.setBounds(10, 28, 554, 324);
        this.updateURL = new Text((Composite)this.shell, 2048);
        this.updateURL.setVisible(false);
        this.updateURL.setBounds(115, 485, 469, 25);
        this.updateURL.setText(this.updateURLStr);
        Label updateServerLabel = new Label((Composite)this.shell, 0);
        updateServerLabel.setVisible(false);
        updateServerLabel.setBounds(10, 488, 79, 13);
        updateServerLabel.setText("Update Server:");
        if (runAutoCheck) {
            this.checkForLaterVersion(this.getStyledText());
        }
    }

    public void downloadLatestVersion(StyledText text) {
        try {
            this.checkForLaterVersion(text);
            if (text.getText().indexOf("UPDATE REQUIRED") >= 0) {
                text.setText(String.valueOf(text.getText()) + "\r\n!Downloading update from server...\r\n");
                text.redraw();
                UpdateDetails d = CheckForUpdates.checkLatestVersion(this.updateURL.getText());
                CheckForUpdates.downloadUpdate(this.updateURL.getText());
                text.setText(String.valueOf(text.getText()) + "Download of Update complete - Press finish to exit AGEMAME Layout Editor and then restart the application.\r\n");
                this.updated = true;
                this.getCheckAndUpdateButton().setEnabled(false);
                this.getCheckLaterVersion().setEnabled(false);
            } else {
                text.setText(String.valueOf(text.getText()) + "\r\n!No update downloaded\r\n");
                this.updated = false;
            }
            StyleRange styleRange1 = new StyleRange();
            styleRange1.start = 0;
            styleRange1.length = 34;
            styleRange1.fontStyle = 1;
            int start = text.getText().indexOf("*");
            int end = text.getText().lastIndexOf("*");
            StyleRange styleRange2 = new StyleRange();
            if (start > 0 && end > 0 && end > start) {
                styleRange2.start = start;
                styleRange2.length = end - start + 1;
                styleRange2.foreground = this.shell.getDisplay().getSystemColor(3);
            } else {
                end = text.getText().indexOf("!");
                styleRange2.start = start;
                styleRange2.length = end - start;
                styleRange2.foreground = this.shell.getDisplay().getSystemColor(6);
            }
            text.setStyleRanges(new StyleRange[]{styleRange1, styleRange2});
            text.redraw();
        }
        catch (Exception e) {
            int start;
            e.printStackTrace();
            text.setText(String.valueOf(text.getText()) + "Error Contacting Update Server: " + this.updateURL.getText() + "\n\n" + e.toString());
            StyleRange styleRange2 = new StyleRange();
            styleRange2.start = start = text.getText().indexOf("Error Contact");
            int end = text.getText().length();
            styleRange2.length = end - start;
            styleRange2.foreground = this.shell.getDisplay().getSystemColor(3);
            text.setStyleRange(styleRange2);
            text.redraw();
        }
    }

    public void checkForLaterVersion(StyledText text) {
        try {
            text.setEnabled(true);
            text.setText("AGEMAME Layout Editor Update Check\r\n");
            text.setText(String.valueOf(text.getText()) + "Current Version: " + Version.getVersion() + "[" + Version.getNumericVersion() + "] \r\n");
            text.setText(String.valueOf(text.getText()) + "Contacting Update Server [" + this.updateURL.getText() + "]... \r\n");
            text.redraw();
            UpdateDetails d = CheckForUpdates.checkLatestVersion(this.updateURL.getText());
            text.setText(String.valueOf(text.getText()) + "Version on update server: " + d.getVersion() + "\r\n\r\n");
            boolean isUptoDate = CheckForUpdates.isVersionUptoDate(d);
            if (!isUptoDate) {
                text.setText(String.valueOf(text.getText()) + "*****************************************\r\n");
                text.setText(String.valueOf(text.getText()) + "AGEMAME Layout Editor UPDATE REQUIRED!\r\n");
                text.setText(String.valueOf(text.getText()) + "*****************************************\r\n");
            } else {
                text.setText(String.valueOf(text.getText()) + "*AGEMAME Layout Editor is the latest version.  Update NOT required.\r\n");
            }
            StyleRange styleRange1 = new StyleRange();
            styleRange1.start = 0;
            styleRange1.length = 34;
            styleRange1.fontStyle = 1;
            int start = text.getText().indexOf("*");
            int end = text.getText().lastIndexOf("*");
            StyleRange styleRange2 = new StyleRange();
            if (start > 0 && end > 0 && end > start) {
                styleRange2.start = start;
                styleRange2.length = end - start + 1;
                styleRange2.foreground = this.shell.getDisplay().getSystemColor(3);
            } else {
                end = text.getText().length();
                styleRange2.start = start;
                styleRange2.length = end - start;
                styleRange2.foreground = this.shell.getDisplay().getSystemColor(6);
            }
            text.setStyleRanges(new StyleRange[]{styleRange1, styleRange2});
            text.redraw();
            this.getCheckLaterVersion().setEnabled(false);
        }
        catch (IOException e) {
            int start;
            e.printStackTrace();
            text.setText(String.valueOf(text.getText()) + "Error Contacting Update Server: " + this.updateURL.getText() + "\n\n" + e.toString());
            StyleRange styleRange2 = new StyleRange();
            styleRange2.start = start = text.getText().indexOf("Error Contact");
            int end = text.getText().length();
            styleRange2.length = end - start;
            styleRange2.foreground = this.shell.getDisplay().getSystemColor(3);
            text.setStyleRange(styleRange2);
        }
    }

    public Text getUpdateURL() {
        return this.updateURL;
    }

    public Button getFinishButton() {
        return this.finishButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getCheckAndUpdateButton() {
        return this.checkAndUpdateButton;
    }

    public Button getCheckLaterVersion() {
        return this.checkLaterVersion;
    }

    public StyledText getStyledText() {
        return this.styledText;
    }
}

