/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.util;

import java.util.LinkedList;

public class ThreadPool
extends ThreadGroup {
    private boolean isAlive;
    private LinkedList taskQueue;
    private int threadID;
    private static int threadPoolID;

    public ThreadPool(int numThreads) {
        super("ThreadPool-" + threadPoolID++);
        this.setDaemon(true);
        this.isAlive = true;
        this.taskQueue = new LinkedList();
        int i = 0;
        while (i < numThreads) {
            new PooledThread().start();
            ++i;
        }
    }

    public synchronized void runTask(Runnable task) {
        if (!this.isAlive) {
            throw new IllegalStateException();
        }
        if (task != null) {
            this.taskQueue.add(task);
            this.notify();
        }
    }

    protected synchronized Runnable getTask() throws InterruptedException {
        while (this.taskQueue.size() == 0) {
            if (!this.isAlive) {
                return null;
            }
            this.wait();
        }
        return (Runnable)this.taskQueue.removeFirst();
    }

    public synchronized void close() {
        if (this.isAlive) {
            this.isAlive = false;
            this.taskQueue.clear();
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.isAlive = false;
            this.notifyAll();
        }
        Thread[] threads = new Thread[this.activeCount()];
        int count = this.enumerate(threads);
        int i = 0;
        while (i < count) {
            try {
                threads[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    protected void threadStarted() {
    }

    protected void threadStopped() {
    }

    private class PooledThread
    extends Thread {
        public PooledThread() {
            StringBuilder stringBuilder = new StringBuilder("PooledThread-");
            ThreadPool threadPool2 = ThreadPool.this;
            int n = threadPool2.threadID;
            threadPool2.threadID = n + 1;
            super((ThreadGroup)ThreadPool.this, stringBuilder.append(n).toString());
        }

        public void run() {
            ThreadPool.this.threadStarted();
            while (!this.isInterrupted()) {
                Runnable task = null;
                try {
                    task = ThreadPool.this.getTask();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (task == null) break;
                try {
                    task.run();
                }
                catch (Throwable t) {
                    ThreadPool.this.uncaughtException(this, t);
                }
            }
            ThreadPool.this.threadStopped();
        }
    }
}

