/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.userinterface;

import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.graphics.SWTResourceManager;
import uk.co.pembo.util.PersistentSettings;

public class NewVersionInfo
extends Dialog {
    private Text text;
    private Label updatingLabel;
    private Button okButton;
    protected Object result;
    protected Shell shell;
    private boolean exit = false;
    private static Logger log = Logger.getLogger(NewVersionInfo.class.getPackage().getName());

    public NewVersionInfo(Shell parent, int style) {
        super(parent, style);
    }

    public NewVersionInfo(Shell parent) {
        this(parent, 0);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        String updateURLStr = PersistentSettings.getPropertyValue("UPDATE.URL");
        if (updateURLStr == null || updateURLStr.length() == 0) {
            updateURLStr = "http://www.dpembo.ukfsn.org/agemame/release/update/";
        }
        if (!updateURLStr.endsWith("/")) {
            updateURLStr = String.valueOf(updateURLStr) + "/";
        }
        try {
            Class<?> c = Class.forName("javax.xml.bind.JAXB");
            log.finest("JAXB Jar files found");
            this.updatingLabel.setVisible(false);
            this.updatingLabel.setVisible(false);
            this.text.setVisible(true);
            this.shell.setText("AGEMAME Layout Editor has been updated to version " + Version.getVersion() + "!");
            this.okButton.setEnabled(true);
        }
        catch (ClassNotFoundException e) {
            this.updatingLabel.setVisible(true);
            try {
                log.warning("JAXB Jar files not present - downloading files");
                CheckForUpdates.GetURL(String.valueOf(updateURLStr) + "lib/jsr173_1.0_api.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "jsr173_1.0_api.jar");
                CheckForUpdates.GetURL(String.valueOf(updateURLStr) + "lib/jaxb-impl.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "jaxb-impl.jar");
                CheckForUpdates.GetURL(String.valueOf(updateURLStr) + "lib/jaxb-api.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "jaxb-api.jar");
                CheckForUpdates.GetURL(String.valueOf(updateURLStr) + "lib/activation.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "activation.jar");
                log.info("Downloaded JAXB Jars");
                PersistentSettings.setProperty("currentVersion", "");
                PersistentSettings.writePropertiesFile();
                this.updatingLabel.setText("Update downloaded successfully\nAGEMAME Layout Editor requires restarting.\n\nPress OK to exit the AGEMAME Layout Editor");
                this.shell.setText("AGEMAME Layout Editor Needs to be restarted");
                this.exit = true;
            }
            catch (Exception e1) {
                this.text.setText("Cannot download JAXB libraries - ALE Will not function correctly [" + e1.getMessage() + "]");
                this.text.setVisible(true);
                log.severe("Cannot download JAXB libraries - ALE Will not function correctly [" + e1.getMessage() + "]");
                e1.printStackTrace();
            }
        }
        this.okButton.setEnabled(true);
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public void setText(String value) {
        this.text.setText(value);
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.shell.setSize(615, 620);
        int guessWidth = 615;
        int guessHeigh = 620;
        this.shell.setLocation((this.getParent().getSize().x - guessWidth) / 2, (this.getParent().getSize().y - guessHeigh) / 2);
        this.shell.setText("Downloading Update... Please wait");
        this.okButton = new Button((Composite)this.shell, 0);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (NewVersionInfo.this.exit) {
                    System.exit(0);
                } else {
                    NewVersionInfo.this.shell.close();
                }
            }
        });
        this.okButton.setEnabled(false);
        this.okButton.setText("OK");
        this.okButton.setBounds(501, 541, 81, 23);
        this.text = new Text((Composite)this.shell, 2626);
        this.text.setVisible(false);
        this.text.setEditable(false);
        this.text.setBounds(10, 10, 589, 509);
        this.text.setText(Version.getUpdateText());
        this.updatingLabel = new Label((Composite)this.shell, 0);
        this.updatingLabel.setAlignment(0x1000000);
        this.updatingLabel.setFont(SWTResourceManager.getFont("", 10, 1));
        this.updatingLabel.setText("AGEMAME Layout Editor is downloading an update - please wait.");
        this.updatingLabel.setBounds(94, 244, 443, 79);
    }
}

