/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.userinterface;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import uk.co.pembo.agemame.exception.LayoutParseException;
import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.swtrender.LayoutRenderer;
import uk.co.pembo.agemame.swtrender.SourceRenderer;
import uk.co.pembo.agemame.ui.DetailsPanel;
import uk.co.pembo.agemame.ui.ExplorerTree;
import uk.co.pembo.agemame.ui.ItemsTree;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.agemame.userinterface.AboutDialog;
import uk.co.pembo.agemame.userinterface.FindAndInstall;
import uk.co.pembo.agemame.userinterface.GuiMenuHandling;
import uk.co.pembo.agemame.userinterface.ManageConfiguration;
import uk.co.pembo.agemame.userinterface.NewVersionInfo;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.io.FileUtils;
import uk.co.pembo.util.PersistentSettings;

public class MainApplication {
    private static boolean newVersion = false;
    public MameLayoutManager layoutManager;
    public LayoutRenderer swtLayoutRenderer;
    public SourceRenderer swtSourceRenderer;
    private Text consoleText;
    private Label statusBarCaption;
    public String paramFileName = null;
    public String lastPath;
    public String currentLayoutFile;
    public int sourcePos = 0;
    public GC imageCanvasGC;
    private Text layoutXml;
    private TabFolder tabFolder_1;
    private Composite textViewComposite;
    private Canvas previewCanvas;
    private Composite consoleComposite;
    private Composite problemsComposite;
    private ProgressBar statusProgressBar;
    private Shell agemameLayoutEditorShell;
    private Display display;
    private ItemsTree itemsPanel;
    private ExplorerTree explorerPanel;
    private DetailsPanel details;
    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private ApplicationHandler handler = new ApplicationHandler();
    private static Logger log = Logger.getLogger(MainApplication.class.getPackage().getName());
    private int bottomHeight = 0;
    private int topHeight = 0;
    private MenuItem saveas;
    private MenuItem save;
    private ToolItem saveToolbarItem;
    private ToolItem refreshToolbarItem;
    private Cursor crossCursor;

    public static void main(String[] args) {
        try {
            System.setProperty("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true");
            MainApplication window = new MainApplication();
            PersistentSettings.loadPropertiesFile();
            PersistentSettings.initProperties();
            Logger.getLogger("uk.co.pembo").setLevel(Level.INFO);
            Logger.getLogger("com.fruitforums").setLevel(Level.INFO);
            Logger.getLogger("uk.co.pembo").addHandler(window.handler);
            Logger.getLogger("com.fruitforums").addHandler(window.handler);
            window.open();
            window.checkandOpenCommandLineLayout(args, window);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkandOpenCommandLineLayout(String[] args, MainApplication window) {
        if (args.length > 0) {
            window.paramFileName = args[0];
        }
    }

    public void open() {
        this.display = Display.getDefault();
        int height = this.display.getBounds().height;
        int width = this.display.getBounds().width;
        int diff = 0;
        if (width > 1280) {
            diff = width - 1280;
        }
        int leftExtraToAdd = 0;
        int midExtraToAdd = 0;
        int rightExtraToAdd = 0;
        if (diff > 0) {
            float split = diff / 10;
            float left = 3.0f * split;
            float right = 6.0f * split;
            leftExtraToAdd = new BigDecimal(left).intValue();
            rightExtraToAdd = diff - (leftExtraToAdd + midExtraToAdd);
        }
        this.agemameLayoutEditorShell = new Shell();
        SWTResourceManager.registerResourceUser((Widget)this.agemameLayoutEditorShell);
        this.agemameLayoutEditorShell.setSize(width, height - 20);
        this.agemameLayoutEditorShell.setMaximized(true);
        this.agemameLayoutEditorShell.setText("AGEMAME Layout Editor v" + Version.getVersion());
        this.agemameLayoutEditorShell.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "MameLayout.gif"));
        this.agemameLayoutEditorShell.open();
        SashForm sashForm = new SashForm((Composite)this.agemameLayoutEditorShell, 0);
        TabFolder tabFolder = new TabFolder((Composite)sashForm, 0);
        TabItem explorerTabItem = new TabItem(tabFolder, 0);
        explorerTabItem.setText("Explorer");
        this.explorerPanel = new ExplorerTree((Composite)tabFolder, 0);
        this.explorerPanel.setVisible(false);
        explorerTabItem.setControl((Control)this.explorerPanel);
        int sashHeight = height - 158;
        int sashWidth = width - 22;
        sashForm.setBounds(10, 28, sashWidth, sashHeight);
        SashForm sashForm_1 = new SashForm((Composite)sashForm, 0);
        this.tabFolder_1 = new TabFolder((Composite)sashForm_1, 0);
        TabItem previewTabItem = new TabItem(this.tabFolder_1, 0);
        previewTabItem.setText("Preview");
        ScrolledComposite previewScrolledComposite = new ScrolledComposite((Composite)this.tabFolder_1, 768);
        previewTabItem.setControl((Control)previewScrolledComposite);
        this.previewCanvas = new Canvas((Composite)previewScrolledComposite, 0);
        this.previewCanvas.setBackground(Display.getCurrent().getSystemColor(1));
        this.previewCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (MainApplication.this.swtLayoutRenderer == null) {
                    Rectangle bounds = MainApplication.this.previewCanvas.getBounds();
                    event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                } else {
                    Rectangle bounds = MainApplication.this.previewCanvas.getBounds();
                    event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                    MainApplication.this.paintImage(event);
                }
            }
        });
        this.previewCanvas.setLocation(0, 0);
        this.previewCanvas.setSize(731, 600);
        previewScrolledComposite.setContent((Control)this.previewCanvas);
        this.imageCanvasGC = new GC((Drawable)this.previewCanvas);
        this.previewCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MainApplication.this.imageCanvasGC.dispose();
            }
        });
        this.crossCursor = new Cursor((Device)this.display, 2);
        TabItem textViewTabItem = new TabItem(this.tabFolder_1, 0);
        textViewTabItem.setText("Source");
        this.tabFolder_1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                log.finest("Tab Changed");
                if (event.item instanceof TabItem) {
                    TabItem item = (TabItem)event.item;
                    if (item.getText().equalsIgnoreCase("Source")) {
                        if (MainApplication.this.swtSourceRenderer != null) {
                            MainApplication.this.swtSourceRenderer.refreshSource();
                        }
                        if (MainApplication.this.layoutXml.getText().length() >= MainApplication.this.sourcePos) {
                            MainApplication.this.layoutXml.setSelection(MainApplication.this.sourcePos);
                        }
                    }
                    if (item.getText().equalsIgnoreCase("preview")) {
                        String xml = MainApplication.this.layoutXml.getText().trim();
                        log.finer("XML potentially changed in text view - rebuild objects.");
                        try {
                            if (MainApplication.this.layoutManager != null && MainApplication.this.itemsPanel != null) {
                                MainApplication.this.layoutManager.updateXml(xml);
                                MainApplication.this.itemsPanel.populateTree();
                            }
                        }
                        catch (LayoutParseException e) {
                            MessageBox messageBox = new MessageBox(MainApplication.this.agemameLayoutEditorShell, 33);
                            messageBox.setMessage("Unable to switch to preview due to errors in the XML.\nPlease correct the errors before switching\n\n Error:\n" + e.getMessage());
                            messageBox.setText("Error");
                            messageBox.open();
                            MainApplication.this.tabFolder_1.setSelection(1);
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                log.warning("WIDGET DEFAULT SELECTED");
            }
        });
        this.textViewComposite = new ScrolledComposite((Composite)this.tabFolder_1, 768);
        textViewTabItem.setControl((Control)this.textViewComposite);
        this.layoutXml = new Text(this.textViewComposite, 2818);
        this.layoutXml.setFont(SWTResourceManager.getFont("Courier New", 10, 0));
        this.layoutXml.setRedraw(true);
        this.layoutXml.setBackground(Display.getCurrent().getSystemColor(1));
        this.layoutXml.setBounds(0, 0, 786, sashHeight - 200);
        this.layoutXml.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                log.finest("Repainting Source Tab");
            }
        });
        sashForm_1.setOrientation(512);
        TabFolder tabFolder_2 = new TabFolder((Composite)sashForm_1, 0);
        TabItem problemsTabItem = new TabItem(tabFolder_2, 0);
        problemsTabItem.setText("Problems");
        this.problemsComposite = new Composite((Composite)tabFolder_2, 0);
        problemsTabItem.setControl((Control)this.problemsComposite);
        TabItem consoleTabItem = new TabItem(tabFolder_2, 0);
        consoleTabItem.setText("Console");
        this.consoleComposite = new Composite((Composite)tabFolder_2, 0);
        consoleTabItem.setControl((Control)this.consoleComposite);
        this.consoleText = new Text(this.consoleComposite, 578);
        this.consoleText.setBackground(Display.getCurrent().getSystemColor(1));
        this.consoleText.setEditable(false);
        this.consoleText.setFont(SWTResourceManager.getFont("Courier New", 10, 0));
        this.consoleText.setBounds(0, 0, 786, 169);
        this.consoleText.setTextLimit(30000);
        TabItem propertiesTabItem = new TabItem(tabFolder_2, 0);
        propertiesTabItem.setText("Properties");
        this.details = new DetailsPanel((Composite)tabFolder_2);
        this.details.setVisible(false);
        propertiesTabItem.setControl((Control)this.details);
        tabFolder_2.setSelection(consoleTabItem);
        sashForm_1.setWeights(new int[]{669, 194});
        TabFolder tabFolder_3 = new TabFolder((Composite)sashForm, 0);
        TabItem layoutHierarchyTabItem = new TabItem(tabFolder_3, 0);
        layoutHierarchyTabItem.setText("Layout Hierarchy");
        this.itemsPanel = new ItemsTree((Composite)tabFolder_3, 0);
        this.itemsPanel.setVisible(false);
        layoutHierarchyTabItem.setControl((Control)this.itemsPanel);
        System.out.println(leftExtraToAdd);
        System.out.println(midExtraToAdd);
        System.out.println(rightExtraToAdd);
        sashForm.setWeights(new int[]{225 + leftExtraToAdd, 795 + midExtraToAdd, 232 + rightExtraToAdd});
        Composite statusBarComposite = new Composite((Composite)this.agemameLayoutEditorShell, 0x1000800);
        int statusHeight = height - 120;
        Rectangle rec = new Rectangle(10, statusHeight, 1258, 36);
        statusBarComposite.setBounds(rec);
        this.statusBarCaption = new Label(statusBarComposite, 32);
        this.statusBarCaption.setText("OK");
        this.statusBarCaption.setBounds(10, 10, 813, 21);
        this.statusProgressBar = new ProgressBar(statusBarComposite, 0);
        this.statusProgressBar.setBounds(1145, 10, 100, 17);
        Menu menu = new Menu((Decorations)this.agemameLayoutEditorShell, 2);
        this.agemameLayoutEditorShell.setMenuBar(menu);
        this.createMenuBar(menu);
        ToolBar toolBar = new ToolBar((Composite)this.agemameLayoutEditorShell, 0);
        toolBar.setBounds(0, 0, 1268, 22);
        ToolItem openToolbarItem = new ToolItem(toolBar, 0);
        openToolbarItem.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/" + "open.gif"));
        openToolbarItem.setToolTipText("Open existing Layout file");
        openToolbarItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuOpenFile();
            }
        });
        this.saveToolbarItem = new ToolItem(toolBar, 0);
        this.saveToolbarItem.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/" + "save.gif"));
        this.saveToolbarItem.setEnabled(false);
        this.saveToolbarItem.setToolTipText("Save Layout File");
        this.saveToolbarItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuSave();
            }
        });
        this.refreshToolbarItem = new ToolItem(toolBar, 0);
        this.refreshToolbarItem.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/" + "refresh.gif"));
        this.refreshToolbarItem.setToolTipText("Reload and refresh layout file");
        this.refreshToolbarItem.setEnabled(false);
        this.refreshToolbarItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuRefreshFile();
            }
        });
        ToolItem sep = new ToolItem(toolBar, 2);
        ToolItem absolute = new ToolItem(toolBar, 0);
        absolute.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/" + "refresh.gif"));
        absolute.setToolTipText("Display as absolute size");
        absolute.setEnabled(false);
        absolute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuRefreshFile();
            }
        });
        ToolItem fitToScreen = new ToolItem(toolBar, 0);
        fitToScreen.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/" + "refresh.gif"));
        fitToScreen.setToolTipText("Fit to Screen");
        fitToScreen.setEnabled(false);
        fitToScreen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuRefreshFile();
            }
        });
        log.info("AGEMAME Layout Editor v" + Version.getVersion());
        log.info("Copyright (C)2006-2007 D.Pemberton");
        log.info("------------------------------------------");
        log.info("All rights reserved");
        String val = PersistentSettings.getPropertyValue("UPDATE.AUTO", "true");
        PersistentSettings.setProperty("UPDATE.AUTO", val);
        try {
            UpdateDetails d;
            if (val.equalsIgnoreCase("true") && !CheckForUpdates.isVersionUptoDate(d = CheckForUpdates.checkLatestVersion(PersistentSettings.getPropertyValue("UPDATE.URL")))) {
                FindAndInstall faiDialog = new FindAndInstall(this.agemameLayoutEditorShell, 0);
                faiDialog.open(true);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        newVersion = false;
        newVersion = PersistentSettings.isVersionChanged();
        if (newVersion) {
            NewVersionInfo nvi = new NewVersionInfo(this.agemameLayoutEditorShell, 0);
            nvi.open();
        }
        while (!this.agemameLayoutEditorShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        PersistentSettings.writePropertiesFile();
    }

    public Composite getProblemsComposite() {
        return this.problemsComposite;
    }

    public Composite getConsoleComposite() {
        return this.consoleComposite;
    }

    public Canvas getPreviewCanvas() {
        return this.previewCanvas;
    }

    public Composite getTextViewComposite() {
        return this.textViewComposite;
    }

    public Text getLayoutXml() {
        return this.layoutXml;
    }

    public void createFileMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText("File");
        Menu fileMenu = new Menu((Decorations)this.agemameLayoutEditorShell, 4);
        item.setMenu(fileMenu);
        item = new MenuItem(fileMenu, 8);
        item.setText("&Open File...\tCtrl+O");
        item.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/open.gif"));
        item.setAccelerator(SWT.MOD1 + 79);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuOpenFile();
            }
        });
        new MenuItem(fileMenu, 2);
        int i = 0;
        while (i < PersistentSettings.lastUsedFiles.size()) {
            if (PersistentSettings.lastUsedFiles.get(i) != null) {
                item = new MenuItem(fileMenu, 8);
                item.setData((Object)PersistentSettings.lastUsedFiles.get(i));
                item.setText(String.valueOf(i + 1) + " " + PersistentSettings.lastUsedFiles.get(i));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        MenuItem item = (MenuItem)event.getSource();
                        MainApplication.this.menuOpenFile(item.getData().toString());
                    }
                });
            }
            ++i;
        }
        new MenuItem(fileMenu, 2);
        this.save = new MenuItem(fileMenu, 8);
        this.save.setText("&Save\tCtrl+S");
        this.save.setEnabled(false);
        this.save.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/save.gif"));
        this.save.setAccelerator(SWT.MOD1 + 83);
        this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuSaveAs(MainApplication.this.currentLayoutFile);
            }
        });
        this.saveas = new MenuItem(fileMenu, 8);
        this.saveas.setEnabled(false);
        this.saveas.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/saveas.gif"));
        this.saveas.setText("Save &As...");
        this.saveas.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.menuSaveAs(null);
            }
        });
        new MenuItem(fileMenu, 2);
        item = new MenuItem(fileMenu, 8);
        item.setText("E&xit");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.agemameLayoutEditorShell.close();
            }
        });
    }

    public void menuSaveAs(String infilename) {
        String filename = null;
        if (infilename == null || infilename.length() == 0) {
            FileDialog fileChooser = new FileDialog(this.agemameLayoutEditorShell, 8192);
            fileChooser.setFilterPath(this.lastPath);
            if (this.currentLayoutFile != null) {
                String name = this.currentLayoutFile;
                int nameStart = name.lastIndexOf(File.separatorChar);
                if (nameStart > -1) {
                    name = name.substring(nameStart + 1);
                }
                fileChooser.setFileName(name);
            }
            fileChooser.setFilterExtensions(GuiMenuHandling.OPEN_FILTER_EXTENSIONS);
            fileChooser.setFilterNames(GuiMenuHandling.OPEN_FILTER_NAMES);
            filename = fileChooser.open();
        } else {
            filename = infilename;
        }
        try {
            String res = this.layoutManager.toXml();
            FileUtils.writeStringToFile(res, filename);
            log.info("Save of Layout [" + filename + "] complete");
            this.setStatusBarCaption("Save of Layout [" + filename + "] complete");
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
    }

    public void menuSave() {
        this.menuSaveAs(this.currentLayoutFile);
    }

    public void menuOpenFile() {
        this.menuOpenFile(null);
    }

    /*
     * Exception decompiling
     */
    public void menuRefreshFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void menuOpenFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getStatusBarCaption() {
        return this.statusBarCaption.getText();
    }

    private void setStatusBarCaption(String text) {
        this.statusBarCaption.setText(text);
    }

    public void paintSprites() {
        this.paintSprites(this.imageCanvasGC);
    }

    public void paintSprites(GC gc) {
        this.swtLayoutRenderer.paintLayout(gc);
        this.previewCanvas.setSize(this.swtLayoutRenderer.largestWidth, this.swtLayoutRenderer.largestHeight);
    }

    private void paintImage(PaintEvent event) {
        GC gc = event.gc;
        this.paintSprites(gc);
    }

    private Menu createMenuBar(Menu menuBar) {
        menuBar = new Menu((Decorations)this.agemameLayoutEditorShell, 2);
        this.agemameLayoutEditorShell.setMenuBar(menuBar);
        this.createFileMenu(menuBar);
        this.createDebugMenu(menuBar);
        this.createHelpMenu(menuBar);
        return menuBar;
    }

    private void createDebugMenu(Menu menuBar) {
        SelectionAdapter radioSelected = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem radio = (MenuItem)event.widget;
                if (radio.getSelection()) {
                    Logger.getLogger("uk.co.pembo").setLevel(Level.parse(radio.getText()));
                    Logger.getLogger("com.fruitforums").setLevel(Level.parse(radio.getText()));
                }
            }
        };
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText("Debug");
        Menu debugMenu = new Menu((Decorations)this.agemameLayoutEditorShell, 4);
        item.setMenu(debugMenu);
        final MenuItem applicationConsoleLog = new MenuItem(debugMenu, 32);
        applicationConsoleLog.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (applicationConsoleLog.getSelection()) {
                    Logger.getLogger("uk.co.pembo").addHandler(MainApplication.this.handler);
                    Logger.getLogger("com.fruitforums").addHandler(MainApplication.this.handler);
                } else {
                    Logger.getLogger("uk.co.pembo").removeHandler(MainApplication.this.handler);
                    Logger.getLogger("com.fruitforums").removeHandler(MainApplication.this.handler);
                }
            }
        });
        applicationConsoleLog.setSelection(true);
        applicationConsoleLog.setText("Log to Application");
        new MenuItem(debugMenu, 2);
        item = new MenuItem(debugMenu, 16);
        item.setText("ALL");
        item.setData((Object)"ALL");
        item.addSelectionListener((SelectionListener)radioSelected);
        item = new MenuItem(debugMenu, 16);
        item.setText("FINE");
        item.setData((Object)"FINE");
        item.addSelectionListener((SelectionListener)radioSelected);
        item = new MenuItem(debugMenu, 16);
        item.setText("INFO");
        item.setData((Object)"INFO");
        item.setSelection(true);
        item.addSelectionListener((SelectionListener)radioSelected);
        item = new MenuItem(debugMenu, 16);
        item.setText("WARNING");
        item.setData((Object)"WARNING");
        item.addSelectionListener((SelectionListener)radioSelected);
        item = new MenuItem(debugMenu, 16);
        item.setText("SEVERE");
        item.setData((Object)"SEVERE");
        item.addSelectionListener((SelectionListener)radioSelected);
        item = new MenuItem(debugMenu, 16);
        item.setText("OFF");
        item.setData((Object)"OFF");
        item.addSelectionListener((SelectionListener)radioSelected);
    }

    void createHelpMenu(Menu menuBar) {
        MenuItem item = new MenuItem(menuBar, 64);
        item.setText("Help");
        Menu helpMenu = new Menu((Decorations)this.agemameLayoutEditorShell, 4);
        item.setMenu(helpMenu);
        MenuItem helpMenuItem = new MenuItem(helpMenu, 0);
        helpMenuItem.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/help.gif"));
        helpMenuItem.setText("Help Contents");
        helpMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
            }
        });
        new MenuItem(helpMenu, 2);
        MenuItem softwareUpdatesMenuItem = new MenuItem(helpMenu, 64);
        softwareUpdatesMenuItem.setText("Software Updates");
        Menu menu_2 = new Menu(softwareUpdatesMenuItem);
        softwareUpdatesMenuItem.setMenu(menu_2);
        MenuItem findAndInstallMenuItem = new MenuItem(menu_2, 0);
        findAndInstallMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FindAndInstall faiDialog = new FindAndInstall(MainApplication.this.agemameLayoutEditorShell, 0);
                faiDialog.open(false);
            }
        });
        findAndInstallMenuItem.setText("Find and Install");
        findAndInstallMenuItem.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/findAndInstall.gif"));
        MenuItem manageConfigurationMenuItem = new MenuItem(menu_2, 0);
        manageConfigurationMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ManageConfiguration mfDialog = new ManageConfiguration(MainApplication.this.agemameLayoutEditorShell, 0);
                mfDialog.open();
            }
        });
        manageConfigurationMenuItem.setText("Manage Configuration");
        manageConfigurationMenuItem.setImage(SWTResourceManager.getImage(String.valueOf(Version.getPathToImages()) + "toolbar/manageConfiguration.gif"));
        new MenuItem(helpMenu, 2);
        item = new MenuItem(helpMenu, 8);
        item.setText("Whats New?");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewVersionInfo nvi = new NewVersionInfo(MainApplication.this.agemameLayoutEditorShell, 0);
                nvi.open();
            }
        });
        item = new MenuItem(helpMenu, 8);
        item.setText("About");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainApplication.this.aboutPressed();
            }
        });
    }

    public void aboutPressed() {
        AboutDialog about = new AboutDialog(this.agemameLayoutEditorShell, 0);
        about.open();
    }

    public Text getConsoleText() {
        return this.consoleText;
    }

    public ProgressBar getStatusProgressBar() {
        return this.statusProgressBar;
    }

    class ApplicationHandler
    extends Handler {
        ApplicationHandler() {
        }

        public void publish(LogRecord record) {
            StringBuffer message = new StringBuffer();
            Date d = new Date(record.getMillis());
            message.append(MainApplication.this.sdf.format(d));
            message.append(" [");
            message.append(record.getLevel());
            message.append("]");
            message.append(": ");
            message.append(record.getMessage());
            message.append("\n");
            if (MainApplication.this.getConsoleText().getText().length() + message.toString().length() > MainApplication.this.getConsoleText().getTextLimit()) {
                MainApplication.this.getConsoleText().setText(MainApplication.this.getConsoleText().getText(MainApplication.this.getConsoleText().getText().length() - message.toString().length(), MainApplication.this.getConsoleText().getText().length()));
            }
            MainApplication.this.getConsoleText().append(message.toString());
        }

        public void flush() {
            MainApplication.this.getConsoleText().redraw();
        }

        public void close() {
        }
    }
}

