/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.agemame.updatemanager;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.util.PersistentSettings;

public class CheckForUpdates {
    private static Logger log = Logger.getLogger(CheckForUpdates.class.getPackage().getName());
    private static String UPDATE_URL_SUFFIX = "check_agemame_version.php";

    private static String simpleHttpGet(String inUrl) throws MalformedURLException, IOException {
        URL url = new URL(inUrl);
        InputStream in = url.openStream();
        StringBuffer buf = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String tempBuf = null;
        while ((tempBuf = br.readLine()) != null) {
            buf.append(tempBuf);
        }
        return buf.toString();
    }

    public static void GetURL(String urlStr, String filename) throws Exception {
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                int bytes_read;
                URL url = new URL(urlStr);
                in = url.openStream();
                out = filename != null ? new FileOutputStream(filename) : System.out;
                byte[] buffer = new byte[4096];
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error Connecting to update server");
                throw e;
            }
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static UpdateDetails checkLatestVersion(String updateURL) throws IOException {
        if (!updateURL.endsWith("/")) {
            updateURL = String.valueOf(updateURL) + "/";
        }
        String fullURL = String.valueOf(updateURL) + UPDATE_URL_SUFFIX;
        UpdateDetails details = CheckForUpdates.getDetails(fullURL);
        return details;
    }

    public static void downloadUpdate(String updateURL) throws Exception {
        UpdateDetails d = CheckForUpdates.checkLatestVersion(updateURL);
        if (!CheckForUpdates.isVersionUptoDate(d)) {
            if (!updateURL.endsWith("/")) {
                updateURL = String.valueOf(updateURL) + "/";
            }
            String savLoc = PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION");
            CheckForUpdates.GetURL(String.valueOf(updateURL) + "ALE" + d.getVersion() + ".jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "UPDATE_ALE.jar");
            try {
                Class<?> c = Class.forName("javax.xml.bind.JAXB");
                log.finest("JAXB Jar files found");
            }
            catch (ClassNotFoundException e) {
                log.severe("JAXB Jar files not present - downloading files");
                CheckForUpdates.GetURL(String.valueOf(updateURL) + "lib/jsr173_1.0_api.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "jsr173_1.0_api.jar");
                CheckForUpdates.GetURL(String.valueOf(updateURL) + "lib/jaxb-impl.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "jaxb-impl.jar");
                CheckForUpdates.GetURL(String.valueOf(updateURL) + "lib/jaxb-api.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "jaxb-api.jar");
                CheckForUpdates.GetURL(String.valueOf(updateURL) + "lib/activation.jar", String.valueOf(PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION")) + "activation.jar");
                log.info("Downloaded JAXB Jars");
            }
        }
    }

    private static UpdateDetails getDetails(String updateURL) throws IOException {
        String result = CheckForUpdates.simpleHttpGet(updateURL);
        UpdateDetails details = new UpdateDetails(result);
        return details;
    }

    public static boolean isVersionUptoDate(UpdateDetails details) {
        float webVersion = Float.parseFloat(details.getVersion());
        float appVersion = Float.parseFloat(Version.getNumericVersion());
        if (appVersion >= webVersion) {
            log.log(Level.INFO, "Application is up to date");
            return true;
        }
        log.log(Level.WARNING, "Application is out of date and requires updating");
        return false;
    }
}

