/*
 * Decompiled with CFR 0.152.
 */
package uk.co.pembo.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import uk.co.pembo.agemame.info.Version;

public class PersistentSettings {
    String tempPath = System.getProperty("java.io.tmpdir");
    private static Properties properties = new Properties();
    private static String filename = "ale.properties";
    private static String updateFile = "update.txt";
    private static String updateText = "";
    public static ArrayList<String> lastUsedFiles = new ArrayList(4);
    private static final String LUF1 = "LAST.USED.FILE.1";
    private static final String LUF2 = "LAST.USED.FILE.2";
    private static final String LUF3 = "LAST.USED.FILE.3";
    private static final String LUF4 = "LAST.USED.FILE.4";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static void loadPropertiesFile() {
        try {
            properties.load(new FileInputStream(filename));
            PersistentSettings.populateLastUsedFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
            PersistentSettings.writePropertiesFile();
        }
    }

    public static boolean isVersionChanged() {
        String version = PersistentSettings.getPropertyValue("currentVersion");
        String actualVersion = Version.getNumericVersion();
        if (version == null || version.length() <= 0) {
            PersistentSettings.setProperty("currentVersion", actualVersion);
            PersistentSettings.writePropertiesFile();
            return true;
        }
        int vers = Integer.parseInt(version);
        int actVers = Integer.parseInt(actualVersion);
        System.out.println("VERSIONS!");
        System.out.println(vers);
        System.out.println(actVers);
        if (vers < actVers) {
            PersistentSettings.setProperty("currentVersion", actualVersion);
            PersistentSettings.writePropertiesFile();
            return true;
        }
        return false;
    }

    public static void initProperties() {
        PersistentSettings.setProperty("UPDATE.AUTO", PersistentSettings.getPropertyValue("UPDATE.AUTO", "false"));
        PersistentSettings.setProperty("UPDATE.SAVELOCATION", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION", "./lib/"));
        PersistentSettings.setProperty("UPDATE.URL", PersistentSettings.getPropertyValue("UPDATE.URL", "http://www.dpembo.ukfsn.org/agemame/release/update/"));
        PersistentSettings.setProperty("proxyHost", PersistentSettings.getPropertyValue("proxyHost", ""));
        PersistentSettings.setProperty("proxyPort", PersistentSettings.getPropertyValue("proxyPort", ""));
        PersistentSettings.setProxyIfRequired();
    }

    public static void setProxyIfRequired() {
        String proxyHost = PersistentSettings.getPropertyValue("proxyHost", "");
        String proxyPort = PersistentSettings.getPropertyValue("proxyPort", "");
        if (proxyHost.length() > 0) {
            System.setProperty("http.proxyHost", proxyHost);
        }
        if (proxyPort.length() > 0) {
            System.setProperty("http.proxyPort", proxyPort);
        }
    }

    public static String getPropertyValue(String propName, String initValue) {
        if (PersistentSettings.getPropertyValue(propName) == null || PersistentSettings.getPropertyValue(propName).length() == 0) {
            PersistentSettings.setProperty(propName, initValue);
            return initValue;
        }
        return PersistentSettings.getPropertyValue(propName);
    }

    public static void populateLastUsedFiles() {
        String file1 = null;
        String file2 = null;
        String file3 = null;
        String file4 = null;
        file1 = PersistentSettings.getPropertyValue(LUF1);
        file2 = PersistentSettings.getPropertyValue(LUF2);
        file3 = PersistentSettings.getPropertyValue(LUF3);
        file4 = PersistentSettings.getPropertyValue(LUF4);
        lastUsedFiles.add(file1);
        lastUsedFiles.add(file2);
        lastUsedFiles.add(file3);
        lastUsedFiles.add(file4);
    }

    public static void addLastUsedFile(String inFilename) {
        int i = 0;
        while (i < lastUsedFiles.size()) {
            String val = lastUsedFiles.get(i);
            if (val != null && val.equals(inFilename)) {
                lastUsedFiles.remove(i);
                break;
            }
            ++i;
        }
        lastUsedFiles.add(0, inFilename);
        if (lastUsedFiles.size() > 4) {
            lastUsedFiles.remove(4);
        }
    }

    private static void lastUsedFilesToProperties() {
        if (lastUsedFiles.size() > 0 && lastUsedFiles.get(0) != null) {
            properties.setProperty(LUF1, lastUsedFiles.get(0));
        }
        if (lastUsedFiles.size() > 1 && lastUsedFiles.get(1) != null) {
            properties.setProperty(LUF2, lastUsedFiles.get(1));
        }
        if (lastUsedFiles.size() > 2 && lastUsedFiles.get(2) != null) {
            properties.setProperty(LUF3, lastUsedFiles.get(2));
        }
        if (lastUsedFiles.size() > 3 && lastUsedFiles.get(3) != null) {
            properties.setProperty(LUF4, lastUsedFiles.get(3));
        }
    }

    public static void addProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static void setProperty(String key, String value) {
        PersistentSettings.addProperty(key, value);
    }

    public static String getPropertyValue(String key) {
        return properties.getProperty(key);
    }

    public static void writePropertiesFile() {
        PersistentSettings.lastUsedFilesToProperties();
        try {
            properties.store(new FileOutputStream(filename), "AGEMAME Layout Editor Settings");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        PersistentSettings.lastUsedFilesToProperties();
        PersistentSettings.writePropertiesFile();
    }

    public static String getUpdateText() {
        return updateText;
    }

    private static String getContents(String filename) {
        File file = new File(filename);
        System.out.println("LOADING FILE FROM: " + file.getAbsolutePath());
        String fileData = PersistentSettings.getContents(file);
        return fileData;
    }

    private static String getContents(File aFile) {
        StringBuffer contents;
        block19: {
            contents = new StringBuffer();
            BufferedReader input = null;
            try {
                input = new BufferedReader(new FileReader(aFile));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (input != null) {
                        input.close();
                    }
                    break block19;
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                break block19;
            }
            catch (IOException ex) {
                try {
                    ex.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex3) {
                        ex3.printStackTrace();
                    }
                }
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }
}

