package uk.co.pembo.agemame.ui;
import java.math.BigInteger;

import org.eclipse.jface.viewers.TableViewer;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Bounds;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;



/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class DetailsPanel extends Composite {

    private EditableTableItem[] content = new EditableTableItem[]{};/* {
	      new EditableTableItem("item 1", new Integer(0)),
	      new EditableTableItem("item 2", new Integer(1)) };*/

	  //private static final String[] VALUE_SET = new String[] { "xxx", "yyy",
	  //    "zzz" };

    	  private Canvas preview;
	  private static final String NAME_PROPERTY = "Name";

	  private static final String VALUE_PROPERTY = "Value";

	  private TableViewer viewer;
	  private Object dataObject;

	  public DetailsPanel(Composite parent) {
	    super(parent, SWT.NULL);
	    buildControls();
	  }

	  /*private class NewRowAction extends Action {
	    public NewRowAction() {
	      super("Insert New Row");
	    }

	    public void run() {
	      EditableTableItem newItem = new EditableTableItem("new row",
	          "2");
	      viewer.add(newItem);
	    }
	  }*/

	  protected void buildControls() {
	    FillLayout compositeLayout = new FillLayout();
	    setLayout(compositeLayout);

    final Table table = new Table(this, SWT.FULL_SELECTION | SWT.BORDER);
	    viewer = buildAndLayoutTable(table);

	    attachContentProvider(viewer);
	    attachLabelProvider(viewer);
	    attachCellEditors(viewer, table);

	    //MenuManager popupMenu = new MenuManager();
	    //IAction newRowAction = new NewRowAction();
	    //popupMenu.add(newRowAction);
	    //Menu menu = popupMenu.createContextMenu(table);
	    //table.setMenu(menu);

	    viewer.setInput(content);
	  }

	  private void attachLabelProvider(TableViewer viewer) {
	    viewer.setLabelProvider(new ITableLabelProvider() {
	      public Image getColumnImage(Object element, int columnIndex) {
	        return null;
	      }

	      public String getColumnText(Object element, int columnIndex) {
	        switch (columnIndex) {
	        case 0:
	          return ((EditableTableItem) element).name;
	        case 1:
	        {
	          //Number index = ((EditableTableItem) element).value;
	          //return VALUE_SET[index.intValue()];
	          return ((EditableTableItem) element).value;
	        }
	        default:
	          return "Invalid column: " + columnIndex;
	        }
	      }

	      public void addListener(ILabelProviderListener listener) {
	      }

	      public void dispose() {
	      }

	      public boolean isLabelProperty(Object element, String property) {
	        return false;
	      }

	      public void removeListener(ILabelProviderListener lpl) {
	      }
	    });
	  }

	  private void attachContentProvider(TableViewer viewer) {
	    viewer.setContentProvider(new IStructuredContentProvider() {
	      public Object[] getElements(Object inputElement) {
	        return (Object[]) inputElement;
	      }

	      public void dispose() {
	      }

	      public void inputChanged(Viewer viewer, Object oldInput,
	          Object newInput) {
		  //System.out.println("INPUT CHANGED!");
	      }
	    });
	  }

	  private TableViewer buildAndLayoutTable(final Table table) {
	    TableViewer tableViewer = new TableViewer(table);

	    TableLayout layout = new TableLayout();
	    layout.addColumnData(new ColumnWeightData(50, 75, true));
	    layout.addColumnData(new ColumnWeightData(50, 75, true));
	    table.setLayout(layout);
	    
	    TableColumn nameColumn = new TableColumn(table, SWT.LEFT);
	    nameColumn.setText("Name");
	    TableColumn valColumn = new TableColumn(table, SWT.LEFT);
	    valColumn.setText("Value");
	    table.setHeaderVisible(true);
	    return tableViewer;
	  }

	  private void attachCellEditors(final TableViewer viewer, Composite parent) {
	    viewer.setCellModifier(new ICellModifier() {
	      public boolean canModify(Object element, String property) {
		  //System.out.println("---> " + property);
		  if(property.equals("Name")) return false;
		  else return true;
	      }

	      public Object getValue(Object element, String property) {
	        if (NAME_PROPERTY.equals(property))
	          return ((EditableTableItem) element).name;
	        else
	          return ((EditableTableItem) element).value;
	      }

	      public void modify(Object element, String property, Object value) {
	        TableItem tableItem = (TableItem) element;
	        EditableTableItem data = (EditableTableItem) tableItem
	            .getData();
	        if (NAME_PROPERTY.equals(property))
	          data.name = value.toString();
	        else
	          data.value = value.toString();

	        viewer.refresh(data);
	      }
	    });

	    //viewer.setCellEditors(new CellEditor[] { new TextCellEditor(parent),
	    //    new ComboBoxCellEditor(parent, VALUE_SET) });
	    viewer.setCellEditors(new CellEditor[] { new TextCellEditor(parent),
		    new TextCellEditor(parent)});	    

	    viewer
	        .setColumnProperties(new String[] { NAME_PROPERTY,
	            VALUE_PROPERTY });
	  }

	/**
	 * @return the content
	 */
	public EditableTableItem[] getContent()
	{
	    return content;
	}

	/**
	 * @param content the content to set
	 */
	public void setContent(EditableTableItem[] content,Object data)
	{
	    /* update the previous items */
	    //System.out.println("EXISTING OBJECT: " + dataObject.getClass().getName());
	    //System.out.println("NEW OBJECT: " + data.getClass().getName());
	    if(this.content.length>0 && data != dataObject)
	    {
        	    if(dataObject instanceof Mamelayout)
        	    {
        		Mamelayout layout = (Mamelayout)dataObject;
        		layout.setVersion(new BigInteger(this.content[0].value));
        		
        		
        	    }
        	    else if(dataObject instanceof Backdrop)
        	    {
        		Backdrop backdrop = (Backdrop)dataObject;
        		backdrop.setName(this.content[0].value);
        		try
			{
			    backdrop.setState(Integer.parseInt(this.content[1].value));
			}
			catch (NumberFormatException e)
			{
			    backdrop.setState(0);
			}
        		//backdrop.setBounds(new Bounds(this.content[2].value,this.content[3].value,this.content[4].value,this.content[5].value));
        		Bounds b=new Bounds();
        		//b.setTop(this.content[2].value);
        		//b.setLeft(this.content[3].value);
        		b.setX(this.content[2].value);
        		b.setY(this.content[3].value);
        		b.setWidth(this.content[4].value);
        		b.setHeight(this.content[5].value);
        		backdrop.setBounds(b);
        		
        		//AgeMameLayoutEditorUI.preview.redraw();
        		//preview.redraw();
        	    }
        	    else
        	    {
        		
        	    }
	    }
	    /* now set the new ones */
	    this.content = content;
	    this.dataObject = data;
	    
	    
	    
	    viewer.setInput(content);
	    //AgeMameLayoutEditorUI.preview.getChildren()[0].redraw();
	    
	}
	
	public void registerCanvas(Canvas preview)
	{
	    this.preview = preview;
	}
	public void setDataObject(Object obj)
	{
	    this.dataObject = obj;
	}	
	
	/*private void updateDataObjectWithChanges()
	{
	    if(dataObject instanceof Layout)
	    {
		Layout layout = (Layout)dataObject;
		layout.setVersion(Integer.parseInt(content[0].value));
	    }
	    else
	    {
		
	    }
	}*/


	}  
	 
	 

