/**
 * 
 */
package uk.co.pembo.agemame.swtrender;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

import com.sun.xml.bind.v2.runtime.Coordinator;


import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Bounds;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Disk;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Screen;
import uk.co.pembo.agemame.xmlbinding.mamelayout.View;

/**
 * @author Pembo
 * render the layouts to the canvas
 */
public class LayoutRenderer
{
    
    public int largestWidth = 0;
    public int largestHeight = 0;
    private Display display;
    private MameLayoutManager mameLayoutManager;
    private static Logger log = Logger.getLogger(LayoutRenderer.class.getPackage().getName());
    
    /**
     * Initialise the Layout Renderer
     * @param display - the display containing the canvas to draw to.
     * @param mameLayoutManager
     */
    public LayoutRenderer(Display display,MameLayoutManager mameLayoutManager)
    {
	this.display = display;
	this.mameLayoutManager = mameLayoutManager;
    }
    
    
    /**
     * Paints the layout to the given Graphics Context
     * For every view, it draws the screens, then backdrops,
     * then bezels, and finally the overlays.
     * 
     * @param gc
     */
    public void paintLayout(GC gc) {
	
	//For every view, first pickout and draw every screen,
	Mamelayout layout = mameLayoutManager.getMameLayout();
	List<View> views = layout.getView();
	
	View view;
	for(int viewIndex=0;viewIndex<views.size();viewIndex++)
	{
	    view = views.get(viewIndex);
	    paintView(gc,view);
	}
    }
    
    /**
     * paints the view
     * @param gc
     * @param view
     */
    private void paintView(GC gc, View view)
    {
	log.finest("Rendering view [" + view.getName() + "]");
	
	//First the screens
	List<Screen> screens = view.getScreen();
	List<Backdrop> backdrops = view.getBackdrop();
	Screen screen;
	Backdrop backdrop;
	//Next comes the backdrops
	for(int backdropIndex=0;backdropIndex<backdrops.size();backdropIndex++)
	{
	    backdrop = backdrops.get(backdropIndex);
	    paintBackdrop(gc,backdrop);
	}
	
	for(int screenIndex=0;screenIndex<screens.size();screenIndex++)
	{
	    screen = screens.get(screenIndex);
	    paintScreen(gc,screen);
	}
	

    }
    
    /**
     * Paints the screen
     * @param gc
     * @param screen
     */
    private void paintScreen(GC gc, Screen screen)
    {
	//A screen can have either a bounds an/or
	//an orientation
	Bounds b = screen.getBounds();
	Coordinates coords = new Coordinates(b);
	
	gc.setLineStyle(SWT.LINE_SOLID);
	gc.setLineWidth(3);
	gc.setForeground(new Color(gc.getDevice(),255,0,0));
	
	gc.drawRectangle(coords.x,coords.y,coords.width,coords.height);
	
    }
    
    
    private void paintBackdrop(GC gc,Backdrop backdrop)
    {
	String elementName = backdrop.getElement();
	if(backdrop.getBounds()!=null)
	{
	Coordinates coords = new Coordinates (backdrop.getBounds());
	Element element = mameLayoutManager.getElementByName(elementName);
	
	paintElement(gc, element,coords);
	}
    }
    
    private void paintElement(GC gc, Element element,Coordinates coords)
    {
	
	List<Image> images = element.getImage();
	List<Disk> disks = element.getDisk();
	if(disks.size()>0)
	{
	    //paintDisk(gc,disks,coords);
	}

	//Just image first
	//List<Image> images = element.getImage();
	if(images.size()>=1)
	{
	    Image image= images.get(0);
	    paintImage(gc,image,coords);
	}
    }
    
    private void paintImage(GC gc, Image image,Coordinates coords)
    {
	org.eclipse.swt.graphics.Image swtImage;
	int srcHeight = -1;
	int srcWidth = -1;
	
	//Does the image have an alpha file?
//	if(image.getAlphafile()!=null)
//	{
//	    swtImage = mameLayoutManager.getAlphaImage(image);
//	    srcHeight = swtImage.getBounds().height;
//	    srcWidth = swtImage.getBounds().width;
//	    gc.drawImage(swtImage, 0, 0, srcWidth, srcHeight, coords.x,coords.y,coords.width,coords.height);
//	}
	
	swtImage = mameLayoutManager.getImage(display,image);
	srcHeight = swtImage.getBounds().height;
	srcWidth = swtImage.getBounds().width;
	
	gc.drawImage(swtImage, 0, 0, srcWidth, srcHeight, coords.x,coords.y,coords.width,coords.height);
	

    }

    class Coordinates
    {
	public int x=0;
	public int y=0;
	public int width = 0;
	public int height = 0;
	
	public Coordinates(Bounds b,GC gc)
	{
	    
	}
	public Coordinates(Bounds b)
	{
//	    System.out.println("X:" +b.getX());
//	    System.out.println("Y:" +b.getY());
//	    System.out.println("W:" +b.getWidth());
//	    System.out.println("H:" +b.getHeight());
//	    System.out.println("L:" + b.getLeft());
//	    System.out.println("T:" +b.getTop());
//	    System.out.println("R:" +b.getRight());
//	    System.out.println("B:" +b.getBottom());
	    
	    if(b.getLeft()!=null && b.getLeft().length()>0)
	    {
		x = new Float(b.getLeft()).intValue();
		y = new Float(b.getTop()).intValue();
		width = new Float(b.getRight()).intValue() - new Float(b.getLeft()).intValue();
		height = new Float(b.getBottom()).intValue() - new Float(b.getTop()).intValue();
	    }
	    else
	    {
		x =  new Float(b.getX()).intValue();
		y = new Float(b.getY()).intValue();
		width = new Float(b.getWidth()).intValue();
		height = new Float(b.getHeight()).intValue();
	    }
	    
	    if(width>largestWidth)largestWidth = width;
	    if(height>largestHeight)largestHeight=height;
	}
	
	
    }
}


