package uk.co.pembo.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Queue;

import uk.co.pembo.agemame.info.Version;

public class PersistentSettings
{
    String tempPath = System.getProperty("java.io.tmpdir");
    private static Properties properties = new Properties();
    private static String filename = "ale.properties";
    private static String updateFile = "update.txt";
    private static String updateText = "";
    public static ArrayList<String> lastUsedFiles = new ArrayList<String>(4);

    private static final String LUF1 = "LAST.USED.FILE.1";
    private static final String LUF2 = "LAST.USED.FILE.2";
    private static final String LUF3 = "LAST.USED.FILE.3";
    private static final String LUF4 = "LAST.USED.FILE.4";
    
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static void loadPropertiesFile()
    {
	// Read properties file.
	try
	{
	    properties.load(new FileInputStream(filename));
	    populateLastUsedFiles();
	    
	    //Get the updateText
	    
	}
	catch (IOException e)
	{
	    e.printStackTrace();

	    writePropertiesFile();
	}

    }

    public static boolean isVersionChanged()
    {
	String version = getPropertyValue("currentVersion");
	String actualVersion = Version.getNumericVersion();
	
	if (version == null || version.length() <= 0)
	{
	    setProperty("currentVersion", actualVersion);
	    writePropertiesFile();
	    return true;
	}
	else
	{
	    int vers;
	    int actVers;
	    vers = Integer.parseInt(version);
	    actVers = Integer.parseInt(actualVersion);
	    
	    System.out.println("VERSIONS!");
	    System.out.println(vers);
	    System.out.println(actVers);
	    
	    if (vers < actVers)
	    {
		setProperty("currentVersion",actualVersion);
		writePropertiesFile();
		return true;
	    }
	    else
	    {
		return false;
	    }
	}

    }

    public static void initProperties()
    {
	setProperty("UPDATE.AUTO", getPropertyValue("UPDATE.AUTO", "false"));
	setProperty("UPDATE.SAVELOCATION", getPropertyValue("UPDATE.SAVELOCATION", "./lib/"));
	setProperty("UPDATE.URL", getPropertyValue("UPDATE.URL", "http://www.dpembo.ukfsn.org/agemame/release/update/"));
	setProperty("proxyHost", getPropertyValue("proxyHost", ""));
	setProperty("proxyPort", getPropertyValue("proxyPort", ""));
	// isVersionChanged();
	setProxyIfRequired();

    }

    /**
         * 
         */
    public static void setProxyIfRequired()
    {
	// Set any proxy servers!
	String proxyHost = getPropertyValue("proxyHost", "");
	String proxyPort = getPropertyValue("proxyPort", "");

	if (proxyHost.length() > 0)
	{
	    System.setProperty("http.proxyHost", proxyHost);
	}

	if (proxyPort.length() > 0)
	{
	    System.setProperty("http.proxyPort", proxyPort);
	}
    }

    public static String getPropertyValue(String propName, String initValue)
    {
	if (PersistentSettings.getPropertyValue(propName) == null || (PersistentSettings.getPropertyValue(propName).length() == 0))
	{
	    PersistentSettings.setProperty(propName, initValue);
	    return initValue;
	}
	else
	{
	    return PersistentSettings.getPropertyValue(propName);
	}
    }

    public static void populateLastUsedFiles()
    {

	String file1 = null, file2 = null, file3 = null, file4 = null;
	file1 = getPropertyValue(LUF1);
	file2 = getPropertyValue(LUF2);
	file3 = getPropertyValue(LUF3);
	file4 = getPropertyValue(LUF4);

	lastUsedFiles.add(file1);
	lastUsedFiles.add(file2);
	lastUsedFiles.add(file3);
	lastUsedFiles.add(file4);
    }

    public static void addLastUsedFile(String inFilename)
    {
	// if(lastUsedFiles[0]!= null &&
        // lastUsedFiles[0].equals(inFilename))return;

	// First is is already in the list, if so, remove it
	for (int i = 0; i < lastUsedFiles.size(); i++)
	{
	    String val = lastUsedFiles.get(i);
	    if (val != null && val.equals(inFilename))
	    {
		lastUsedFiles.remove(i);
		break;
	    }
	}

	lastUsedFiles.add(0, inFilename);

	if (lastUsedFiles.size() > 4)
	{
	    lastUsedFiles.remove(4);
	}

    }

    private static void lastUsedFilesToProperties()
    {
	if (lastUsedFiles.size() > 0 && lastUsedFiles.get(0) != null) properties.setProperty(LUF1, lastUsedFiles.get(0));
	if (lastUsedFiles.size() > 1 && lastUsedFiles.get(1) != null) properties.setProperty(LUF2, lastUsedFiles.get(1));
	if (lastUsedFiles.size() > 2 && lastUsedFiles.get(2) != null) properties.setProperty(LUF3, lastUsedFiles.get(2));
	if (lastUsedFiles.size() > 3 && lastUsedFiles.get(3) != null) properties.setProperty(LUF4, lastUsedFiles.get(3));
    }

    /**
         * Adds a new property
         * 
         * @param key
         */
    public static void addProperty(String key, String value)
    {
	properties.setProperty(key, value);
    }

    /**
         * sets a property
         * 
         * @param key
         */
    public static void setProperty(String key, String value)
    {
	addProperty(key, value);
    }

    public static String getPropertyValue(String key)
    {
	return properties.getProperty(key);
    }

    public static void writePropertiesFile()
    {
	lastUsedFilesToProperties();
	// Write properties file.
	try
	{
	    properties.store(new FileOutputStream(filename), "AGEMAME Layout Editor Settings");
	}
	catch (IOException e)
	{
	    e.printStackTrace();
	}
    }

    protected void finalize() throws java.lang.Throwable
    {
	lastUsedFilesToProperties();
	writePropertiesFile();
    }

    public static String getUpdateText()
    {
	return updateText;
    }
    
    
    /**
     * Used to retrieve the contents of a text file
     * @param filename
     * @return
     */
    private static String getContents(String filename)
    {
	File file = new File(filename);
	
	System.out.println("LOADING FILE FROM: " + file.getAbsolutePath());
	
	String fileData = getContents(file);
	//System.out.println(fileData);
	return fileData;
    }
    
    /**
     * Used to retrieve the contents of a text file
     * @param aFile
     * @return
     */
    
    private static String getContents(File aFile)
    {
	// ...checks on aFile are elided
	StringBuffer contents = new StringBuffer();

	// declared here only to make visible to finally clause
	BufferedReader input = null;
	try
	{
	    // use buffering, reading one line at a time
	    // FileReader always assumes default encoding is OK!
	    input = new BufferedReader(new FileReader(aFile));
	    String line = null; // not declared within while loop
	    /*
                 * readLine is a bit quirky : it returns the content of a line
                 * MINUS the newline. it returns null only for the END of the
                 * stream. it returns an empty String if two newlines appear in
                 * a row.
                 */
	    while ((line = input.readLine()) != null)
	    {
		contents.append(line);
		contents.append(System.getProperty("line.separator"));
	    }
	}
	catch (FileNotFoundException ex)
	{
	    ex.printStackTrace();
	}
	catch (IOException ex)
	{
	    ex.printStackTrace();
	}
	finally
	{
	    try
	    {
		if (input != null)
		{
		    // flush and close both "input" and its underlying
                        // FileReader
		    input.close();
		}
	    }
	    catch (IOException ex)
	    {
		ex.printStackTrace();
	    }
	}
	return contents.toString();
    }

}
