package uk.co.pembo.agemame.xmlbinding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

import org.eclipse.swt.graphics.Device;

import uk.co.pembo.agemame.exception.LayoutParseException;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Mamelayout;
import uk.co.pembo.agemame.xmlbinding.mamelayout.ObjectFactory;

public class MameLayoutManager
{
    private static final String fileSeparator = System.getProperty("file.separator");
    
    private Mamelayout mamelayout;
    private String rootPath = null;

    /**
     * Create the objects from a file
     * @param f
     */
    public MameLayoutManager(File f)
    throws FileNotFoundException,LayoutParseException
    {
	FileInputStream fis = new FileInputStream(f);
	rootPath = getRootPath(f.getAbsolutePath());
	createDataObjects(fis);
    }
    
    /**
     * Create the objects from just a filename
     * @param filename
     */
    public MameLayoutManager(String filename)
    throws FileNotFoundException,LayoutParseException
    {
	rootPath = getRootPath(filename);
	File f  = new File(filename);
	FileInputStream fis = new FileInputStream(f);
	createDataObjects(fis);
    }
    
    /**
     * Create the objects from an xml string
     * @param xml
     */
    public MameLayoutManager(StringBuffer xml)
    throws LayoutParseException
    {
	System.out.println("CREATING XML OBJECTS FROM:" + xml);
	InputStream bais = new ByteArrayInputStream(xml.toString().getBytes());
	createDataObjects(bais);
    }
    
    
    /**
     * Actually updates the object with some new xml
     * @param xml
     */
    public void updateXml(String xml)
    throws LayoutParseException
    {
	InputStream bais = new ByteArrayInputStream(xml.getBytes());
	createDataObjects(bais);	
    }
    
    /**
     * @return the mamelayout
     */
    public Mamelayout getMameLayout()
    {
        return mamelayout;
    }

    private void createDataObjects(InputStream is)
    throws LayoutParseException
    {
	createDataObjects(is,true);
    }
    
    private void createDataObjects(InputStream is,boolean validate)
    throws LayoutParseException
    {
	try
	{
	    JAXBContext jc = JAXBContext.newInstance( "uk.co.pembo.agemame.xmlbinding.mamelayout" );
	    Unmarshaller u = jc.createUnmarshaller();
	   // u.setValidating(true);
	    //u.setValidating(validate);
	    
	    mamelayout =(Mamelayout)u.unmarshal( is );
	}
	catch (JAXBException e)
	{
	    throw new LayoutParseException("Problem parsing layout: \n" + e.toString(),e);
	}	
    }
    
    public String toXml() throws LayoutParseException
    {
	try
	{
	    JAXBContext jc = JAXBContext.newInstance( "uk.co.pembo.agemame.xmlbinding.mamelayout" );
	    Marshaller marshaller = jc.createMarshaller(); 
	    marshaller.setProperty("jaxb.formatted.output",new Boolean(true));
	    
	    ByteArrayOutputStream baos = new ByteArrayOutputStream();
	    marshaller.marshal(mamelayout, baos);
	    
	    return baos.toString();
	}
	catch (PropertyException e)
	{
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	    throw new LayoutParseException("Problem marshalling layout (setting property)",e);
	}
	catch (JAXBException e)
	{
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	    throw new LayoutParseException("Problem marshalling layout",e);
	}
    }
    
    public Element getElementByName(String elementName)
    {
	List<Element> elements = mamelayout.getElement();
	for(int i=0;i<elements.size();i++)
	{
	    if(elements.get(i)!=null && elements.get(i).getName().equals(elementName))
	    {
		return elements.get(i);
	    }
	}
	return null;
    }
    
    public org.eclipse.swt.graphics.Image getAlphaImage(Device display, Image imageBinding) 
    {
	org.eclipse.swt.graphics.Image image;
	image = loadSWTImage(rootPath +  imageBinding.getAlphafile(),display);
	return image;
    }
    
    public org.eclipse.swt.graphics.Image getImage(Device display, Image imageBinding) 
    {
	org.eclipse.swt.graphics.Image image;
	image = loadSWTImage(rootPath +  imageBinding.getFile(),display);
	return image;
    }
    
    /**
     * Loads and returns an SWT Image from a filename
     * @param fileName filename of image to load
     * @return SWT Image object
     */
    private org.eclipse.swt.graphics.Image loadSWTImage(String fileName, Device display) 
    {
	// return new ImageIcon(fileName).getImage();
	//System.out.println("loading: " + fileName);
	org.eclipse.swt.graphics.Image swtImg = new org.eclipse.swt.graphics.Image(display, fileName);
	return swtImg;
    }
    
    /**
     * Returns the source path for the images
     * @param layoutFile
     * @return
     */
    private static String getRootPath(String layoutFile) {
	String rootPath = "";
	int lastPos = layoutFile.lastIndexOf(fileSeparator);
	if (lastPos > 0) {
	    rootPath = layoutFile.substring(0, lastPos) + fileSeparator;
	} 
	else 
	{
	    rootPath = "";
	}
	return rootPath;
    }

    /**
     * @return the rootPath
     */
    public String getRootPath()
    {
        return rootPath;
    }  
    
    public LayoutChanger getLayoutChanger()
    {
	return new LayoutChanger(this);
    }
}
