package uk.co.pembo.agemame.userinterface;

import java.util.logging.Logger;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.co.pembo.graphics.SWTResourceManager;

import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.util.PersistentSettings;

public class NewVersionInfo extends Dialog
{

    private Text text;
    private Label updatingLabel;
    private Button okButton;
    protected Object result;
    protected Shell shell;
    private boolean exit = false;
    private static Logger log = Logger.getLogger(NewVersionInfo.class.getPackage().getName());

    /**
     * Create the dialog
     * @param parent
     * @param style
     */
    public NewVersionInfo(Shell parent, int style)
    {
	super(parent, style);
    }

    /**
     * Create the dialog
     * @param parent
     */
    public NewVersionInfo(Shell parent)
    {
	this(parent, SWT.NONE);
    }

    /**
     * Open the dialog
     * @return the result
     */
    public Object open()
    {
	createContents();
	shell.open();
	shell.layout();
	Display display = getParent().getDisplay();
	
	String updateURLStr = PersistentSettings.getPropertyValue("UPDATE.URL");
	if (updateURLStr == null || updateURLStr.length() == 0) updateURLStr = "http://www.dpembo.ukfsn.org/agemame/release/update/";
	if(!updateURLStr.endsWith("/"))updateURLStr = updateURLStr + "/";
	
	
	//Do the jaxb jars exist?
	try
	{
	    Class c = Class.forName("javax.xml.bind.JAXB");
	    log.finest("JAXB Jar files found");
	    updatingLabel.setVisible(false);
	    
            updatingLabel.setVisible(false);
            text.setVisible(true);	
            shell.setText("AGEMAME Layout Editor has been updated to version " + Version.getVersion() + "!");
            okButton.setEnabled(true);	    
	}
	catch (ClassNotFoundException e)
	{
	    updatingLabel.setVisible(true);
	    try
	    {
		log.warning("JAXB Jar files not present - downloading files");
		CheckForUpdates.GetURL(updateURLStr +"lib/jsr173_1.0_api.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "jsr173_1.0_api.jar");
		CheckForUpdates.GetURL(updateURLStr +"lib/jaxb-impl.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "jaxb-impl.jar");
		CheckForUpdates.GetURL(updateURLStr +"lib/jaxb-api.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "jaxb-api.jar");
		CheckForUpdates.GetURL(updateURLStr +"lib/activation.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "activation.jar");
		log.info("Downloaded JAXB Jars");
		
		//BLank the current version as it needs to restart
		PersistentSettings.setProperty("currentVersion", "");
		PersistentSettings.writePropertiesFile();
		
		updatingLabel.setText("Update downloaded successfully\nAGEMAME Layout Editor requires restarting.\n\nPress OK to exit the AGEMAME Layout Editor");
		shell.setText("AGEMAME Layout Editor Needs to be restarted");
		exit = true;
		
	    }
	    catch (Exception e1)
	    {
		// TODO Auto-generated catch block
		text.setText("Cannot download JAXB libraries - ALE Will not function correctly [" + e1.getMessage() + "]");
		text.setVisible(true);
		log.severe("Cannot download JAXB libraries - ALE Will not function correctly [" + e1.getMessage() + "]");
		e1.printStackTrace();
	    }
	    
	}
	//updatingLabel.setVisible(false);
	//text.setVisible(true);	
	okButton.setEnabled(true);

	
	
	while (!shell.isDisposed())
	{
	    if (!display.readAndDispatch()) display.sleep();
	}
	return result;
    }
    
    public void setText(String value)
    {
	text.setText(value);
    }

    /**
     * Create contents of the dialog
     */
    protected void createContents()
    {
	shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	shell.setSize(615, 620);

	int guessWidth = 615;
	int guessHeigh = 620;
	
	shell.setLocation((this.getParent().getSize().x - guessWidth) / 2,
(this.getParent().getSize().y - guessHeigh) / 2);
	
	
	shell.setText("Downloading Update... Please wait");

	okButton = new Button(shell, SWT.NONE);
	okButton.addSelectionListener(new SelectionAdapter() {
		public void widgetSelected(SelectionEvent arg0)
		{
		    if(exit)
		    {
			System.exit(0);
		    }
		    else
		    {
			shell.close();
		    }
		}
	});
	okButton.setEnabled(false);
	okButton.setText("OK");
	okButton.setBounds(501, 541, 81, 23);

	text = new Text(shell, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.WRAP);
	text.setVisible(false);
	text.setEditable(false);
	text.setBounds(10, 10, 589, 509);
	
	//text.setText(PersistentSettings.getUpdateText());
	text.setText(Version.getUpdateText());
	updatingLabel = new Label(shell, SWT.NONE);
	updatingLabel.setAlignment(SWT.CENTER);
	updatingLabel.setFont(SWTResourceManager.getFont("", 10, SWT.BOLD));
	updatingLabel.setText("AGEMAME Layout Editor is downloading an update - please wait.");
	updatingLabel.setBounds(94, 244, 443, 79);
	//
    }

}
