package uk.co.pembo.agemame.userinterface;

import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.util.PersistentSettings;

public class ManageConfiguration extends Dialog
{

    private Text proxyPort;
    private Text proxyHost;
    private Text updateSavePath;
    private Button noButton;
    private Button yesButton;
    private Button cancelButton;
    private Button finishButton;
    private Text updateURL;
    protected Object result;
    protected Shell shell;

    private String updateURLStr;
    private String savePathStr;
    private String autoUpdateStr;
    
    private String proxyHostStr;
    private String proxyPortStr;

    /**
     * Create the dialog
     * @param parent
     * @param style
     */
    public ManageConfiguration(Shell parent, int style)
    {
	super(parent, style);
	updateURLStr = PersistentSettings.getPropertyValue("UPDATE.URL","http://www.dpembo.ukfsn.org/agemame/release/update/");
	autoUpdateStr = PersistentSettings.getPropertyValue("UPDATE.AUTO","./lib/");
	savePathStr = PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION","false");
	proxyHostStr = PersistentSettings.getPropertyValue("proxyHost","");
	proxyPortStr = PersistentSettings.getPropertyValue("proxyPort","");

    }

    /**
     * Create the dialog
     * @param parent
     */
    public ManageConfiguration(Shell parent)
    {
	this(parent, SWT.NONE);
    }

    /**
     * Open the dialog
     * @return the result
     */
    public Object open()
    {
	createContents();
	shell.open();
	shell.layout();
	Display display = getParent().getDisplay();
	while (!shell.isDisposed())
	{
	    if (!display.readAndDispatch()) display.sleep();
	}
	return result;
    }

    /**
     * Create contents of the dialog
     */
    protected void createContents()
    {
	shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	shell.setSize(600, 550);
	shell.setText("Install/Update");

	int guessWidth = 600;
	int guessHeigh = 550;

	shell.setLocation((this.getParent().getSize().x - guessWidth) / 2, (this.getParent().getSize().y - guessHeigh) / 2);

	final Composite composite = new Composite(shell, SWT.BORDER | SWT.EMBEDDED);
	composite.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	composite.setBounds(0, 0, 594, 67);

	final Canvas canvas = new Canvas(composite, SWT.NONE);
	canvas.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	canvas.setBounds(515, 0, 77, 64);
	canvas.setBackgroundImage(SWTResourceManager.getImage(Version.getPathToImages() + "dialogs/findAndInstall.gif"));

	final Label updateAgemameLayoutLabel = new Label(composite, SWT.NONE);
	updateAgemameLayoutLabel.setFont(SWTResourceManager.getFont("", 10, SWT.BOLD));
	updateAgemameLayoutLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	updateAgemameLayoutLabel.setText("Manage Configuration");
	updateAgemameLayoutLabel.setBounds(10, 10, 237, 16);

	final Label checkForLaterLabel = new Label(composite, SWT.NONE);
	checkForLaterLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	checkForLaterLabel.setText("Manage Update Configuration for AGEMAME Layout Editor");
	checkForLaterLabel.setBounds(10, 30, 378, 13);

	final Group configurationGroup = new Group(shell, SWT.NONE);
	configurationGroup.setText("Update Configuration");
	configurationGroup.setBounds(10, 87, 574, 106);

	final Label updateServerLabel = new Label(configurationGroup, SWT.NONE);
	updateServerLabel.setText("Update Server URL:");
	updateServerLabel.setBounds(10, 32, 96, 13);

	updateURL = new Text(configurationGroup, SWT.BORDER);
	updateURL.setBounds(114, 27, 452, 25);
	updateURL.setText(updateURLStr);

	final Label checkForNewLabel = new Label(configurationGroup, SWT.NONE);
	checkForNewLabel.setText("Check for New Version on Start Up:");
	checkForNewLabel.setBounds(10, 67, 175, 13);

	yesButton = new Button(configurationGroup, SWT.RADIO);
	yesButton.setText("Yes");
	yesButton.setBounds(191, 65, 38, 16);

	noButton = new Button(configurationGroup, SWT.RADIO);
	noButton.setText("No");
	noButton.setBounds(239, 65, 38, 16);

	
	if(autoUpdateStr.equals("true"))
	{
	    yesButton.setSelection(true);
	    noButton.setSelection(false);
	}
	else
	{
	    yesButton.setSelection(false);
	    noButton.setSelection(true);	    
	}
	
	cancelButton = new Button(shell, SWT.NONE);
	cancelButton.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		shell.close();
	    }
	});
	cancelButton.setBounds(494, 456, 90, 23);
	cancelButton.setText("Cancel");

	finishButton = new Button(shell, SWT.NONE);
	finishButton.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		
		String val;
		if(yesButton.getSelection() == true)val = "true";
		else val="false";
		
		PersistentSettings.setProperty("UPDATE.AUTO", val);
		PersistentSettings.setProperty("UPDATE.SAVELOCATION", updateSavePath.getText());
		PersistentSettings.setProperty("UPDATE.URL", updateURL.getText());
		PersistentSettings.setProperty("proxyHost", getProxyHost().getText());
		PersistentSettings.setProperty("proxyPort", getProxyPort().getText());		
		
		PersistentSettings.setProxyIfRequired();
		
		shell.close();
	    }
	});
	finishButton.setBounds(398, 456, 90, 23);
	finishButton.setText("Finish");

	final Group advanceConfigurationGroup = new Group(shell, SWT.NONE);
	advanceConfigurationGroup.setText("Advanced Configuration");
	advanceConfigurationGroup.setBounds(10, 311, 574, 90);

	final Label updatePathLabel = new Label(advanceConfigurationGroup, SWT.NONE);
	updatePathLabel.setText("Update Save Path:");
	updatePathLabel.setBounds(12, 45, 96, 13);

	updateSavePath = new Text(advanceConfigurationGroup, SWT.BORDER);
	updateSavePath.setBounds(114, 42, 450, 25);
	updateSavePath.setText(savePathStr);

	final Group proxyServerSettingsGroup = new Group(shell, SWT.NONE);
	proxyServerSettingsGroup.setText("Proxy Server Settings");
	proxyServerSettingsGroup.setBounds(10, 199, 574, 99);

	final Label httpProxyServerLabel = new Label(proxyServerSettingsGroup, SWT.NONE);
	httpProxyServerLabel.setText("Proxy Host:");
	httpProxyServerLabel.setBounds(10, 32, 93, 13);

	final Label portLabel = new Label(proxyServerSettingsGroup, SWT.NONE);
	portLabel.setText("Proxy Port:");
	portLabel.setBounds(10, 58, 87, 13);

	proxyHost = new Text(proxyServerSettingsGroup, SWT.BORDER);
	proxyHost.setBounds(114, 26, 449, 25);
	proxyHost.setText(proxyHostStr);

	proxyPort = new Text(proxyServerSettingsGroup, SWT.BORDER);
	proxyPort.setBounds(114, 54, 141, 25);
	proxyPort.setText(proxyPortStr);
	//
    }

    
    public void downloadLatestVersion(Text text)
    {
	try
	{
	    checkForLaterVersion(text);
	    text.redraw();
	    if(text.getText().indexOf("UPDATE REQUIRED")>=0)
	    {
		text.setText(text.getText() + "\r\nDownloading update from server...\r\n");
		text.redraw();
		
		UpdateDetails d = CheckForUpdates.checkLatestVersion(updateURL.getText());
		CheckForUpdates.downloadUpdate(updateURL.getText());
		text.setText(text.getText() + "Update download completed\r\n");
	    }
	    else
	    {
		text.setText(text.getText() + "\r\nNo update downloaded\r\n");
	    }
	    text.redraw();

	}
	catch (Exception e)
	{
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	    text.setText(text.getText() + "Error Contacting Update Server: " + updateURL.getText() + "\n\n" + e.toString());
	}

    }
    
    public void checkForLaterVersion(Text text)
    {
	try
	{
	    text.setEnabled(true);
	    text.setText("AGEMAME Layout Editor Update Check\r\n");
	    text.setText(text.getText() + "Current Version: " + Version.getVersion() + "[" + Version.getNumericVersion() + "] \r\n");
	    text.setText(text.getText() + "Contacting Update Server [" + updateURL.getText() + "]... \r\n");
	    text.redraw();
	    UpdateDetails d = CheckForUpdates.checkLatestVersion(updateURL.getText());
	    text.setText(text.getText() + "Version on update server: " + d.getVersion() + "\r\n\r\n");

	    boolean isUptoDate = CheckForUpdates.isVersionUptoDate(d);

	    if (!isUptoDate)
	    {
		text.setText(text.getText() + "*****************************************\r\n");
		text.setText(text.getText() + "AGEMAME Layout Editor UPDATE REQUIRED!\r\n");
		text.setText(text.getText() + "*****************************************\r\n");
	    }
	    else
	    {
		text.setText(text.getText() + "AGEMAME Layout Editor is the latest version.  Update NOT required.\r\n");
	    }

	}
	catch (IOException e)
	{
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	    text.setText(text.getText() + "Error Contacting Update Server: " + updateURL.getText() + "\n\n" + e.toString());
	}

    }

    public Text getUpdateURL()
    {
	return updateURL;
    }

    public Button getFinishButton()
    {
	return finishButton;
    }

    public Button getCancelButton()
    {
	return cancelButton;
    }
	public Button getYesButton()
	{
		return yesButton;
	}
	public Button getNoButton()
	{
		return noButton;
	}
	public Text getUpdateSavePath()
	{
		return updateSavePath;
	}
	public Text getProxyHost()
	{
		return proxyHost;
	}
	public Text getProxyPort()
	{
		return proxyPort;
	}



}
