package uk.co.pembo.agemame.userinterface;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

import javax.net.ssl.HandshakeCompletedListener;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

import uk.co.pembo.agemame.exception.LayoutParseException;
import uk.co.pembo.agemame.info.Version;
//import uk.co.pembo.agemame.render.LayoutRenderer;
import uk.co.pembo.agemame.swtrender.LayoutRenderer;
import uk.co.pembo.agemame.swtrender.SourceRenderer;
import uk.co.pembo.agemame.ui.DetailsPanel;
import uk.co.pembo.agemame.ui.ItemsTree;
import uk.co.pembo.agemame.ui.ExplorerTree;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.io.FileUtils;
import uk.co.pembo.util.PersistentSettings;

//import com.swtdesigner.SWTResourceManager;

public class MainApplication
{

    private static boolean newVersion = false;
    public MameLayoutManager layoutManager;
    public uk.co.pembo.agemame.swtrender.LayoutRenderer swtLayoutRenderer;
    public uk.co.pembo.agemame.swtrender.SourceRenderer swtSourceRenderer;

    private Text consoleText;
    private Label statusBarCaption;
    public String paramFileName = null; // Holds the command line filename
    public String lastPath; // used to seed the file dialog
    public String currentLayoutFile; // used to seed the file dialog

    public int sourcePos = 0;
    
    public GC imageCanvasGC;

    private Text layoutXml;
    private TabFolder tabFolder_1;
    private Composite textViewComposite;
    private Canvas previewCanvas;
    private Composite consoleComposite;
    private Composite problemsComposite;
    private ProgressBar statusProgressBar;
    private Shell agemameLayoutEditorShell;
    private Display display;
    private ItemsTree itemsPanel;
    private ExplorerTree explorerPanel;
    private DetailsPanel details;

    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private ApplicationHandler handler = new ApplicationHandler();

    private static Logger log = Logger.getLogger(MainApplication.class.getPackage().getName());

    private int bottomHeight = 0;
    private int topHeight = 0;

    private MenuItem saveas;
    private MenuItem save;
    private ToolItem saveToolbarItem;
    private ToolItem refreshToolbarItem;

    //private PrintStream origOut = System.out;
    //private PrintStream origErr = System.err;

    //private PrintStream aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));

    private Cursor crossCursor;

    /**
     * Launch the application
     * 
     * @param args
     */
    public static void main(String[] args)
    {

	try
	{
	    System.setProperty("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true");
	    MainApplication window = new MainApplication();

	    // Load persistent settings
	    PersistentSettings.loadPropertiesFile();
	    PersistentSettings.initProperties();




	    // Default Loggers to INFO
	    Logger.getLogger("uk.co.pembo").setLevel(Level.INFO);
	    Logger.getLogger("com.fruitforums").setLevel(Level.INFO);
	    Logger.getLogger("uk.co.pembo").addHandler(window.handler);
	    Logger.getLogger("com.fruitforums").addHandler(window.handler);

	    window.open();

	    // Check command line argument for layout
	    window.checkandOpenCommandLineLayout(args, window);

	}
	catch (Exception e)
	{
	    e.printStackTrace();
	}
    }

    /**
     * @param args
     * @param window
     */
    private void checkandOpenCommandLineLayout(String[] args, MainApplication window)
    {
	if (args.length > 0) window.paramFileName = args[0];
	if (paramFileName != null)
	{
	    // menuOpenFile(paramFileName);
	}
    }

    /**
     * Open and setup the application window
     *
     */
    public void open()
    {
	display = Display.getDefault();

	int height = display.getBounds().height;
	int width = display.getBounds().width;

	int diff = 0;
	if (width > 1280)
	{
	    diff = width - 1280;
	}

	int leftExtraToAdd = 0;
	int midExtraToAdd = 0;
	int rightExtraToAdd = 0;

	if (diff > 0)
	{
	    //split 3 ways 30% 10% 60%
	    float split = diff / 10;
	    float left = 3 * split;
	    float right = 6 * split;

	    leftExtraToAdd = new BigDecimal(left).intValue();
	    //rightExtraToAdd = new BigDecimal(right).intValue();
	    rightExtraToAdd = diff - (leftExtraToAdd + midExtraToAdd);
	}

	//int heightAdjust = 30;
	agemameLayoutEditorShell = new Shell();

	uk.co.pembo.agemame.userinterface.SWTResourceManager.registerResourceUser(agemameLayoutEditorShell);

	agemameLayoutEditorShell.setSize(width, height - 20);
	agemameLayoutEditorShell.setMaximized(true);
	agemameLayoutEditorShell.setText("AGEMAME Layout Editor v" + Version.getVersion());
	//agemameLayoutEditorShell.setImage(SWTResourceManager.getImage("D:/eclipse/workspace/AgeMameLayoutEditor/bin/icons/MameLayout.gif"));
	//@todo: remove the bin!?
	agemameLayoutEditorShell.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "MameLayout.gif"));
	agemameLayoutEditorShell.open();

	final SashForm sashForm = new SashForm(agemameLayoutEditorShell, SWT.NONE);

	final TabFolder tabFolder = new TabFolder(sashForm, SWT.NONE);

	final TabItem explorerTabItem = new TabItem(tabFolder, SWT.NONE);
	explorerTabItem.setText("Explorer");


	explorerPanel = new ExplorerTree(tabFolder, SWT.NONE);
	explorerPanel.setVisible(false);
	explorerTabItem.setControl(explorerPanel);


	//final Composite explorerComposite = new Composite(tabFolder, SWT.NONE);
	//explorerTabItem.setControl(explorerComposite);

	int sashHeight = height - 158;
	int sashWidth = width - 22;
	sashForm.setBounds(10, 28, sashWidth, sashHeight);

	final SashForm sashForm_1 = new SashForm(sashForm, SWT.NONE);
	//	sashForm_1.addPaintListener(new PaintListener()
	//	{
	//	    public void paintControl(PaintEvent event)
	//	    {
	//		    Rectangle bounds = textViewComposite.getBounds();
	//		    layoutXml.setBounds(0, 0, bounds.width-5, bounds.height-30);
	//	    }
	//	});

	tabFolder_1 = new TabFolder(sashForm_1, SWT.NONE);

	final TabItem previewTabItem = new TabItem(tabFolder_1, SWT.NONE);
	previewTabItem.setText("Preview");

	final ScrolledComposite previewScrolledComposite = new ScrolledComposite(tabFolder_1, SWT.V_SCROLL | SWT.H_SCROLL);
	previewTabItem.setControl(previewScrolledComposite);

	previewCanvas = new Canvas(previewScrolledComposite, SWT.NONE);
	previewCanvas.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	//previewCanvas.setBounds(0, 0, 939, 1200);
	//previewCanvas.setSize(939, 1200);
	previewCanvas.addPaintListener(new PaintListener()

	{
	    public void paintControl(PaintEvent event)
	    {
//		if (LayoutRenderer.isInitialised() && LayoutRenderer.getSpriteManager().size() < 0)
//		{
//		Rectangle bounds = previewCanvas.getBounds();
//		event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
//		}
//		else
//		{
//		Rectangle bounds = previewCanvas.getBounds();
//		event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
//		paintImage(event);
//		}
		if(swtLayoutRenderer == null)
		{
		    Rectangle bounds = previewCanvas.getBounds();
		    event.gc.fillRectangle(0, 0, bounds.width, bounds.height);		    
		}
		else
		{
		    Rectangle bounds = previewCanvas.getBounds();
		    event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
		    paintImage(event);
		}
	    }
	});
	previewCanvas.setLocation(0, 0);
	//939,1200 for Sidewinder
	//Should set on load of layout to biggest size
	//plus user should be able to set it
	previewCanvas.setSize(731, 600);
	previewScrolledComposite.setContent(previewCanvas);

	imageCanvasGC = new GC(previewCanvas);
	previewCanvas.addDisposeListener(new DisposeListener()
	{
	    public void widgetDisposed(DisposeEvent e)
	    {
		imageCanvasGC.dispose();
	    }
	});

	crossCursor = new Cursor(display, SWT.CURSOR_CROSS);

	final TabItem textViewTabItem = new TabItem(tabFolder_1, SWT.NONE);
	textViewTabItem.setText("Source");


	tabFolder_1.addSelectionListener(new SelectionListener()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		log.finest("Tab Changed");

		if(event.item instanceof TabItem)
		{
		    TabItem item = (TabItem)event.item;
		    if(item.getText().equalsIgnoreCase("Source"))
		    {
			//refresh the xml
			if(swtSourceRenderer!=null)swtSourceRenderer.refreshSource();
			if(layoutXml.getText().length()>=sourcePos)
			{
			    layoutXml.setSelection(sourcePos);
			}
		    }

		    if(item.getText().equalsIgnoreCase("preview"))
		    {
			//Get the scroll position of the source.
			//sourcePos = layoutXml.getCaretPosition();
			
			String xml = layoutXml.getText().trim();
			log.finer("XML potentially changed in text view - rebuild objects.");
				
			
			try
			{
			    //layoutManager = new MameLayoutManager(new StringBuffer(xml));
			    if(layoutManager!=null && itemsPanel!=null)
			    {
				layoutManager.updateXml(xml);
				itemsPanel.populateTree();
			    }
			    
			    
			}
			catch (LayoutParseException e)
			{
			    
			    MessageBox messageBox = new MessageBox(agemameLayoutEditorShell, SWT.ICON_ERROR | SWT.OK);
			    messageBox.setMessage("Unable to switch to preview due to errors in the XML.\nPlease correct the errors before switching\n\n Error:\n" + e.getMessage());
			    messageBox.setText("Error");
			    messageBox.open();
			    
			    tabFolder_1.setSelection(1);
			    
			    
			}
		    }

		}

	    }

	    public void widgetDefaultSelected(SelectionEvent event)
	    {
		log.warning("WIDGET DEFAULT SELECTED");
	    }
	});

	//textViewComposite = new Composite(tabFolder_1, SWT.NONE);

	textViewComposite = new ScrolledComposite(tabFolder_1, SWT.V_SCROLL | SWT.H_SCROLL);


	textViewTabItem.setControl(textViewComposite);


	layoutXml = new Text(textViewComposite, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.H_SCROLL);
	layoutXml.setFont(SWTResourceManager.getFont("Courier New", 10, SWT.NONE));
	layoutXml.setRedraw(true);
	layoutXml.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	layoutXml.setBounds(0, 0, 786, sashHeight - 200);

	layoutXml.addPaintListener(new PaintListener()
	{
	    public void paintControl(PaintEvent event)
	    {
		//		    Rectangle bounds = textViewComposite.getBounds();
		//		    layoutXml.setBounds(0, 0, bounds.width-5, bounds.height-30);
		log.finest("Repainting Source Tab");
	    }
	});

	sashForm_1.setOrientation(SWT.VERTICAL);

	final TabFolder tabFolder_2 = new TabFolder(sashForm_1, SWT.NONE);

	final TabItem problemsTabItem = new TabItem(tabFolder_2, SWT.NONE);
	problemsTabItem.setText("Problems");

	problemsComposite = new Composite(tabFolder_2, SWT.NONE);
	problemsTabItem.setControl(problemsComposite);

	final TabItem consoleTabItem = new TabItem(tabFolder_2, SWT.NONE);
	consoleTabItem.setText("Console");

	consoleComposite = new Composite(tabFolder_2, SWT.NONE);
	consoleTabItem.setControl(consoleComposite);

	consoleText = new Text(consoleComposite, SWT.V_SCROLL | SWT.MULTI | SWT.WRAP);
	consoleText.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	consoleText.setEditable(false);
	consoleText.setFont(SWTResourceManager.getFont("Courier New", 10, SWT.NONE));
	consoleText.setBounds(0, 0, 786, 169);
	consoleText.setTextLimit(30000);

	//System.setOut(aPrintStream); // catches System.out messages
	//System.setErr(aPrintStream); // catches error messages

	final TabItem propertiesTabItem = new TabItem(tabFolder_2, SWT.NONE);
	propertiesTabItem.setText("Properties");

	//propertiesComposite = new Composite(tabFolder_2, SWT.NONE);
	details = new DetailsPanel(tabFolder_2);
	details.setVisible(false);
	propertiesTabItem.setControl(details);

	tabFolder_2.setSelection(consoleTabItem);

	sashForm_1.setWeights(new int[] { 669, 194 });

	final TabFolder tabFolder_3 = new TabFolder(sashForm, SWT.NONE);

	final TabItem layoutHierarchyTabItem = new TabItem(tabFolder_3, SWT.NONE);
	layoutHierarchyTabItem.setText("Layout Hierarchy");

	//final Composite hierarchyComposite = new Composite(tabFolder_3, SWT.NONE);
	itemsPanel = new ItemsTree(tabFolder_3, SWT.NONE);
	itemsPanel.setVisible(false);
	layoutHierarchyTabItem.setControl(itemsPanel);

	System.out.println(leftExtraToAdd);
	System.out.println(midExtraToAdd);
	System.out.println(rightExtraToAdd);

	sashForm.setWeights(new int[] { 225 + leftExtraToAdd, 795 + midExtraToAdd, 232 + rightExtraToAdd });

	final Composite statusBarComposite = new Composite(agemameLayoutEditorShell, SWT.BORDER | SWT.EMBEDDED);
	int statusHeight = height - 120;
	Rectangle rec = new Rectangle(10, statusHeight, 1258, 36);
	statusBarComposite.setBounds(rec);

	statusBarCaption = new Label(statusBarComposite, SWT.SHADOW_NONE);
	statusBarCaption.setText("OK");
	statusBarCaption.setBounds(10, 10, 813, 21);

	statusProgressBar = new ProgressBar(statusBarComposite, SWT.NONE);
	statusProgressBar.setBounds(1145, 10, 100, 17);

	//!!	/* --- COMMENT OUT BEFORE ENTERING DESIGN MODE --- */
	final Menu menu = new Menu(agemameLayoutEditorShell, SWT.BAR);
	agemameLayoutEditorShell.setMenuBar(menu);
	createMenuBar(menu);
	//!!	/* --- COMMENT OUT BEFORE ENTERING DESIGN MODE --- */

	final ToolBar toolBar = new ToolBar(agemameLayoutEditorShell, SWT.NONE);
	toolBar.setBounds(0, 0, 1268, 22);

	ToolItem openToolbarItem = new ToolItem(toolBar, SWT.NONE);
	openToolbarItem.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/" + "open.gif"));
	openToolbarItem.setToolTipText("Open existing Layout file");
	openToolbarItem.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuOpenFile();

	    }
	});

	saveToolbarItem = new ToolItem(toolBar, SWT.NONE);
	saveToolbarItem.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/" + "save.gif"));
	saveToolbarItem.setEnabled(false);
	saveToolbarItem.setToolTipText("Save Layout File");
	saveToolbarItem.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuSave();

	    }
	});

	refreshToolbarItem = new ToolItem(toolBar, SWT.NONE);
	refreshToolbarItem.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/" + "refresh.gif"));
	refreshToolbarItem.setToolTipText("Reload and refresh layout file");
	refreshToolbarItem.setEnabled(false);
	refreshToolbarItem.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuRefreshFile();

	    }
	});
	
	
	ToolItem sep = new ToolItem(toolBar, SWT.SEPARATOR);
	//sep.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/" + "separator.png"));
	
	
	
	
	ToolItem absolute = new ToolItem(toolBar, SWT.NONE);
	absolute.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/" + "refresh.gif"));
	absolute.setToolTipText("Display as absolute size");
	absolute.setEnabled(false);
	absolute.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuRefreshFile();

	    }
	});
	
	ToolItem fitToScreen = new ToolItem(toolBar, SWT.NONE);
	fitToScreen.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/" + "refresh.gif"));
	fitToScreen.setToolTipText("Fit to Screen");
	fitToScreen.setEnabled(false);
	fitToScreen.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuRefreshFile();

	    }
	});	
	
	


	log.info("AGEMAME Layout Editor v" + Version.getVersion());
	log.info("Copyright (C)2006-2007 D.Pemberton");
	log.info("------------------------------------------");
	log.info("All rights reserved");

	//Check for update
	String val = PersistentSettings.getPropertyValue("UPDATE.AUTO", "true");
	PersistentSettings.setProperty("UPDATE.AUTO", val);

	try
	{
	    if (val.equalsIgnoreCase("true"))
	    {
		UpdateDetails d = CheckForUpdates.checkLatestVersion(PersistentSettings.getPropertyValue("UPDATE.URL"));
		if (!CheckForUpdates.isVersionUptoDate(d))
		{
		    FindAndInstall faiDialog = new FindAndInstall(agemameLayoutEditorShell, SWT.NONE);
		    faiDialog.open(true);
		}
	    }
	}
	catch (IOException e1)
	{
	    // TODO Auto-generated catch block
	    e1.printStackTrace();
	}

	//Finally - do need to show new version info?
	newVersion = false;
	newVersion = PersistentSettings.isVersionChanged();

	if(newVersion)
	{
	    NewVersionInfo nvi = new NewVersionInfo(agemameLayoutEditorShell, SWT.NONE);
	    nvi.open();
	}


	while (!agemameLayoutEditorShell.isDisposed())
	{
	    if (!display.readAndDispatch()) display.sleep();
	}

	PersistentSettings.writePropertiesFile();
    }

    public Composite getProblemsComposite()
    {
	return problemsComposite;
    }

    public Composite getConsoleComposite()
    {
	return consoleComposite;
    }

    public Canvas getPreviewCanvas()
    {
	return previewCanvas;
    }

    public Composite getTextViewComposite()
    {
	return textViewComposite;
    }

    public Text getLayoutXml()
    {
	return layoutXml;
    }

    // ------------------ APPLICATION MENU HANDLING
    public void createFileMenu(Menu menuBar)
    {

	// File menu
	MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
	item.setText("File");
	Menu fileMenu = new Menu(agemameLayoutEditorShell, SWT.DROP_DOWN);
	item.setMenu(fileMenu);

	// File -> Open File...
	item = new MenuItem(fileMenu, SWT.PUSH);
	item.setText("&Open File...\tCtrl+O");
	item.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/open.gif"));
	item.setAccelerator(SWT.MOD1 + 'O');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuOpenFile();
	    }
	});

	new MenuItem(fileMenu, SWT.SEPARATOR);

	for (int i = 0; i < PersistentSettings.lastUsedFiles.size(); i++)
	{
	    if (PersistentSettings.lastUsedFiles.get(i) != null)
	    {
		item = new MenuItem(fileMenu, SWT.PUSH);
		item.setData(PersistentSettings.lastUsedFiles.get(i));
		item.setText(i + 1 + " " + PersistentSettings.lastUsedFiles.get(i));

		item.addSelectionListener(new SelectionAdapter()
		{
		    public void widgetSelected(SelectionEvent event)
		    {
			MenuItem item = (MenuItem) event.getSource();
			menuOpenFile(item.getData().toString());
		    }
		});
	    }
	    else
	    {

	    }
	}

	new MenuItem(fileMenu, SWT.SEPARATOR);

	// File -> Save
	save = new MenuItem(fileMenu, SWT.PUSH);
	save.setText("&Save\tCtrl+S");
	save.setEnabled(false);
	save.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/save.gif"));
	save.setAccelerator(SWT.MOD1 + 'S');
	save.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuSaveAs(currentLayoutFile);
	    }
	});

	// File -> Save As...
	saveas = new MenuItem(fileMenu, SWT.PUSH);
	saveas.setEnabled(false);
	saveas.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/saveas.gif"));
	saveas.setText("Save &As...");
	saveas.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		menuSaveAs(null);
	    }
	});

	new MenuItem(fileMenu, SWT.SEPARATOR);

	// File -> Exit
	item = new MenuItem(fileMenu, SWT.PUSH);
	item.setText("E&xit");
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		agemameLayoutEditorShell.close();
	    }
	});

    }

    public void menuSaveAs(String infilename)
    {
	String filename = null;
	if (infilename == null || infilename.length() == 0)
	{
	    FileDialog fileChooser = new FileDialog(agemameLayoutEditorShell, SWT.SAVE);
	    fileChooser.setFilterPath(lastPath);
	    if (currentLayoutFile != null)
	    {
		String name = currentLayoutFile;
		int nameStart = name.lastIndexOf(java.io.File.separatorChar);
		if (nameStart > -1)
		{
		    name = name.substring(nameStart + 1);
		}
		fileChooser.setFileName(name);
	    }
	    fileChooser.setFilterExtensions(GuiMenuHandling.OPEN_FILTER_EXTENSIONS);
	    fileChooser.setFilterNames(GuiMenuHandling.OPEN_FILTER_NAMES);
	    filename = fileChooser.open();
	}
	else
	{
	    filename = infilename;
	}

	try
	{

	    String res = layoutManager.toXml();
	    //String res = MapperToXml.map(LayoutRenderer.getLayout());
	    //log.info(res);
	    FileUtils.writeStringToFile(res, filename);
	    log.info("Save of Layout [" + filename + "] complete");
	    this.setStatusBarCaption("Save of Layout [" + filename + "] complete");
	}
	catch (Exception e)
	{
	    // TODO: handle exception
	    log.severe(e.toString());
	}

    }

    public void menuSave()
    {
	menuSaveAs(currentLayoutFile);
    }

    public void menuOpenFile()
    {
	menuOpenFile(null);
    }

    public void menuRefreshFile()
    {
	String filename = currentLayoutFile;

	if (filename == null)
	{
	    // Get the user to choose an image file.
	    FileDialog fileChooser = new FileDialog(agemameLayoutEditorShell, SWT.OPEN);
	    if (lastPath != null) fileChooser.setFilterPath(lastPath);
	    fileChooser.setFilterExtensions(GuiMenuHandling.OPEN_FILTER_EXTENSIONS);
	    fileChooser.setFilterNames(GuiMenuHandling.OPEN_FILTER_NAMES);
	    filename = fileChooser.open();
	    lastPath = fileChooser.getFilterPath();
	}

	if (filename == null) return;

	saveas.setEnabled(true);
	save.setEnabled(true);
	saveToolbarItem.setEnabled(true);
	refreshToolbarItem.setEnabled(true);
	this.setStatusBarCaption("Loading [" + filename + "] - Please wait...");

	PersistentSettings.addLastUsedFile(filename);

	// menuBar.dispose();
	// createMenuBar();

	Cursor waitCursor = new Cursor(display, SWT.CURSOR_WAIT);
	agemameLayoutEditorShell.setCursor(waitCursor);
	getPreviewCanvas().setCursor(waitCursor);

	try
	{
	    long startTime = System.currentTimeMillis();
	    //LayoutRenderer.initialise(filename, display, this.getLayoutXml(), this.getStatusProgressBar());
	    layoutManager = new MameLayoutManager(filename);
	    swtLayoutRenderer = new LayoutRenderer(display,layoutManager);
	    swtSourceRenderer = new SourceRenderer(this.getLayoutXml(),layoutManager);

	    itemsPanel.empty();
	    explorerPanel.empty();
	    //DPP - FIX HERE!
	    //itemsPanel.populateLayoutData();
//	    itemsPanel.registerDetailsPanel(details);
//	    itemsPanel.registerCanvas(getPreviewCanvas());
//	    itemsPanel.registerGC(imageCanvasGC);
//	    itemsPanel.registerSelf(itemsPanel);
//	    itemsPanel.registerShell(agemameLayoutEditorShell);

	    itemsPanel.registerDependencies(layoutManager, imageCanvasGC, agemameLayoutEditorShell, getPreviewCanvas(), details, itemsPanel);
	    explorerPanel.registerDependencies(layoutManager, imageCanvasGC, agemameLayoutEditorShell, getPreviewCanvas(), details, explorerPanel);

	    //Need to popualte the layoutData now.
	    log.finest("Populating items panel");
	    itemsPanel.populateTree();
	    log.finest("Populating explorer panel");
	    explorerPanel.populateTree(filename);
	    log.finest("done population");

	    //details.registerCanvas(getPreviewCanvas());

	    itemsPanel.setVisible(true);
	    explorerPanel.setVisible(true);

	    // details.setVisible(true);
	    long loadTime = System.currentTimeMillis() - startTime;
	    loadTime = loadTime / 1000;
	    // imageDataArray = loader.load(filename);
	    // if (imageDataArray.length > 0) {
	    // Cache the filename.
	    // currentName = filename;
	    currentLayoutFile = filename;
	    setStatusBarCaption("Loaded: " + currentLayoutFile);

	    // fileName = filename;

	    // If there are multiple images in the file (typically GIF)
	    // then enable the Previous, Next and Animate buttons.
	    // previousButton.setEnabled(imageDataArray.length > 1);
	    // nextButton.setEnabled(imageDataArray.length > 1);
	    // animateButton.setEnabled(imageDataArray.length > 1 &&
	    // loader.logicalScreenWidth > 0 && loader.logicalScreenHeight >
	    // 0);

	    // Display the first image in the file.
	    // imageDataIndex = 0;
	    // displayImage(null);
	    // imageCanvas.redraw();
	    // imageCanvasGC.
	    paintSprites(imageCanvasGC);
	    // !!!!!
	    // /Render the LAYOUT
	    // }
	}
	catch (FileNotFoundException e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);	    
	}
	catch (LayoutParseException e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);	    
	}
	catch (SWTException e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);
	    // loader = oldLoader;
	}
	catch (SWTError e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);
	    // loader = oldLoader;
	}
	catch (OutOfMemoryError e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);
	    // loader = oldLoader;
	}
	finally
	{
	    agemameLayoutEditorShell.setCursor(null);
	    getPreviewCanvas().setCursor(crossCursor);
	    waitCursor.dispose();
	}
    }

    public void menuOpenFile(String filename)
    {

	if (filename == null)
	{
	    // Get the user to choose an image file.
	    FileDialog fileChooser = new FileDialog(agemameLayoutEditorShell, SWT.OPEN);
	    if (lastPath != null) fileChooser.setFilterPath(lastPath);
	    fileChooser.setFilterExtensions(GuiMenuHandling.OPEN_FILTER_EXTENSIONS);
	    fileChooser.setFilterNames(GuiMenuHandling.OPEN_FILTER_NAMES);
	    filename = fileChooser.open();
	    lastPath = fileChooser.getFilterPath();
	}

	if (filename == null) return;

	saveas.setEnabled(true);
	save.setEnabled(true);
	saveToolbarItem.setEnabled(true);
	refreshToolbarItem.setEnabled(true);
	this.setStatusBarCaption("Loading [" + filename + "] - Please wait...");

	PersistentSettings.addLastUsedFile(filename);

	// menuBar.dispose();
	// createMenuBar();

	Cursor waitCursor = new Cursor(display, SWT.CURSOR_WAIT);
	agemameLayoutEditorShell.setCursor(waitCursor);
	getPreviewCanvas().setCursor(waitCursor);

	try
	{
	    long startTime = System.currentTimeMillis();
	    //LayoutRenderer.initialise(filename, display, this.getLayoutXml(), this.getStatusProgressBar());
	    layoutManager = new MameLayoutManager(filename);
	    swtLayoutRenderer = new LayoutRenderer(display,layoutManager);
	    swtSourceRenderer = new SourceRenderer(this.getLayoutXml(),layoutManager);

	    itemsPanel.empty();
	    explorerPanel.empty();
	    //DPP - FIX HERE!
	    //itemsPanel.populateLayoutData();
//	    itemsPanel.registerDetailsPanel(details);
//	    itemsPanel.registerCanvas(getPreviewCanvas());
//	    itemsPanel.registerGC(imageCanvasGC);
//	    itemsPanel.registerSelf(itemsPanel);
//	    itemsPanel.registerShell(agemameLayoutEditorShell);

	    itemsPanel.registerDependencies(layoutManager, imageCanvasGC, agemameLayoutEditorShell, getPreviewCanvas(), details, itemsPanel);
	    explorerPanel.registerDependencies(layoutManager, imageCanvasGC, agemameLayoutEditorShell, getPreviewCanvas(), details, explorerPanel);

	    //Need to popualte the layoutData now.
	    itemsPanel.populateTree();
	    explorerPanel.populateTree(filename);
	    //details.registerCanvas(getPreviewCanvas());

	    itemsPanel.setVisible(true);
	    explorerPanel.setVisible(true);

	    // details.setVisible(true);
	    long loadTime = System.currentTimeMillis() - startTime;
	    loadTime = loadTime / 1000;
	    // imageDataArray = loader.load(filename);
	    // if (imageDataArray.length > 0) {
	    // Cache the filename.
	    // currentName = filename;
	    currentLayoutFile = filename;
	    setStatusBarCaption("Loaded: " + currentLayoutFile);

	    // fileName = filename;

	    // If there are multiple images in the file (typically GIF)
	    // then enable the Previous, Next and Animate buttons.
	    // previousButton.setEnabled(imageDataArray.length > 1);
	    // nextButton.setEnabled(imageDataArray.length > 1);
	    // animateButton.setEnabled(imageDataArray.length > 1 &&
	    // loader.logicalScreenWidth > 0 && loader.logicalScreenHeight >
	    // 0);

	    // Display the first image in the file.
	    // imageDataIndex = 0;
	    // displayImage(null);
	    // imageCanvas.redraw();
	    // imageCanvasGC.
	    paintSprites(imageCanvasGC);
	    // !!!!!
	    // /Render the LAYOUT
	    // }
	}
	catch (FileNotFoundException e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);	    
	}
	catch (LayoutParseException e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);	    
	}
	catch (SWTException e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);
	    // loader = oldLoader;
	}
	catch (SWTError e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);
	    // loader = oldLoader;
	}
	catch (OutOfMemoryError e)
	{
	    GuiMenuHandling.showErrorDialog(agemameLayoutEditorShell, "loading", filename, e);
	    // loader = oldLoader;
	}
	finally
	{
	    agemameLayoutEditorShell.setCursor(null);
	    getPreviewCanvas().setCursor(crossCursor);
	    waitCursor.dispose();
	}
    }

    private String getStatusBarCaption()
    {
	return statusBarCaption.getText();
    }

    private void setStatusBarCaption(String text)
    {
	statusBarCaption.setText(text);
    }

    public void paintSprites()
    {
	//LayoutRenderer.paintSprites(imageCanvasGC);
	//swtLayoutRenderer.paintLayout(imageCanvasGC);
	//this.previewCanvas.setSize(swtLayoutRenderer.largestWidth, swtLayoutRenderer.largestHeight);
	paintSprites(imageCanvasGC);
    }

    public void paintSprites(GC gc)
    {
	//LayoutRenderer.paintSprites(gc);
	swtLayoutRenderer.paintLayout(gc);
	this.previewCanvas.setSize(swtLayoutRenderer.largestWidth, swtLayoutRenderer.largestHeight);
    }

    private void paintImage(PaintEvent event)
    {
	GC gc = event.gc;
	//Image paintImage = image;
	paintSprites(gc);
    }

    private Menu createMenuBar(Menu menuBar)
    {
	// Menu bar.
	menuBar = new Menu(agemameLayoutEditorShell, SWT.BAR);
	agemameLayoutEditorShell.setMenuBar(menuBar);
	createFileMenu(menuBar);
	createDebugMenu(menuBar);
	createHelpMenu(menuBar);
	// createAlphaMenu(menuBar);
	return menuBar;
    }

    private void createDebugMenu(Menu menuBar)
    {

	SelectionListener radioSelected = new SelectionAdapter()
	{

	    public void widgetSelected(SelectionEvent event)
	    {
		MenuItem radio = (MenuItem) event.widget;
		//if (radio.getSelection()) bmpType[0] = ((Integer)radio.getData()).intValue();
		/*System.out.println("-------");
		 System.out.println(radio.getText());
		 System.out.println(radio.getData());
		 System.out.println(radio.getSelection());*/

		if (radio.getSelection() == true)
		{
		    Logger.getLogger("uk.co.pembo").setLevel(Level.parse(radio.getText()));
		    Logger.getLogger("com.fruitforums").setLevel(Level.parse(radio.getText()));

		    /*if(radio.getText().equals("OFF"))
		     {
		     System.setOut(aPrintStream); // catches System.out messages
		     System.setErr(aPrintStream); // catches error messages			
		     System.setOut(System.out);
		     System.setErr(System.err);			
		     }
		     else
		     {
		     System.setOut(aPrintStream); // catches System.out messages
		     System.setErr(aPrintStream); // catches error messages
		     }*/
		}

	    }
	};
	// Debug menu
	MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
	item.setText("Debug");
	Menu debugMenu = new Menu(agemameLayoutEditorShell, SWT.DROP_DOWN);
	item.setMenu(debugMenu);

	// File -> Open File...
	//#ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF 

	final MenuItem applicationConsoleLog = new MenuItem(debugMenu, SWT.CHECK);
	//applicationConsoleLog.setText("Selected");
	/*applicationConsoleLog.addSelectionListener(new SelectionAdapter() {
	 public void widgetSelected(SelectionEvent event)
	 {
	 String string = event.detail == SWT.CHECK ? "Checked": "Selected";
	 System.out.println(event.item + " " + string);

	 }
	 });*/

	applicationConsoleLog.addListener(SWT.Selection, new Listener()
	{
	    public void handleEvent(Event event)
	    {
		//System.out.println("item selected: CHECK item");
		//System.out.println("Selection: " + applicationConsoleLog.getSelection());

		if (applicationConsoleLog.getSelection())
		{
		    //System.setOut(aPrintStream); // catches System.out messages
		    //System.setErr(aPrintStream); // catches error messages		    
		    //System.out.println("IN APP");

		    //handler = new java.util.logging.StreamHandler(aPrintStream,new java.util.logging.SimpleFormatter());
		    //Logger.getLogger("uk.co.pembo").addHandler(handler);
		    //Logger.getLogger("com.fruitforums").addHandler(handler);
		    //Logger.getAnonymousLogger().addHandler(handler);

		    Logger.getLogger("uk.co.pembo").addHandler(handler);
		    Logger.getLogger("com.fruitforums").addHandler(handler);
		}
		else
		{
		    //System.setOut(origOut); // catches System.out messages
		    //System.setErr(origErr); // catches error messages		    
		    //System.out.println("REDIIRECTED BACK TO CONSOLE");
		    //Logger.getLogger("uk.co.pembo").removeHandler(handler);
		    //Logger.getLogger("com.fruitforums").removeHandler(handler);
		    //Logger.getAnonymousLogger().removeHandler(handler);

		    Logger.getLogger("uk.co.pembo").removeHandler(handler);
		    Logger.getLogger("com.fruitforums").removeHandler(handler);

		}
	    }
	});

	applicationConsoleLog.setSelection(true);

	applicationConsoleLog.setText("Log to Application");

	new MenuItem(debugMenu, SWT.SEPARATOR);

	item = new MenuItem(debugMenu, SWT.RADIO);
	item.setText("ALL");
	item.setData("ALL");
	item.addSelectionListener(radioSelected);

	item = new MenuItem(debugMenu, SWT.RADIO);
	item.setText("FINE");
	item.setData("FINE");
	item.addSelectionListener(radioSelected);

	item = new MenuItem(debugMenu, SWT.RADIO);
	item.setText("INFO");
	item.setData("INFO");
	item.setSelection(true);
	item.addSelectionListener(radioSelected);

	item = new MenuItem(debugMenu, SWT.RADIO);
	item.setText("WARNING");
	item.setData("WARNING");
	item.addSelectionListener(radioSelected);

	item = new MenuItem(debugMenu, SWT.RADIO);
	item.setText("SEVERE");
	item.setData("SEVERE");
	item.addSelectionListener(radioSelected);

	item = new MenuItem(debugMenu, SWT.RADIO);
	item.setText("OFF");
	item.setData("OFF");
	item.addSelectionListener(radioSelected);

    }

    void createHelpMenu(Menu menuBar)
    {

	//	 Help menu
	MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
	item.setText("Help");
	Menu helpMenu = new Menu(agemameLayoutEditorShell, SWT.DROP_DOWN);
	item.setMenu(helpMenu);

	final MenuItem helpMenuItem = new MenuItem(helpMenu, SWT.NONE);
	helpMenuItem.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/help.gif"));
	helpMenuItem.setText("Help Contents");
	helpMenuItem.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
	    }
	});

	new MenuItem(helpMenu, SWT.SEPARATOR);

	final MenuItem softwareUpdatesMenuItem = new MenuItem(helpMenu, SWT.CASCADE);
	softwareUpdatesMenuItem.setText("Software Updates");

	final Menu menu_2 = new Menu(softwareUpdatesMenuItem);
	softwareUpdatesMenuItem.setMenu(menu_2);

	final MenuItem findAndInstallMenuItem = new MenuItem(menu_2, SWT.NONE);
	findAndInstallMenuItem.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		FindAndInstall faiDialog = new FindAndInstall(agemameLayoutEditorShell, SWT.NONE);
		faiDialog.open(false);
	    }
	});
	findAndInstallMenuItem.setText("Find and Install");
	findAndInstallMenuItem.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/findAndInstall.gif"));
	final MenuItem manageConfigurationMenuItem = new MenuItem(menu_2, SWT.NONE);
	manageConfigurationMenuItem.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		ManageConfiguration mfDialog = new ManageConfiguration(agemameLayoutEditorShell, SWT.NONE);
		mfDialog.open();
	    }
	});
	manageConfigurationMenuItem.setText("Manage Configuration");
	manageConfigurationMenuItem.setImage(SWTResourceManager.getImage(Version.getPathToImages() + "toolbar/manageConfiguration.gif"));
	new MenuItem(helpMenu, SWT.SEPARATOR);


	// New Version Infp
	item = new MenuItem(helpMenu,SWT.PUSH);
	item.setText("Whats New?");
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		NewVersionInfo nvi = new NewVersionInfo(agemameLayoutEditorShell, SWT.NONE);
		nvi.open();
	    }
	});

	// About
	item = new MenuItem(helpMenu, SWT.PUSH);
	item.setText("About");
	//item.setAccelerator(SWT.MOD1 + 'O');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		aboutPressed();
	    }
	});

    }

    public void aboutPressed()
    {
	AboutDialog about = new AboutDialog(agemameLayoutEditorShell, SWT.NONE);
	about.open();
    }

    public Text getConsoleText()
    {
	return consoleText;
    }

    public ProgressBar getStatusProgressBar()
    {
	return statusProgressBar;
    }

    class ApplicationHandler extends java.util.logging.Handler
    {
	public void publish(LogRecord record)
	{
	    StringBuffer message = new StringBuffer();
	    Date d = new Date(record.getMillis());
	    message.append(sdf.format(d));
	    message.append(" [");
	    message.append(record.getLevel());
	    message.append("]");

	    //message.append(record.getSourceMethodName());

	    message.append(": ");
	    message.append(record.getMessage());
	    message.append("\n");

	    if ((getConsoleText().getText().length() + message.toString().length()) > getConsoleText().getTextLimit())
	    {
		getConsoleText().setText(
			getConsoleText().getText(getConsoleText().getText().length() - message.toString().length(),
				getConsoleText().getText().length()));
	    }
	    getConsoleText().append(message.toString());

	}

	public void flush()
	{
	    getConsoleText().redraw();
	}

	public void close()
	{

	}

    }

}
