package uk.co.pembo.agemame.userinterface;

import java.text.MessageFormat;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import uk.co.pembo.util.PersistentSettings;

public class GuiMenuHandling
{

    public static final String[] OPEN_FILTER_EXTENSIONS = new String[] { "*.lay; *.xml;","*.lay", "*.xml"};
    public static final String[] OPEN_FILTER_NAMES = new String[] {"All Layout Files" + " (lay, xml)", "LAYOUT (*.lay)", "XML (*.xml)"};
    public static final String[] SAVE_FILTER_EXTENSIONS = new String[] { "*.lay; *.xml;","*.lay", "*.xml"};
    public static final String[] SAVE_FILTER_NAMES = new String[] { "LAYOUT (*.lay)", "XML (*.xml)"};

    
	   /*
     * Open an error dialog displaying the specified information.
     */
    public static void showErrorDialog(Shell shell, String operation, String filename, Throwable e) {
	MessageBox box = new MessageBox(shell, SWT.ICON_ERROR);
	String message = createMsg("Error {0} file\n{1}\n\n", new String[] { operation, filename });
	String errorMessage = "";
	if (e != null) {
	    if (e instanceof SWTException) {
		SWTException swte = (SWTException) e;
		errorMessage = swte.getMessage();
		if (swte.throwable != null) {
		    errorMessage += ":\n" + swte.throwable.toString();
		}
	    } else if (e instanceof SWTError) {
		SWTError swte = (SWTError) e;
		errorMessage = swte.getMessage();
		if (swte.throwable != null) {
		    errorMessage += ":\n" + swte.throwable.toString();
		}
	    } else {
		errorMessage = e.toString();
	    }
	}
	box.setMessage(message + errorMessage);
	box.open();
    }    
    
    private static String createMsg(String msg, Object[] args) {
	MessageFormat formatter = new MessageFormat(msg);
	return formatter.format(args);
    }

    private static String createMsg(String msg, Object arg) {
	MessageFormat formatter = new MessageFormat(msg);
	return formatter.format(new Object[] { arg });
    }  
}
