package uk.co.pembo.agemame.userinterface;

import java.io.IOException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.updatemanager.CheckForUpdates;
import uk.co.pembo.agemame.updatemanager.UpdateDetails;
import uk.co.pembo.util.PersistentSettings;

public class FindAndInstall extends Dialog
{

    private StyledText styledText;
    private Button checkLaterVersion;
    private Button checkAndUpdateButton;
    private Button cancelButton;
    private Button finishButton;
    private Text updateURL;
    protected Object result;
    protected Shell shell;
    protected boolean updated = false;

    private String updateURLStr;

    /**
     * Create the dialog
     * @param parent
     * @param style
     */
    public FindAndInstall(Shell parent, int style)
    {
	super(parent, style);
	updateURLStr = PersistentSettings.getPropertyValue("UPDATE.URL");
	if (updateURLStr == null || updateURLStr.length() == 0) updateURLStr = "http://www.dpembo.ukfsn.org/agemame/release/update/";
    }

    /**
     * Create the dialog
     * @param parent
     */
    public FindAndInstall(Shell parent)
    {
	this(parent, SWT.NONE);
    }

    /**
     * Open the dialog
     * @return the result
     */
    public Object open(boolean runAutoCheck)
    {
	createContents(runAutoCheck);
	shell.open();
	shell.layout();
	Display display = getParent().getDisplay();
	while (!shell.isDisposed())
	{
	    if (!display.readAndDispatch()) display.sleep();
	}
	return result;
    }

    /**
     * Create contents of the dialog
     */
    protected void createContents(boolean runAutoCheck)
    {
	shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	shell.setSize(600, 550);
	shell.setText("Install/Update");

	int guessWidth = 600;
	int guessHeigh = 550;

	shell.setLocation((this.getParent().getSize().x - guessWidth) / 2, (this.getParent().getSize().y - guessHeigh) / 2);

	final Composite composite = new Composite(shell, SWT.BORDER | SWT.EMBEDDED);
	composite.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	composite.setBounds(0, 0, 594, 67);

	final Canvas canvas = new Canvas(composite, SWT.NONE);
	canvas.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	canvas.setBounds(515, 0, 77, 64);
	canvas.setBackgroundImage(SWTResourceManager.getImage(Version.getPathToImages() + "dialogs/findAndInstall.gif"));

	final Label updateAgemameLayoutLabel = new Label(composite, SWT.NONE);
	updateAgemameLayoutLabel.setFont(SWTResourceManager.getFont("", 10, SWT.BOLD));
	updateAgemameLayoutLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	updateAgemameLayoutLabel.setText("Update AGEMAME Layout Editor");
	updateAgemameLayoutLabel.setBounds(10, 10, 237, 13);

	final Label checkForLaterLabel = new Label(composite, SWT.NONE);
	checkForLaterLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	checkForLaterLabel.setText("Check for later versions of AGEMAME Layout Editor and update if required");
	checkForLaterLabel.setBounds(10, 30, 378, 13);

	checkAndUpdateButton = new Button(shell, SWT.NONE);
	checkAndUpdateButton.setEnabled(true);
	checkAndUpdateButton.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		downloadLatestVersion(getStyledText());
		finishButton.setEnabled(true);
	    }
	});
	checkAndUpdateButton.setText("Check and Update");
	checkAndUpdateButton.setBounds(292, 456, 100, 23);

	checkLaterVersion = new Button(shell, SWT.NONE);
	checkLaterVersion.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		checkForLaterVersion(getStyledText());
		finishButton.setEnabled(true);
	    }
	});
	checkLaterVersion.setBounds(163, 456, 124, 23);
	checkLaterVersion.setText("Check for Later Version");

	cancelButton = new Button(shell, SWT.NONE);
	cancelButton.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		shell.close();
	    }
	});
	cancelButton.setBounds(494, 456, 90, 23);
	cancelButton.setText("Cancel");

	finishButton = new Button(shell, SWT.NONE);
	finishButton.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent arg0)
	    {
		PersistentSettings.setProperty("UPDATE.URL", updateURL.getText());
		if(updated)
		{
		    PersistentSettings.writePropertiesFile();
		    System.exit(0);
		}
		shell.close();
	    }
	});
	finishButton.setEnabled(false);
	finishButton.setBounds(398, 456, 90, 23);
	finishButton.setText("Finish");

	final Group updateDetailsGroup = new Group(shell, SWT.NONE);
	updateDetailsGroup.setBounds(10, 73,584, 362);
	updateDetailsGroup.setText("Check/Update Details");

	styledText = new StyledText(updateDetailsGroup, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.WRAP);
	styledText.setBounds(10, 28, 554, 324);

	updateURL = new Text(shell, SWT.BORDER);
	updateURL.setVisible(false);
	updateURL.setBounds(115, 485,469, 25);
	updateURL.setText(updateURLStr);

	final Label updateServerLabel = new Label(shell, SWT.NONE);
	updateServerLabel.setVisible(false);
	updateServerLabel.setBounds(10, 488,79, 13);
	updateServerLabel.setText("Update Server:");
	//
	
	if(runAutoCheck)
	{
	    checkForLaterVersion(this.getStyledText());	    
	}
    }

    
    public void downloadLatestVersion(StyledText text)
    {
	try
	{
	    checkForLaterVersion(text);
	    //text.redraw();
	    if(text.getText().indexOf("UPDATE REQUIRED")>=0)
	    {
		text.setText(text.getText() + "\r\n!Downloading update from server...\r\n");
		text.redraw();
		
		UpdateDetails d = CheckForUpdates.checkLatestVersion(updateURL.getText());
		CheckForUpdates.downloadUpdate(updateURL.getText());
		text.setText(text.getText() + "Download of Update complete - Press finish to exit AGEMAME Layout Editor and then restart the application.\r\n");
		updated = true;
		this.getCheckAndUpdateButton().setEnabled(false);
		this.getCheckLaterVersion().setEnabled(false);
	    }
	    else
	    {
		text.setText(text.getText() + "\r\n!No update downloaded\r\n");
		updated = false;
	    }
	    
	    StyleRange styleRange1 = new StyleRange();
	    styleRange1.start = 0;
	    styleRange1.length = 34;
	    styleRange1.fontStyle = SWT.BOLD;
	    
	    int start = text.getText().indexOf("*");
	    int end = text.getText().lastIndexOf("*");

	    
	    StyleRange styleRange2 = new StyleRange();
	    
	    if(start>0 && end>0 && end>start)
	    {

	    styleRange2.start = start;
	    styleRange2.length = end-start+1;
	    styleRange2.foreground = shell.getDisplay().getSystemColor(SWT.COLOR_RED);
	    }
	    else
	    {
		end = text.getText().indexOf("!");
		styleRange2.start = start;
		styleRange2.length = end - start;
		styleRange2.foreground = shell.getDisplay().getSystemColor(SWT.COLOR_DARK_GREEN);
	    }
	    
	    
	    
	    text.setStyleRanges(new StyleRange[]{styleRange1,styleRange2});
	    
	    text.redraw();

	}
	catch (Exception e)
	{
	    // TODO Auto-generated catch block
	    e.printStackTrace();

	    text.setText(text.getText() + "Error Contacting Update Server: " + updateURL.getText() + "\n\n" + e.toString());
	    
	    StyleRange styleRange2 = new StyleRange();
	    int start = text.getText().indexOf("Error Contact");
	    styleRange2.start = start;
	    int end = text.getText().length();
	    styleRange2.length = end-start;
	    styleRange2.foreground = shell.getDisplay().getSystemColor(SWT.COLOR_RED);
	    text.setStyleRange(styleRange2);
	    text.redraw();
	}

    }

    public void checkForLaterVersion(StyledText text)
    {
	try
	{
	    text.setEnabled(true);
	    text.setText("AGEMAME Layout Editor Update Check\r\n");
	    text.setText(text.getText() + "Current Version: " + Version.getVersion() + "[" + Version.getNumericVersion() + "] \r\n");
	    text.setText(text.getText() + "Contacting Update Server [" + updateURL.getText() + "]... \r\n");
	    text.redraw();
	    UpdateDetails d = CheckForUpdates.checkLatestVersion(updateURL.getText());
	    text.setText(text.getText() + "Version on update server: " + d.getVersion() + "\r\n\r\n");

	    boolean isUptoDate = CheckForUpdates.isVersionUptoDate(d);

	    if (!isUptoDate)
	    {
		text.setText(text.getText() + "*****************************************\r\n");
		text.setText(text.getText() + "AGEMAME Layout Editor UPDATE REQUIRED!\r\n");
		text.setText(text.getText() + "*****************************************\r\n");
	    }
	    else
	    {
		text.setText(text.getText() + "*AGEMAME Layout Editor is the latest version.  Update NOT required.\r\n");
	    }
	    
	    StyleRange styleRange1 = new StyleRange();
	    styleRange1.start = 0;
	    styleRange1.length = 34;
	    styleRange1.fontStyle = SWT.BOLD;
	    
	    int start = text.getText().indexOf("*");
	    int end = text.getText().lastIndexOf("*");

	    
	    StyleRange styleRange2 = new StyleRange();
	    
	    if(start>0 && end>0 && end>start)
	    {

	    styleRange2.start = start;
	    styleRange2.length = end-start+1;
	    styleRange2.foreground = shell.getDisplay().getSystemColor(SWT.COLOR_RED);
	    }
	    else
	    {
		end = text.getText().length();
		styleRange2.start = start;
		styleRange2.length = end - start;
		styleRange2.foreground = shell.getDisplay().getSystemColor(SWT.COLOR_DARK_GREEN);
	    }
	    
	    
	    
	    text.setStyleRanges(new StyleRange[]{styleRange1,styleRange2});
	    text.redraw();

	    this.getCheckLaterVersion().setEnabled(false);
	}
	catch (IOException e)
	{
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	    text.setText(text.getText() + "Error Contacting Update Server: " + updateURL.getText() + "\n\n" + e.toString());
	    
	    StyleRange styleRange2 = new StyleRange();
	    int start = text.getText().indexOf("Error Contact");
	    styleRange2.start = start;
	    int end = text.getText().length();
	    styleRange2.length = end-start;
	    styleRange2.foreground = shell.getDisplay().getSystemColor(SWT.COLOR_RED);
	    text.setStyleRange(styleRange2);
	}

    }
    

    public Text getUpdateURL()
    {
	return updateURL;
    }

    public Button getFinishButton()
    {
	return finishButton;
    }

    public Button getCancelButton()
    {
	return cancelButton;
    }

    public Button getCheckAndUpdateButton()
    {
	return checkAndUpdateButton;
    }

    public Button getCheckLaterVersion()
    {
	return checkLaterVersion;
    }
	public StyledText getStyledText()
	{
		return styledText;
	}

}
