package uk.co.pembo.agemame.userinterface;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import uk.co.pembo.agemame.info.Version;

public class AboutDialog extends Dialog
{

    private Label versionLabel;
    private StyledText aboutDialogText;
    protected Object result;
    protected Shell shell;

    /**
     * Create the dialog
     * @param parent
     * @param style
     */
    public AboutDialog(Shell parent, int style)
    {
	super(parent, style);
    }

    /**
     * Create the dialog
     * @param parent
     */
    public AboutDialog(Shell parent)
    {
	this(parent, SWT.NONE);
    }

    /**
     * Open the dialog
     * @return the result
     */
    public Object open()
    {
	createContents();
	shell.open();
	shell.layout();
	Display display = getParent().getDisplay();
	while (!shell.isDisposed())
	{
	    if (!display.readAndDispatch()) display.sleep();
	}
	return result;
    }

    /**
     * Create contents of the dialog
     */
    protected void createContents()
    {
	shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	shell.setSize(506, 309);
	
	int guessWidth = 506;
	int guessHeigh = 309;
	
	shell.setLocation((this.getParent().getSize().x - guessWidth) / 2,
(this.getParent().getSize().y - guessHeigh) / 2);

	
	shell.setText("About AGEMAME Layout Editor");

	final Canvas canvas = new Canvas(shell, SWT.NONE);
	canvas.setBounds(0, 0, 115, 164);
	canvas.setBackgroundImage(SWTResourceManager.getImage(Version.getPathToImages() + "dialogs/AboutImage.gif"));
	final Composite composite = new Composite(shell, SWT.BORDER | SWT.EMBEDDED);
	composite.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	composite.setBounds(0, 0, 500, 166);

	final Label agemameLayoutEditorLabel = new Label(composite, SWT.SHADOW_NONE);
	agemameLayoutEditorLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	agemameLayoutEditorLabel.setText("AGEMAME Layout Editor");
	agemameLayoutEditorLabel.setBounds(120, 5, 130, 13);

	versionLabel = new Label(composite, SWT.SHADOW_NONE);
	versionLabel.setBounds(120, 30, 330, 13);
	versionLabel.setBackground(SWTResourceManager.getColor(255, 255, 255));
	versionLabel.setText("Version: " + Version.getVersion());

	final Label copyrLabel_1 = new Label(composite, SWT.SHADOW_NONE);
	copyrLabel_1.setBounds(120, 55, 301, 13);
	copyrLabel_1.setBackground(SWTResourceManager.getColor(255, 255, 255));
	copyrLabel_1.setText("(C) Copyright D. Pemberton 2006-2007.  All rights reserved.");

	final Label visitLabel = new Label(composite, SWT.NONE);
	visitLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	visitLabel.setText("Visit");
	visitLabel.setBounds(120, 71, 25, 13);

	final Link eclipseorgLink = new Link(composite, SWT.NONE);
	eclipseorgLink.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	eclipseorgLink.setText("<a href=\"http://agemame.pembo.co.uk\">http://agemame.pembo.co.uk</a>");
	eclipseorgLink.setBounds(145, 71, 159, 13);

	final Label thisProductIncludesLabel = new Label(composite, SWT.NONE);
	thisProductIncludesLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	thisProductIncludesLabel.setText("This product includes software developed by the");
	thisProductIncludesLabel.setBounds(120, 100, 330, 13);

	final Link eclipseorgLink_1 = new Link(composite, SWT.NONE);
	eclipseorgLink_1.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
	eclipseorgLink_1.setText("Apache Software Foundation <a href=\"http://www.apache.org\">http://www.apache.org</a>");
	eclipseorgLink_1.setBounds(120, 113, 301, 13);

	final Link eclipseorgLink_1_1 = new Link(composite, SWT.NONE);
	eclipseorgLink_1_1.setBounds(120, 126, 301, 13);
	eclipseorgLink_1_1.setBackground(SWTResourceManager.getColor(255, 255, 255));
	eclipseorgLink_1_1.setText("Eclipse Foundation <a href=\"http://www.eclipse.org\">http://www.eclipse.org</a>");

	final Button licenceButton = new Button(shell, SWT.NONE);
	licenceButton.addSelectionListener(new SelectionAdapter() {
		public void widgetSelected(SelectionEvent arg0)
		{
			MessageBox messageBox = new MessageBox(shell, SWT.OK | SWT.ICON_INFORMATION);

			String messageText = "";
			messageText += "AGEMAME Layout Editor v" + Version.getVersion() + "\n";
			messageText += "Copyright (c) 2006-2007 by D. Pemberton\n";
			messageText += "Visit http://agemame.pembo.co.uk\n\n";

			messageText += "AGEMAME\nCopyright (C) 2004-2007 by J. Wallace and the AGEMAME Development Team.\n";
			messageText += "Visit http://www.mameworld.net/agemame/ for more information.\n\n";

			messageText += "MAME\n";
			messageText += "Copyright (c) 1997-2005, Nicola Salmoria and the MAME team\n";
			messageText += "All rights reserved.";

			messageBox.setMessage(messageText);
			messageBox.open();		    
		}
	});
	licenceButton.setText("Licence");
	licenceButton.setBounds(271, 244, 115, 23);

	final Button okButton_1 = new Button(shell, SWT.NONE);
	okButton_1.addSelectionListener(new SelectionAdapter() {
		public void widgetSelected(SelectionEvent arg0)
		{
		    shell.close();
		}
	});
	okButton_1.setBounds(392, 244, 98, 23);
	okButton_1.setText("OK");
	//

    }
	
	public String buildAboutText()
	{
	    String aboutText = "";
	    aboutText += "AGEMAME Layout Editor\n\n";
	    aboutText += "Version: " + Version.getVersion();
	    aboutText += "\n\n";
	    aboutText += "(c) Copyright D.Pemberton 2006-2007. All rights reserved\n";
	    return aboutText;
	}
	public StyledText getAboutDialogText()
	{
		return aboutDialogText;
	}
	public Label getVersionLabel()
	{
		return versionLabel;
	}

}
