package uk.co.pembo.agemame.ui;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import uk.co.pembo.agemame.userinterface.GuiMenuHandling;
import uk.co.pembo.agemame.userinterface.RenameFile;
import uk.co.pembo.agemame.userinterface.SWTResourceManager;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.layout.grouplayout.GroupLayout;
import org.eclipse.swt.layout.grouplayout.LayoutStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;


import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.render.HierarchyTreePopulator;
import uk.co.pembo.agemame.userinterface.MainApplication;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.*;
import uk.co.pembo.io.FileUtils;
import uk.co.pembo.util.PersistentSettings;

public class ExplorerTree extends Composite
{

    public static final String[] IMPORT_FILTER_EXTENSIONS = new String[] { "*.png; *.jpg;","*.png"};
    public static final String[] IMPORT_FILTER_NAMES = new String[] {"All Image Files" + " (png)", "PNG Image (*.png)",};
    public String lastpath = null;

    private ToolBar itemsToolbar;
    {
	//Register as a resource user - SWTResourceManager will
	//handle the obtaining and disposing of resources
	SWTResourceManager.registerResourceUser(this);
    }

    private MameLayoutManager mameLayoutManager;
    private DetailsPanel details;
    private GC gc;
    private Canvas preview;
    private Shell mainShell;
    private Composite self;

    private TreeItem lastSelected = null;

    private Tree itemsTree;
    private TreeItem root;
    private Composite parent;
    Menu treeContext;

    private ToolItem bringToFront;
    private ToolItem sendToBack;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private String wholePath = null;

    public ExplorerTree(Composite parent, int style)
    {
	super(parent, style);
	final GridLayout gridLayout = new GridLayout();
	gridLayout.horizontalSpacing = 2;
	gridLayout.verticalSpacing = 2;
	gridLayout.marginWidth = 2;
	gridLayout.marginHeight = 2;
	setLayout(gridLayout);
	setData("newKey", null);
	this.parent = parent;
	initialize();
    }


    void createTreeContextMenu(String type)
    {
	// File menu
	//MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
	//item.setText(bundle.getString("File"));

	System.out.println("MENU TYPE [" + type + "]");

	int orientation = 0;
	orientation |= SWT.LEFT_TO_RIGHT;

	treeContext = new Menu(mainShell, SWT.POP_UP);

	//if(items.length>0 && items[0].getParent().getData().toString().equals("BACKDROPS"))
	//{

	MenuItem item = new MenuItem(treeContext, SWT.PUSH);
	item.setText("Import New Image(s)");
	item.setImage(SWTResourceManager.getImage("icons/toolbar/import.gif"));
	//if (!type.equals("root")) item.setEnabled(false);
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		importFile(wholePath);
	    }
	});

	item = new MenuItem(treeContext, SWT.PUSH);
	item.setText("Refresh File List");
	item.setImage(SWTResourceManager.getImage("icons/toolbar/refresh.gif"));
	//if (!type.equals("root")) item.setEnabled(false);
	//item.setAccelerator(SWT.MOD1 + 'u');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		populateTree(wholePath);
	    }
	});

	new MenuItem(treeContext, SWT.SEPARATOR);

	item = new MenuItem(treeContext, SWT.PUSH);
	item.setText("Rename");
	//item.setImage(SWTResourceManager.getImage("icons/toolbar/refresh.gif"));
	if (type.equals("root")) item.setEnabled(false);
	if (type.toLowerCase().endsWith(".lay")) item.setEnabled(false);
	//item.setAccelerator(SWT.MOD1 + 'u');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		renameFile(wholePath);
	    }
	});	

	item = new MenuItem(treeContext, SWT.PUSH);
	item.setText("Delete");
	item.setImage(SWTResourceManager.getImage("icons/toolbar/delete.gif"));
	if (type.equals("root")) item.setEnabled(false);
	if (type.toLowerCase().endsWith(".lay")) item.setEnabled(false);
	//item.setAccelerator(SWT.MOD1 + 'u');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		deleteFile(wholePath);
	    }
	});		

//	new MenuItem(treeContext, SWT.SEPARATOR);
//
//	item = new MenuItem(treeContext, SWT.PUSH);
//	item.setText("Move down");
//	item.setImage(SWTResourceManager.getImage("icons/moveDown.gif"));
//	if (!type.equals("BACKDROPS")) item.setEnabled(false);
//	//item.setAccelerator(SWT.MOD1 + 'u');
//	item.addSelectionListener(new SelectionAdapter()
//	{
//	    public void widgetSelected(SelectionEvent event)
//	    {
//		//sendBackward();
//	    }
//	});

	new MenuItem(treeContext, SWT.SEPARATOR);
    }

    /**
     * Set up the composite area
     *
     */
    private void initialize()
    {

	{

	    itemsToolbar = new ToolBar(this, SWT.NONE);
	    itemsToolbar.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
	    itemsToolbar.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, 22);

//	    bringToFront = new ToolItem(itemsToolbar, SWT.NONE);
//	    bringToFront.setToolTipText("Bring To Front");
//	    bringToFront.setImage(SWTResourceManager.getImage("icons/toolbar/bringToFront.gif"));

//	    sendToBack = new ToolItem(itemsToolbar, SWT.NONE);
//	    sendToBack.setToolTipText("Send To Back");
//	    sendToBack.setImage(SWTResourceManager.getImage("icons/toolbar/sendToBack.gif"));

//	    moveUpItem = new ToolItem(itemsToolbar, SWT.NONE);
//	    moveUpItem.setToolTipText("Bring Forward");
//	    moveUpItem.setImage(SWTResourceManager.getImage("icons/toolbar/bringForward.gif"));

//	    moveDownItem = new ToolItem(itemsToolbar, SWT.NONE);
//	    moveDownItem.setToolTipText("Send Backward");
//	    moveDownItem.setImage(SWTResourceManager.getImage("icons/toolbar/sendBackward.gif"));

	    //enableToolBarItems(false);

	    itemsTree = new Tree(this, SWT.BORDER|SWT.MULTI);
	    
	    itemsTree.setLayoutData(new GridData(GridData.FILL_BOTH));

	    itemsTree.addListener(SWT.DRAG, new Listener()
	    {
		public void handleEvent(Event event)
		{
		    //System.out.println("DRAGGED!");
		}
	    });

	    itemsTree.addListener(SWT.MouseDown, new Listener()
	    {
		public void handleEvent(Event event)
		{
		    //System.out.println("BUTTON!: " + event.button);

		    if (itemsTree.getSelectionCount() > 0)
		    {
			//enableToolBarItems(true);
		    }

		    if (event.button > 1 && itemsTree.getSelectionCount() > 0)
		    {
			System.out.println("Right mouse button");

			//Menu popUpMenu = new Menu(, SWT.POP_UP);
			//contextMenuShell.setMenu(popUpMenu);
			TreeItem[] items = itemsTree.getSelection();
			treeContext = new Menu(items[0].getParent().getShell(), SWT.POP_UP);
			createTreeContextMenu(items[0].getData().toString());
			treeContext.setVisible(true);

		    }

		    if (itemsTree.getSelectionCount() > 0)
		    {

			if (lastSelected != null && !lastSelected.isDisposed() && lastSelected.getData() instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop)
			{
			    Backdrop bd = (Backdrop) lastSelected.getData();
			    //bd.deselect();
			}

			TreeItem[] items = itemsTree.getSelection();
			if (items != null && items.length > 0 && items[0] != lastSelected)
			{

			    Object data = items[0].getData();
			    EditableTableItem[] eti = new EditableTableItem[] {};

			    if (data instanceof java.lang.String)
			    {
				//eti = new EditableTableItem[]{};
			    }
			    else if (data instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop)
			    {
				Backdrop bd = (Backdrop) data;

				//LayoutRenderer.markAsSelected(bd);

				if (preview != null) preview.redraw();

				eti = new EditableTableItem[6];

				eti[0] = new EditableTableItem("Name", bd.getName());

				String stateStr = "";
				if(bd!=null && bd.getState()!=null)
				{
				    stateStr = bd.getState().toString();
				}

				eti[1] = new EditableTableItem("State", stateStr);

				String x = "";
				String y = "";
				String width = "";
				String height = "";

				//Only deals with X,Y,Width,Height - need to convet top/bot/left/right
				if (bd.getBounds() != null)
				{
				    x = bd.getBounds().getX();
				    y = bd.getBounds().getY();
				    width = bd.getBounds().getWidth();
				    height = bd.getBounds().getHeight();
				}

				eti[2] = new EditableTableItem("X", x);
				eti[3] = new EditableTableItem("Y", y);
				eti[4] = new EditableTableItem("Width", width);
				eti[5] = new EditableTableItem("Height", height);
			    }
			    else if (data instanceof Image)
			    {
				Image img = (Image) data;
				img.getAlphafile();
				img.getFile();
				img.getState();

				eti = new EditableTableItem[3];
				if(img!=null && img.getState()!=null)
				{
				    eti[0] = new EditableTableItem("State",(img.getState().toString()));
				}
				else
				{
				    eti[0] = new EditableTableItem("State","");    
				}
				eti[1] = new EditableTableItem("Filename", img.getFile());
				eti[2] = new EditableTableItem("Alpha File", img.getAlphafile());

			    }
			    else if (data instanceof Element)
			    {
				Element elem = (Element) data;
				eti = new EditableTableItem[2];
				eti[0] = new EditableTableItem("Name", elem.getName());
				if(elem.getDefstate()!=null)
				{
				    eti[1] = new EditableTableItem("Default State", elem.getDefstate().toString());
				}
				else
				{
				    eti[1] = new EditableTableItem("Default State", "");    
				}

			    }

			    else if (data instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.Screen)
			    {
				Screen screen = (Screen) data;
				eti = new EditableTableItem[5];

				eti[0] = new EditableTableItem("Index", screen.getIndex().toString());

				String x = "";
				String y = "";
				String width = "";
				String height = "";

				//Only deals with X,Y,Width,Height - need to convet top/bot/left/right
				if (screen.getBounds() != null)
				{
				    x = screen.getBounds().getX();
				    y = screen.getBounds().getY();
				    width = screen.getBounds().getWidth();
				    height = screen.getBounds().getHeight();
				}

				eti[1] = new EditableTableItem("X", x);
				eti[2] = new EditableTableItem("Y", y);
				eti[3] = new EditableTableItem("Width", width);
				eti[4] = new EditableTableItem("Height", height);

			    }

			    else if (data instanceof Mamelayout)
			    {
				Mamelayout lay = (Mamelayout) data;
				eti = new EditableTableItem[1];
				eti[0] = new EditableTableItem("Version", lay.getVersion().toString());
			    }

			    else if (data instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.View)
			    {
				View view = (View) data;
				eti = new EditableTableItem[1];
				eti[0] = new EditableTableItem("Name", view.getName());
			    }
			    else
			    {
				eti = new EditableTableItem[]{};
			    }


			    if (details != null)
			    {
				if (eti.length > 0)
				{
				    details.setContent(eti, data);
				}
				details.setDataObject(data);
				details.redraw();
			    }

			    lastSelected = items[0];

			    //System.out.println(items[0].getData());
			    //System.out.println(items[0].getText());
			}
		    }

		}
	    });
	}

	Transfer[] types = new Transfer[] { TextTransfer.getInstance() };
	int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_LINK;
	final DragSource source = new DragSource(itemsTree, operations);
	source.setTransfer(types);
	final TreeItem[] dragSourceItem = new TreeItem[1];

	final Object draggedItem;

	source.addDragListener(new DragSourceListener()
	{
	    public void dragStart(DragSourceEvent event)
	    {
		TreeItem[] selection = itemsTree.getSelection();
		if (selection.length > 0 && selection[0].getItemCount() == 0)
		{
		    event.doit = true;
		    dragSourceItem[0] = selection[0];
//		    dragSourceItem = new TreeItem[itemsTree.getSelectionCount()];
//		    for(int i=0;i<itemsTree.getSelectionCount();i++)
//		    {
//			dragSourceItem[i] = itemsTree.getSelection()[i];
//		    }
		}
		else
		{
		    event.doit = false;
		}
	    };

	    public void dragSetData(DragSourceEvent event)
	    {
		//String text = "<!NON-DRAGGABLE!>";

		//if (dragSourceItem[0].getData() instanceof Backdrop)
		//{
		//text = ((Backdrop) dragSourceItem[0].getData()).getId();
		//}
		// event.data = dragSourceItem[0].getText();
		
		String dragData = "<DRAG-FROM-EXPLORER-TREE>";
		TreeItem[] selection = itemsTree.getSelection();
		
		for(int i=0;i<selection.length;i++)
		{
		    
		String value = selection[i].getData().toString();
		dragData += value ;
		if(i<selection.length-1)dragData +="*";
		
		}
		
		
		event.data = dragData;
	    }

	    public void dragFinished(DragSourceEvent event)
	    {
		//if (event.detail == DND.DROP_MOVE)
		//dragSourceItem[0].dispose();
		//dragSourceItem[0] = null;
		//System.out.println("do nothing!");

	    }
	});

	DropTarget target = new DropTarget(itemsTree, operations);
	target.setTransfer(types);
	target.addDropListener(new DropTargetAdapter()
	{
	    public void dragOver(DropTargetEvent event)
	    {
//		event.feedback = DND.FEEDBACK_EXPAND | DND.FEEDBACK_SCROLL;
//		if (event.item != null)
//		{
//		TreeItem item = (TreeItem) event.item;
//		TreeItem parent = item.getParentItem();

//		Point pt = LayoutRenderer.display.map(null, itemsTree, event.x, event.y);
//		Rectangle bounds = item.getBounds();
//		if (pt.y < bounds.y + bounds.height / 2)
//		{
//		event.feedback |= DND.FEEDBACK_INSERT_BEFORE;
//		}
//		else if (pt.y > bounds.y + 2 * bounds.height / 2)
//		{
//		event.feedback |= DND.FEEDBACK_INSERT_AFTER;
//		}
//		else
//		{
//		event.feedback |= DND.FEEDBACK_SELECT;
//		}

//		if (parent != null && !parent.getData().equals("BACKDROPS"))
//		{
//		event.feedback = DND.FEEDBACK_NONE;

//		}
//		}
	    }

	    public void drop(DropTargetEvent event)
	    {
//		if (event.data == null)
//		{
//		event.detail = DND.DROP_NONE;
//		return;
//		}
//		String text = (String) event.data;

//		if (event.item == null)
//		{
//		TreeItem item = new TreeItem(itemsTree, SWT.NONE);
//		item.setData(event.data);

//		System.out.println("text is:" + text);
//		}
//		else
//		{
//		TreeItem item = (TreeItem) event.item;
//		Point pt = LayoutRenderer.display.map(null, itemsTree, event.x, event.y);
//		Rectangle bounds = item.getBounds();
//		TreeItem parent = item.getParentItem();
//		if (parent != null)
//		{
//		TreeItem[] items = parent.getItems();
//		int index = 0;
//		for (int i = 0; i < items.length; i++)
//		{
//		if (items[i] == item)
//		{
//		index = i;
//		break;
//		}
//		}
//		String id = items[index].getText();
//		if (text.equals("<!NON-DRAGGABLE!>") || parent.getData().toString() != "BACKDROPS")
//		{
//		return;
//		}
//		else
//		{
//		Backdrop b = (Backdrop) items[index].getData();
//		id = b.getId();
//		}
//		//System.out.println("INSERTING: " + text + " BEFORE: " + id);

//		Backdrop b = LayoutRenderer.getLayout().getView().getBackdrop(text);
//		int remIndex = LayoutRenderer.getLayout().getView().getBackdropIndex(text);
//		LayoutRenderer.getLayout().getView().removeBackdrop(remIndex);
//		int insIndex = LayoutRenderer.getLayout().getView().getBackdropIndex(id);
//		LayoutRenderer.getLayout().getView().insertBackdrop(b, insIndex);

//		}
//		reorgBackdropsTree();

//		//initialize();
//		if (preview != null) preview.redraw();
//		if (self != null) self.redraw();

//		}
	    }
	});

    }

    public Tree getItemsTree()
    {
	return itemsTree;
    }

    public TreeItem getMameLayout()
    {
	return root;
    }

    public void registerSelf(Composite panel)
    {
	this.self = panel;
    }

    public void registerDetailsPanel(DetailsPanel panel)
    {
	this.details = panel;
    }

    public void registerCanvas(Canvas preview)
    {
	this.preview = preview;
    }

    public void registerShell(Shell shell)
    {
	this.mainShell = shell;
    }

    public void registerGC(GC gc)
    {
	this.gc = gc;
    }

    public void registerLayoutManager(MameLayoutManager mameLayoutManager)
    {
	this.mameLayoutManager = mameLayoutManager;
    }

    public void registerDependencies(MameLayoutManager mameLayoutManager,GC gc,Shell shell,Canvas previewCanvas,DetailsPanel details,Composite self)
    {
	this.registerLayoutManager(mameLayoutManager);
	this.registerGC(gc);
	this.registerCanvas(previewCanvas);
	this.registerDetailsPanel(details);
	this.registerSelf(self);
	this.registerShell(shell);
    }

    public void empty()
    {
	if (itemsTree != null) itemsTree.removeAll();
    }


    public void populateTree(String path)
    {
	//HierarchyTreePopulator treePop = new HierarchyTreePopulator(itemsTree,mameLayoutManager);
	//treePop.createNodes();
	wholePath = path;
	empty();

	//drop filename
	path = path.substring(0,path.lastIndexOf(PersistentSettings.FILE_SEPARATOR));
	String fullPath = path;

	path = path.substring(path.lastIndexOf(PersistentSettings.FILE_SEPARATOR)+1);


	//System.out.println("POPULATING ROOT!");
	root = new TreeItem(itemsTree, SWT.NONE);
	root.setText(path);
	root.setData("root");
	root.setImage(SWTResourceManager.getImage("icons/file/folder.png"));

	listDirectory(fullPath);
    }

    /**
     * This method uses the list() method to get all entries in a directory
     * and then displays them in the List component. 
     **/
    public void listDirectory(String directory) {
	// Convert the string to a File object, and check that the dir exists
	File dir = new File(directory);
	if (!dir.isDirectory()) 
	    throw new IllegalArgumentException("FileLister: no such directory");

	// Get the (filtered) directory entries
	String[] files = dir.list();        

	// Sort the list of filenames.
	java.util.Arrays.sort(files);

	// Remove any old entries in the list, and add the new ones
	//for(int i = 0; i < files.length; i++) list.add(files[i]);

	// Display directory name in window titlebar and in the details box

	for(int i=0;i<files.length;i++)
	{

	    TreeItem file = new TreeItem(root, SWT.NONE);
	    file.setText(files[i]);
	    file.setData(directory + PersistentSettings.FILE_SEPARATOR + files[i]);

	    String ext = files[i].toUpperCase();
	    ext = ext.substring(ext.length()-3);

	    if(ext.endsWith("PNG"))file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
	    else if(ext.endsWith("GIF"))file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
	    else if(ext.endsWith("JPG"))file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
	    else if(ext.endsWith("BMP"))file.setImage(SWTResourceManager.getImage("icons/file/image.png"));
	    else if(ext.endsWith("LAY"))file.setImage(SWTResourceManager.getImage("icons/file/lay.png"));
	    else file.setImage(SWTResourceManager.getImage("icons/file/file.png")); 


	}
	root.setExpanded(true);
    }


    /**
     * @return the lastSelected
     */
    public TreeItem getLastSelected()
    {
	return lastSelected;
    }


    public void importFile(String fullPath)
    {
	//Drop the layout file

	//String path = fullPath.substring(0,fullPath.lastIndexOf(PersistentSettings.FILE_SEPARATOR));
	String path = FileUtils.getPathOnlyFromFullFilename(fullPath);
	String filename = "";
	FileDialog fileChooser = null;
	if (fullPath != null)
	{
	    // Get the user to choose an image file.
	    fileChooser = new FileDialog(this.mainShell, SWT.MULTI);
	    if(lastpath!=null) fileChooser.setFilterPath(lastpath);
	    else fileChooser.setFilterPath(path);
	    fileChooser.setFilterExtensions(IMPORT_FILTER_EXTENSIONS);
	    fileChooser.setFilterNames(IMPORT_FILTER_NAMES);
	    filename = fileChooser.open();
	    lastpath = fileChooser.getFilterPath();
	}

	String[] files = fileChooser.getFileNames();

	System.out.println(">>NO FILES: " + files.length);
	if(files==null || files.length<=0)return;




	String filenameOnly = "";
	String copyFrom = "";
	String copyTo = "";
	for (int i = 0, n = files.length; i < n; i++) 
	{

	    filenameOnly = FileUtils.getFilenameOnlyFromFullFilename(files[i]);
	    copyFrom = lastpath + PersistentSettings.FILE_SEPARATOR + files[i];
	    copyTo = path + filenameOnly;

	    File copyToFile = new File(copyTo);
	    if(!copyToFile.exists())
	    {
		System.out.println(">>copyFrom    : " + copyFrom);
		System.out.println(">>copyTO    : " + copyTo);
		try
		{
		    FileUtils.copyFile(lastpath + PersistentSettings.FILE_SEPARATOR + files[i], path + filenameOnly);
		}
		catch(Exception e)
		{
		    e.printStackTrace();

		}
	    }
	    else
	    {
		MessageBox messageBox = new MessageBox(mainShell, SWT.ICON_ERROR | SWT.OK);
		messageBox.setMessage("File: " + copyTo + " already exists in the project");
		messageBox.setText("Error");
		messageBox.open();
	    }
	}


	populateTree(wholePath);
    }

    public void renameFile(String fullPath)
    {
	TreeItem[] items = itemsTree.getSelection();
	if (items.length > 0)
	{
	    TreeItem item = items[0];
//	    System.out.println(">>>>>>" + item.getData());
	    String fileName = FileUtils.getFilenameOnlyFromFullFilename(item.getData().toString());
	    String path = FileUtils.getPathOnlyFromFullFilename(item.getData().toString());

	    //InputDialog dlg = new InputDialog(this.getShell(),"Rename File","Please enter the new filename",fileName,null);
	    //int input = dlg.open();

	    RenameFile dlg = new RenameFile(mainShell);
	    String value = dlg.open(fileName);
	    //System.out.println("------------------- RES: " + res);


	    //value = null;
	    if (value != null && value.length()>0 && value!=fileName) 
	    {
		try
		{
		    FileUtils.rename(item.getData().toString(), path + value);
		}
		catch (Exception e)
		{
		    MessageBox messageBox = new MessageBox(mainShell, SWT.ICON_ERROR | SWT.OK);
		    messageBox.setMessage("Unable to rename file: " + item.getData().toString() + "\n\nReason\n" + e.getMessage());
		    messageBox.setText("Error");
		    messageBox.open();
		}		         
	    }

	}
	populateTree(wholePath);
    }

    public void deleteFile(String fullPath)
    {
	TreeItem[] items = itemsTree.getSelection();
	if (items.length > 0)
	{
	    TreeItem item = items[0];
	    String fileName = item.getData().toString();

	    try
	    {
		
		MessageBox messageBox = new MessageBox(mainShell, SWT.ICON_QUESTION | SWT.OK | SWT.CANCEL);
		messageBox.setMessage("Are you sure you want to delete the file: " + fileName + "?");
		messageBox.setText("Confirmation?");
		int ret = messageBox.open();
		if(ret == SWT.OK)
		{
		    FileUtils.delete(fileName);
		}
	    }
	    catch (Exception e)
	    {
		MessageBox messageBox = new MessageBox(mainShell, SWT.ICON_ERROR | SWT.OK);
		messageBox.setMessage("Unable to delete file: " + item.getData().toString() + "\n\nReason\n" + e.getMessage());
		messageBox.setText("Error");
		messageBox.open();
	    }	    
	}
	populateTree(wholePath);
    }
}
