/**
 * 
 */
package uk.co.pembo.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import uk.co.pembo.util.PersistentSettings;

/**
 * @author Dave
 *
 */
public class FileUtils
{

    /**
     * Copys a file from the source to the destination.
     * @param source must be a full path to a file, including file name
     * @param dest must be a full path to a file, including file name
     * @throws IOException
     */
    public static void copyFile(String source, String dest) throws IOException
    {
	File inputFile = new File(source);
	File outputFile = new File(dest);

	FileInputStream in = new FileInputStream(inputFile);
	FileOutputStream out = new FileOutputStream(outputFile);
	int c;

	while ((c = in.read()) != -1)
	    out.write(c);

	in.close();
	out.close();
    }

    /**
     * Gets the path only from a full file path + name
     * @param filename
     * @return
     */
    public static String getPathOnlyFromFullFilename(String filename)
    {
	return filename.substring(0, filename.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
    }

    /**
     * Gets just the filename from a full file path + name
     * @param filename
     * @return
     */
    public static String getFilenameOnlyFromFullFilename(String filename)
    {
	return filename.substring(filename.lastIndexOf(PersistentSettings.FILE_SEPARATOR) + 1);
    }


    /**
     * Renames the file from file to newName
     * @param file
     * @param newName
     * @throws IOException
     */
    public static void rename(String file, String newName) throws IOException
    {

	// Construct the file object. Does NOT create a file on disk!
	File f = new File(file);

	String path = f.getAbsolutePath();
	if (newName.indexOf(PersistentSettings.FILE_SEPARATOR) < 0)
	{
	    newName = path + newName;
	}
	// Renaming requires a File object for the target.
	f.renameTo(new File(newName));
    }

    /**
     * Deletes the given file
     * @param file
     * @throws IOException
     */
    public static void delete(String file) throws IOException
    {
	File f = new File(file);
	f.delete();
    }
    
    /**
     * Write a text string to the specified file.
     * @param str
     * @param filename
     * @throws IOException
     */
    public static void writeStringToFile(String str, String filename)
    throws IOException
    {
	java.io.FileWriter outFile = new java.io.FileWriter(filename);
	PrintWriter out = new PrintWriter(outFile);
	out.print(str);
	out.flush();
	out.close();
    }    
}
