package uk.co.pembo.agemame.ui;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.layout.grouplayout.GroupLayout;
import org.eclipse.swt.layout.grouplayout.LayoutStyle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;


import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.agemame.render.HierarchyTreePopulator;
import uk.co.pembo.agemame.userinterface.MainApplication;
import uk.co.pembo.agemame.xmlbinding.DragAndDropController;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.*;

public class ItemsTree extends Composite
{

    private ToolBar itemsToolbar;
    {
	//Register as a resource user - SWTResourceManager will
	//handle the obtaining and disposing of resources
	SWTResourceManager.registerResourceUser(this);
    }

    private MameLayoutManager mameLayoutManager;
    private DetailsPanel details;
    private GC gc;
    private Canvas preview;
    private Shell mainShell;
    private Composite self;

    private TreeItem lastSelected = null;

    private Tree itemsTree;
    private TreeItem MameLayout;
    private TreeItem backdropsTreeItem;
    private TreeItem bezelsTreeItem;
    private TreeItem screenTreeItem;
    private TreeItem viewsTreeItem;
    private TreeItem viewTreeItem;
    private TreeItem elements;
    private Composite parent;
    Menu treeContext;

    private ToolItem bringToFront;
    private ToolItem sendToBack;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;

    public ItemsTree(Composite parent, int style)
    {
	super(parent, style);
	final GridLayout gridLayout = new GridLayout();
	gridLayout.horizontalSpacing = 2;
	gridLayout.verticalSpacing = 2;
	gridLayout.marginWidth = 2;
	gridLayout.marginHeight = 2;
	setLayout(gridLayout);
	setData("newKey", null);
	this.parent = parent;
	initialize();
    }

    private void bringForward()
    {
	TreeItem[] items = itemsTree.getSelection();
	System.out.println("MOVE UP!");
	if (items.length > 0)
	{
//	    System.out.println("Reacting on: " + items[0].getText());
//	    Backdrop bd = (Backdrop) items[0].getData();
//	    int pos = LayoutRenderer.getLayout().getView().getBackdropIndex(bdgetId());
//	    if (pos > 0)
//	    {
//		LayoutRenderer.getLayout().getView().removeBackdrop(pos);
//		LayoutRenderer.getLayout().getView().insertBackdrop(bd, pos - 1);
//		reorgBackdropsTree();
//	    }
	}
    }

    private void sendBackward()
    {
	TreeItem[] items = itemsTree.getSelection();
	System.out.println("MOVE DOWN!");
	if (items.length > 0)
	{
//	    System.out.println("Reacting on: " + items[0].getText());
//	    Backdrop bd = (Backdrop) items[0].getData();
//	    int pos = LayoutRenderer.getLayout().getView().getBackdropIndex(bd.getId());
//	    if (pos < LayoutRenderer.getLayout().getView().getBackdropsCount() - 1)
//	    {
//		LayoutRenderer.getLayout().getView().removeBackdrop(pos);
//		LayoutRenderer.getLayout().getView().insertBackdrop(bd, pos + 1);
//		reorgBackdropsTree();
//	    }
	}
    }

    void createTreeContextMenu(String type)
    {
	// File menu
	//MenuItem item = new MenuItem(menuBar, SWT.CASCADE);
	//item.setText(bundle.getString("File"));

	System.out.println("MENU TYPE [" + type + "]");

	int orientation = 0;
	orientation |= SWT.LEFT_TO_RIGHT;

	treeContext = new Menu(mainShell, SWT.POP_UP);

	//if(items.length>0 && items[0].getParent().getData().toString().equals("BACKDROPS"))
	//{
	MenuItem item = new MenuItem(treeContext, SWT.PUSH);
	item.setText("Move up");
	item.setImage(SWTResourceManager.getImage("icons/moveUp.gif"));
	if (!type.equals("BACKDROPS")) item.setEnabled(false);
	//item.setAccelerator(SWT.MOD1 + 'u');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		bringForward();
	    }
	});

	item = new MenuItem(treeContext, SWT.PUSH);
	item.setText("Move down");
	item.setImage(SWTResourceManager.getImage("icons/moveDown.gif"));
	if (!type.equals("BACKDROPS")) item.setEnabled(false);
	//item.setAccelerator(SWT.MOD1 + 'u');
	item.addSelectionListener(new SelectionAdapter()
	{
	    public void widgetSelected(SelectionEvent event)
	    {
		sendBackward();
	    }
	});

	new MenuItem(treeContext, SWT.SEPARATOR);
    }

    /**
     * Switch the toolbar items from enabled to disabled
     * and vice-versa.
     */
    private void enableToolBarItems()
    {
	boolean enabled = true;
	if (bringToFront.getEnabled())
	{
	    enabled = false;
	}
	enableToolBarItems(enabled);
    }

    /**
     * Switch the toolbar items based on the passed in parameter
     * @param enabled
     */
    private void enableToolBarItems(boolean enabled)
    {
	bringToFront.setEnabled(enabled);
	sendToBack.setEnabled(enabled);
	moveUpItem.setEnabled(enabled);
	moveDownItem.setEnabled(enabled);
    }

    /**
     * Set up the composite area
     *
     */
    private void initialize()
    {

	{

	    itemsToolbar = new ToolBar(this, SWT.NONE);
	    itemsToolbar.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
	    itemsToolbar.setBounds(this.getBounds().x, this.getBounds().y, this.getBounds().width, 22);

	    bringToFront = new ToolItem(itemsToolbar, SWT.NONE);
	    bringToFront.setToolTipText("Bring To Front");
	    bringToFront.setImage(SWTResourceManager.getImage("icons/toolbar/bringToFront.gif"));

	    sendToBack = new ToolItem(itemsToolbar, SWT.NONE);
	    sendToBack.setToolTipText("Send To Back");
	    sendToBack.setImage(SWTResourceManager.getImage("icons/toolbar/sendToBack.gif"));

	    moveUpItem = new ToolItem(itemsToolbar, SWT.NONE);
	    moveUpItem.setToolTipText("Bring Forward");
	    moveUpItem.setImage(SWTResourceManager.getImage("icons/toolbar/bringForward.gif"));

	    moveDownItem = new ToolItem(itemsToolbar, SWT.NONE);
	    moveDownItem.setToolTipText("Send Backward");
	    moveDownItem.setImage(SWTResourceManager.getImage("icons/toolbar/sendBackward.gif"));

	    enableToolBarItems(false);

	    itemsTree = new Tree(this, SWT.BORDER);
	    itemsTree.setLayoutData(new GridData(GridData.FILL_BOTH));

	    itemsTree.addListener(SWT.DRAG, new Listener()
	    {
		public void handleEvent(Event event)
		{
		    //System.out.println("DRAGGED!");
		}
	    });

	    itemsTree.addListener(SWT.MouseDown, new Listener()
	    {
		public void handleEvent(Event event)
		{
		    //System.out.println("BUTTON!: " + event.button);

		    if (itemsTree.getSelectionCount() > 0)
		    {
			enableToolBarItems(true);
		    }

		    if (event.button > 1 && itemsTree.getSelectionCount() > 0)
		    {
			System.out.println("Right mouse button");

			//Menu popUpMenu = new Menu(, SWT.POP_UP);
			//contextMenuShell.setMenu(popUpMenu);
			TreeItem[] items = itemsTree.getSelection();
			treeContext = new Menu(items[0].getParent().getShell(), SWT.POP_UP);
			createTreeContextMenu(items[0].getParentItem().getData().toString());
			treeContext.setVisible(true);

		    }

		    if (itemsTree.getSelectionCount() > 0)
		    {

			if (lastSelected != null && !lastSelected.isDisposed() && lastSelected.getData() instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop)
			{
			    Backdrop bd = (Backdrop) lastSelected.getData();
			    //bd.deselect();
			}

			TreeItem[] items = itemsTree.getSelection();
			if (items != null && items.length > 0 && items[0] != lastSelected)
			{

			    Object data = items[0].getData();
			    EditableTableItem[] eti = new EditableTableItem[] {};

			    if (data instanceof java.lang.String)
			    {
				//eti = new EditableTableItem[]{};
			    }
			    else if (data instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop)
			    {
				Backdrop bd = (Backdrop) data;
				
				//LayoutRenderer.markAsSelected(bd);

				if (preview != null) preview.redraw();

				eti = new EditableTableItem[6];

				eti[0] = new EditableTableItem("Name", bd.getName());

				String stateStr = "";
				if(bd!=null && bd.getState()!=null)
				{
				    stateStr = bd.getState().toString();
				}
				
				eti[1] = new EditableTableItem("State", stateStr);

				String x = "";
				String y = "";
				String width = "";
				String height = "";

				//Only deals with X,Y,Width,Height - need to convet top/bot/left/right
				if (bd.getBounds() != null)
				{
				    x = bd.getBounds().getX();
				    y = bd.getBounds().getY();
				    width = bd.getBounds().getWidth();
				    height = bd.getBounds().getHeight();
				}

				eti[2] = new EditableTableItem("X", x);
				eti[3] = new EditableTableItem("Y", y);
				eti[4] = new EditableTableItem("Width", width);
				eti[5] = new EditableTableItem("Height", height);
			    }
			    else if (data instanceof Image)
			    {
				Image img = (Image) data;
				img.getAlphafile();
				img.getFile();
				img.getState();

				eti = new EditableTableItem[3];
				if(img!=null && img.getState()!=null)
				{
				eti[0] = new EditableTableItem("State",(img.getState().toString()));
				}
				else
				{
				    eti[0] = new EditableTableItem("State","");    
				}
				eti[1] = new EditableTableItem("Filename", img.getFile());
				eti[2] = new EditableTableItem("Alpha File", img.getAlphafile());

			    }
			    else if (data instanceof Element)
			    {
				Element elem = (Element) data;
				eti = new EditableTableItem[2];
				eti[0] = new EditableTableItem("Name", elem.getName());
				if(elem.getDefstate()!=null)
				{
				eti[1] = new EditableTableItem("Default State", elem.getDefstate().toString());
				}
				else
				{
				    eti[1] = new EditableTableItem("Default State", "");    
				}

			    }

			    else if (data instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.Screen)
			    {
				Screen screen = (Screen) data;
				eti = new EditableTableItem[5];

				eti[0] = new EditableTableItem("Index", screen.getIndex().toString());

				String x = "";
				String y = "";
				String width = "";
				String height = "";

				//Only deals with X,Y,Width,Height - need to convet top/bot/left/right
				if (screen.getBounds() != null)
				{
				    x = screen.getBounds().getX();
				    y = screen.getBounds().getY();
				    width = screen.getBounds().getWidth();
				    height = screen.getBounds().getHeight();
				}

				eti[1] = new EditableTableItem("X", x);
				eti[2] = new EditableTableItem("Y", y);
				eti[3] = new EditableTableItem("Width", width);
				eti[4] = new EditableTableItem("Height", height);

			    }

			    else if (data instanceof Mamelayout)
			    {
				Mamelayout lay = (Mamelayout) data;
				eti = new EditableTableItem[1];
				eti[0] = new EditableTableItem("Version", lay.getVersion().toString());
			    }

			    else if (data instanceof uk.co.pembo.agemame.xmlbinding.mamelayout.View)
			    {
				View view = (View) data;
				eti = new EditableTableItem[1];
				eti[0] = new EditableTableItem("Name", view.getName());
			    }
			    else
			    {
				eti = new EditableTableItem[]{};
			    }


			    if (details != null)
			    {
				if (eti.length > 0)
				{
				    details.setContent(eti, data);
				}
				details.setDataObject(data);
				details.redraw();
			    }

			    lastSelected = items[0];

			    //System.out.println(items[0].getData());
			    //System.out.println(items[0].getText());
			}
		    }

		}
	    });
	}

	Transfer[] types = new Transfer[] { TextTransfer.getInstance() };
	int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_LINK;
	final DragSource source = new DragSource(itemsTree, operations);
	source.setTransfer(types);
	final TreeItem[] dragSourceItem = new TreeItem[1];

	final Object draggedItem;

	source.addDragListener(new DragSourceListener()
	{
	    public void dragStart(DragSourceEvent event)
	    {
		
		System.out.println("dragStart");
		
		TreeItem[] selection = itemsTree.getSelection();
		if (selection.length > 0 && selection[0].getItemCount() == 0)
		{
		    event.doit = true;
		    dragSourceItem[0] = selection[0];
		}
		else
		{
		    event.doit = false;
		}
	    };

	    public void dragSetData(DragSourceEvent event)
	    {
		System.out.println("DRAG SET DATA");
		String text = "<!NON-DRAGGABLE!>";

		//if (dragSourceItem[0].getData() instanceof Backdrop)
		//{
		    //text = ((Backdrop) dragSourceItem[0].getData()).getId();
		//}
		// event.data = dragSourceItem[0].getText();
		event.data = text;
	    }

	    public void dragFinished(DragSourceEvent event)
	    {
		//if (event.detail == DND.DROP_MOVE)
		//dragSourceItem[0].dispose();
		//dragSourceItem[0] = null;
		System.out.println("DRAG FINISHED!");

		
	    }
	});

	DropTarget target = new DropTarget(itemsTree, operations);
	target.setTransfer(types);
	target.addDropListener(new DropTargetAdapter()
	{
	    public void dragOver(DropTargetEvent event)
	    {
//		event.feedback = DND.FEEDBACK_EXPAND | DND.FEEDBACK_SCROLL;
//		if (event.item != null)
//		{
//		    TreeItem item = (TreeItem) event.item;
//		    TreeItem parent = item.getParentItem();
//
//		    Point pt = LayoutRenderer.display.map(null, itemsTree, event.x, event.y);
//		    Rectangle bounds = item.getBounds();
//		    if (pt.y < bounds.y + bounds.height / 2)
//		    {
//			event.feedback |= DND.FEEDBACK_INSERT_BEFORE;
//		    }
//		    else if (pt.y > bounds.y + 2 * bounds.height / 2)
//		    {
//			event.feedback |= DND.FEEDBACK_INSERT_AFTER;
//		    }
//		    else
//		    {
//			event.feedback |= DND.FEEDBACK_SELECT;
//		    }
//
//		    if (parent != null && !parent.getData().equals("BACKDROPS"))
//		    {
//			event.feedback = DND.FEEDBACK_NONE;
//
//		    }
//		}
	    }

	    public void drop(DropTargetEvent event)
	    {
		System.out.println("DROP!");
		DragAndDropController dndController = new DragAndDropController(mameLayoutManager);
		dndController.dragDropEvent(event);
		populateTree();
		
//		if (event.data == null)
//		{
//		    event.detail = DND.DROP_NONE;
//		    return;
//		}
//		String text = (String) event.data;
//		System.out.println(text);
		
		//TreeItem item = (TreeItem) event.item;
		//Point pt = LayoutRenderer.display.map(null, itemsTree, event.x, event.y);
		//Rectangle bounds = item.getBounds();
		//System.out.println("DATA: " + item.getData());
//
//		if(event.item!=null)
//		{
//	    		TreeItem item = (TreeItem) event.item;
//	    		
//	    		//Dropped onto elements node
//	    		if(item.getData().toString().equalsIgnoreCase("<ELEMENTS>") && text.startsWith("<DRAG-FROM-EXPLORER-TREE>"))
//	    		{
//	    		    System.out.println("Files dragged from explorer to elements");
//	    		}
//		}
		
//		if (event.item == null)
//		{
//		    TreeItem item = new TreeItem(itemsTree, SWT.NONE);
//		    item.setData(event.data);
//
//		    System.out.println("text is:" + text);
//		}
//		else
//		{
//		    TreeItem item = (TreeItem) event.item;
//		    Point pt = LayoutRenderer.display.map(null, itemsTree, event.x, event.y);
//		    Rectangle bounds = item.getBounds();
//		    TreeItem parent = item.getParentItem();
//		    if (parent != null)
//		    {
//			TreeItem[] items = parent.getItems();
//			int index = 0;
//			for (int i = 0; i < items.length; i++)
//			{
//			    if (items[i] == item)
//			    {
//				index = i;
//				break;
//			    }
//			}
//			String id = items[index].getText();
//			if (text.equals("<!NON-DRAGGABLE!>") || parent.getData().toString() != "BACKDROPS")
//			{
//			    return;
//			}
//			else
//			{
//			    Backdrop b = (Backdrop) items[index].getData();
//			    id = b.getId();
//			}
//			//System.out.println("INSERTING: " + text + " BEFORE: " + id);
//
//			Backdrop b = LayoutRenderer.getLayout().getView().getBackdrop(text);
//			int remIndex = LayoutRenderer.getLayout().getView().getBackdropIndex(text);
//			LayoutRenderer.getLayout().getView().removeBackdrop(remIndex);
//			int insIndex = LayoutRenderer.getLayout().getView().getBackdropIndex(id);
//			LayoutRenderer.getLayout().getView().insertBackdrop(b, insIndex);
//
//		    }
//		    reorgBackdropsTree();
//
//		    //initialize();
//		    if (preview != null) preview.redraw();
//		    if (self != null) self.redraw();
//
//		}
	    }
	});

    }

    public Tree getItemsTree()
    {
	return itemsTree;
    }

    public TreeItem getMameLayout()
    {
	return MameLayout;
    }

    public TreeItem getElements()
    {
	return elements;
    }

    public TreeItem getViewTreeItem()
    {
	return viewTreeItem;
    }

    public TreeItem getBackdropsTreeItem()
    {
	return backdropsTreeItem;
    }

    public void registerSelf(Composite panel)
    {
	this.self = panel;
    }

    public void registerDetailsPanel(DetailsPanel panel)
    {
	this.details = panel;
    }

    public void registerCanvas(Canvas preview)
    {
	this.preview = preview;
    }

    public void registerShell(Shell shell)
    {
	this.mainShell = shell;
    }

    public void registerGC(GC gc)
    {
	this.gc = gc;
    }
    
    public void registerLayoutManager(MameLayoutManager mameLayoutManager)
    {
	this.mameLayoutManager = mameLayoutManager;
    }
    
    public void registerDependencies(MameLayoutManager mameLayoutManager,GC gc,Shell shell,Canvas previewCanvas,DetailsPanel details,Composite self)
    {
	this.registerLayoutManager(mameLayoutManager);
	this.registerGC(gc);
	this.registerCanvas(previewCanvas);
	this.registerDetailsPanel(details);
	this.registerSelf(self);
	this.registerShell(shell);
    }

    public void empty()
    {
	if (itemsTree != null) itemsTree.removeAll();
    }

    
    public void populateTree()
    {
	empty();
	HierarchyTreePopulator treePop = new HierarchyTreePopulator(itemsTree,mameLayoutManager);
	treePop.createNodes();
    }
    
 
    private void reorgBackdropsTree()
    {
//	for (int i = 0; i < LayoutRenderer.getLayout().getView().getBackdropsCount(); i++)
//	{
//	    Backdrop bd = LayoutRenderer.getLayout().getView().getBackdrop(i);
//	    
//	    int state = bd.getState();
//	    String name = bd.getName();
//
//	    //TreeItem backdrop = new TreeItem(backdropsTreeItem, SWT.NONE);
//	    //backdrop.setImage(SWTResourceManager.getImage("icons/backdrop.gif"));
//
//	    TreeItem backdrop = backdropsTreeItem.getItem(i);
//
//	    backdrop.setText("[" + state + "]" + name);
//	    //backdrop.setData(i + ">" + name);
//	    backdrop.setData(bd);
//
//	}
    }

    /**
     * @return the lastSelected
     */
    public TreeItem getLastSelected()
    {
	return lastSelected;
    }

}
