package uk.co.pembo.agemame.render;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;


import uk.co.pembo.agemame.userinterface.SWTResourceManager;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.View;

public class HierarchyTreePopulator
{
    private MameLayoutManager mameLayoutManager;
    private Tree itemsTree;
    
    
    public HierarchyTreePopulator(Tree itemsTree, MameLayoutManager mameLayoutManager)
    {
	this.itemsTree = itemsTree;
	this.mameLayoutManager = mameLayoutManager;
    }
    /**
     * Takes the tree and populates it with the items required
     * @param itemsTree tree to populate
     */
    public void createNodes()
    {
	TreeItem mameLayout = new TreeItem(itemsTree, SWT.NONE);
	mameLayout.setText("MameLayout");
	mameLayout.setData(mameLayoutManager.getMameLayout());
	mameLayout.setImage(SWTResourceManager.getImage("icons/MameLayout.gif"));
	
        TreeItem elements = new TreeItem(mameLayout, SWT.NONE);
        elements.setText("Elements");
        elements.setData("<ELEMENTS>");
        elements.setImage(SWTResourceManager.getImage("icons/elements.gif"));
	
	createElements(elements);
	createViews(mameLayout);
    }
    
    public void createElements(TreeItem elements)
    {
	//For every element
	List<Element> jaxbElements = mameLayoutManager.getMameLayout().getElement();
	for(int elementCount=0;elementCount<jaxbElements.size();elementCount++)
	{
	    Element jaxbElement = jaxbElements.get(elementCount);
	    
	    String key = jaxbElement.getName();
	    TreeItem element = new TreeItem(elements, SWT.NONE);
	    element.setText(key);
	    element.setData(jaxbElement);
	    element.setImage(SWTResourceManager.getImage("icons/element.gif"));
	    
	    List<uk.co.pembo.agemame.xmlbinding.mamelayout.Image> images = jaxbElement.getImage();
	    List<uk.co.pembo.agemame.xmlbinding.mamelayout.Rect> rects = jaxbElement.getRect();
	    List<uk.co.pembo.agemame.xmlbinding.mamelayout.Disk> disks = jaxbElement.getDisk();
	    List<uk.co.pembo.agemame.xmlbinding.mamelayout.Text> texts = jaxbElement.getText();
	    
	    if (jaxbElement.getLed7Seg() != null)
	    {
		TreeItem image = new TreeItem(element, SWT.NONE);
		image.setText("led7seg");
		image.setImage(SWTResourceManager.getImage("icons/led7seg.gif"));
		//image.setData(key);
		image.setData(jaxbElement.getLed7Seg());
	    }
	    //else
	    //{

		if (jaxbElement.getRect().size() > 0)
		{
		    for (int i = 0; i < rects.size(); i++)
		    {
			String state = rects.get(i).getState();

			TreeItem rect = new TreeItem(element, SWT.NONE);
			rect.setText("[" + state + "]" + "rect");
			rect.setImage(SWTResourceManager.getImage("icons/rect.gif"));
			rect.setData(rects.get(i));
		    }
		}
		
		if (jaxbElement.getDisk().size() > 0)
		{
		    for (int i = 0; i < disks.size(); i++)
		    {
			String state = disks.get(i).getState();

			TreeItem disk = new TreeItem(element, SWT.NONE);
			disk.setText("[" + state + "]" + "disk");
			disk.setImage(SWTResourceManager.getImage("icons/disk.gif"));
			disk.setData(disks.get(i));
		    }
		}		

		if (jaxbElement.getText().size() > 0)
		{
		    for (int i = 0; i < texts.size(); i++)
		    {
			String state = texts.get(i).getState();
			String stringValue = texts.get(i).getString();
			TreeItem text = new TreeItem(element, SWT.NONE);
			text.setText("[" + state + "]" + stringValue);
			text.setImage(SWTResourceManager.getImage("icons/text.gif"));
			text.setData(texts.get(i));
		    }
		}

		if (jaxbElement.getImage().size() > 0)
		{
		    for (int i = 0; i < images.size(); i++)
		    {
			int state = 0;
			if(images.get(i).getState()!=null)
			{
			    state = images.get(i).getState().intValue();
			}
			String file = images.get(i).getFile();

			TreeItem image = new TreeItem(element, SWT.NONE);
			image.setText("[" + state + "]" + file);
			image.setImage(SWTResourceManager.getImage("icons/image.gif"));
			//image.setData(key);
			image.setData(images.get(i));

		    }
		}
	    //}	    
	}
    }
    
    public void createViews(TreeItem mameLayout)
    {
	TreeItem viewsTreeItem = new TreeItem(mameLayout, SWT.NONE);
	viewsTreeItem.setText("Views");
	viewsTreeItem.setData("");
	viewsTreeItem.setImage(SWTResourceManager.getImage("icons/views.gif"));

	//Now populate the views
	List<View> views = mameLayoutManager.getMameLayout().getView();

	for (int i = 0; i < views.size(); i++)
	{
	    View view = views.get(i);
	    TreeItem treeView = new TreeItem(viewsTreeItem, SWT.NONE);
	    treeView.setText(view.getName());
	    treeView.setImage(SWTResourceManager.getImage("icons/view.gif"));
	    treeView.setData(view);

	    //For this view, populate any backdrops/screens
	    //and bezel
	    //same for screen if there is one
	    if(view.getBackdrop().size()>0)
	    {
        	    //Create the backdrops node
        	    TreeItem backdropsTreeItem = new TreeItem(treeView, SWT.NONE);
        	    backdropsTreeItem.setText("Backdrops");
        	    backdropsTreeItem.setData("");
        	    backdropsTreeItem.setImage(SWTResourceManager.getImage("icons/backdrops.gif"));
        	    //Populate the backdrops node
        	    populateBackdropsTree(backdropsTreeItem, view);
	    }
	    
	    if (view.getScreen().size()>0 )
	    {
		
		for (int screenCount = 0; screenCount < view.getScreen().size(); screenCount++)
		{
		    TreeItem screenTreeItem = new TreeItem(treeView, SWT.NONE);
		    screenTreeItem.setText("[ " + view.getScreen().get(screenCount).getIndex().intValue() + "]Screen");
		    screenTreeItem.setData(view.getScreen().get(screenCount));
		    screenTreeItem.setImage(SWTResourceManager.getImage("icons/screen.gif"));
		}
	    }
	    
	    
	    if(view.getBezel().size()>0)
	    {
        	    populateBezelsTree(treeView, view);
	    }
	    
	    if(view.getOverlay().size()>0)
	    {
        	    populateOverlaysTree(treeView, view);
	    }

	    


	}
    }
    
    private void populateOverlaysTree(TreeItem p_backdropsTreeItem, View view)
    {
	for (int i = 0; i < view.getOverlay().size(); i++)
	{
	    uk.co.pembo.agemame.xmlbinding.mamelayout.View.Overlay overlay = view.getOverlay().get(i);
	    //int state = bd.getState();
	    //String name = bd.getName();

	    TreeItem overlaytree = new TreeItem(p_backdropsTreeItem, SWT.NONE);
	    overlaytree.setImage(SWTResourceManager.getImage("icons/overlay.gif"));
	    overlaytree.setText("Overlay");
	    //backdrop.setData(i + ">" + name);
	    overlaytree.setData(overlay);

	}
    }
    
    /**
     * 
     */
    private void populateBezelsTree(TreeItem p_backdropsTreeItem, View view)
    {
	for (int i = 0; i < view.getBezel().size(); i++)
	{
	    uk.co.pembo.agemame.xmlbinding.mamelayout.View.Bezel bd = view.getBezel().get(i);
	    //int state = bd.getState();
	    String name = bd.getName();

	    TreeItem bezel = new TreeItem(p_backdropsTreeItem, SWT.NONE);
	    bezel.setImage(SWTResourceManager.getImage("icons/bezel.gif"));
	    bezel.setText(name);
	    //backdrop.setData(i + ">" + name);
	    bezel.setData(bd);

	}
    }
    
    /**
     * 
     */
    private void populateBackdropsTree(TreeItem p_backdropsTreeItem, View view)
    {
	for (int i = 0; i < view.getBackdrop().size(); i++)
	{
	    uk.co.pembo.agemame.xmlbinding.mamelayout.Backdrop bd = view.getBackdrop().get(i);
	    int state = 0;
	    if(bd.getState()!=null)
	    {
		state = bd.getState().intValue();
	    }
	    String name = bd.getName();

	    TreeItem backdrop = new TreeItem(p_backdropsTreeItem, SWT.NONE);
	    backdrop.setImage(SWTResourceManager.getImage("icons/backdrop.gif"));
	    backdrop.setText("[" + state + "]" + name);
	    //backdrop.setData(i + ">" + name);
	    backdrop.setData(bd);

	}
    }    
}
