package uk.co.pembo.agemame.xmlbinding;

import java.math.BigInteger;

import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;

import uk.co.pembo.agemame.xmlbinding.mamelayout.Element;
import uk.co.pembo.agemame.xmlbinding.mamelayout.Image;
import uk.co.pembo.util.PersistentSettings;

public class DragAndDropController
{

    public static final String ELEMENT_TREE_ITEM = "<ELEMENTS>";
    public static final String DRAG_FROM_EXPLORER_TREE = "<DRAG-FROM-EXPLORER-TREE>";
    public MameLayoutManager mameLayoutManager;
    
    public DragAndDropController(MameLayoutManager mameLayoutManager)
    {
	this.mameLayoutManager = mameLayoutManager;
    }
    
    public void dragDropEvent(DropTargetEvent event)
    {
	//If nothing has been selected to drag (should never happen)
	if(event.item==null)return;
	
	
	TreeItem itemDroppedOn = (TreeItem) event.item;
	String dataDropped = (String) event.data;
	
	checkForDragFromExplorerToElements(itemDroppedOn, dataDropped);
	
	
    }

    /**
     * @param itemDroppedOn
     * @param dataDropped
     */
    private void checkForDragFromExplorerToElements(TreeItem itemDroppedOn, String dataDropped)
    {
	//If the item dropped on has string data to identify it
	if(itemDroppedOn.getData() instanceof java.lang.String)
	{
	    String droppedItemData = itemDroppedOn.getData().toString();
	    
	    //Dropped onto the elements tree
	    if(droppedItemData.equals(ELEMENT_TREE_ITEM) && dataDropped.startsWith(DRAG_FROM_EXPLORER_TREE))
	    {
		//Must be creating elements
		
		String newElementData = dataDropped;
		newElementData = newElementData.substring(DRAG_FROM_EXPLORER_TREE.length());
		//System.out.println("!!!!!!!!!!" + newElementData);
		
		String[] elements = newElementData.split("\\*");
		
		//System.out.println(elements.length);
		
		LayoutChanger changer = mameLayoutManager.getLayoutChanger();
		
		//Create a new element
		for(int i=0;i<elements.length;i++)
		{
		    String fileName = elements[i];
		    //Need just name, so last index of \
		    //and before the .
		    
		    fileName = fileName.substring(fileName.lastIndexOf(PersistentSettings.FILE_SEPARATOR)+1);
		    String name = fileName.substring(0,fileName.indexOf("."));
		    Element elem = changer.newElement(name, new BigInteger("0"));
		    Image image = changer.newImage(fileName, null, new BigInteger("1"));
		    
		    changer.addImageToElement(elem, image);
		    changer.addElement(elem);
		}
	    }
	}
	
	if(itemDroppedOn.getData() instanceof Element)
	{
	    if(dataDropped.startsWith(DRAG_FROM_EXPLORER_TREE))
	    {
		Element elem = (Element)itemDroppedOn.getData();

		String newElementData = dataDropped;
		newElementData = newElementData.substring(DRAG_FROM_EXPLORER_TREE.length());
		
		String[] images = newElementData.split("\\*");
		LayoutChanger changer = mameLayoutManager.getLayoutChanger();
		
		//Create a new element
		for(int i=0;i<images.length;i++)
		{
		    String fileName = images[i];
		    //Need just name, so last index of \
		    //and before the .
		    
		    fileName = fileName.substring(fileName.lastIndexOf(PersistentSettings.FILE_SEPARATOR)+1);
		    //String name = fileName.substring(0,fileName.indexOf("."));
		    //Element elem = changer.newElement(name, new BigInteger("0"));
		    BigInteger lastState = elem.getImage().get(elem.getImage().size()-1).getState();
		    lastState = lastState.add(new BigInteger("1"));
		    Image image = changer.newImage(fileName, null, lastState);
		    changer.addImageToElement(elem, image);
		    
		}

		
	    }

	}
	
    }
    
}
