package uk.co.pembo.agemame.swtrender;

import java.util.logging.Logger;

import org.eclipse.swt.widgets.Text;

import uk.co.pembo.agemame.exception.LayoutParseException;
import uk.co.pembo.agemame.xmlbinding.MameLayoutManager;

public class SourceRenderer
{
    private Text layoutXml;
    private MameLayoutManager mameLayoutManager;
    private static Logger log = Logger.getLogger(SourceRenderer.class.getPackage().getName());
    
    /**
     * Construct Source Renderer
     * Can not create the source renderer without providing
     * an SWT text object to render the source to
     * @param layoutXml SWT Text object to display the source
     * @param mameLayoutManager Used to fetch the layout data
     */
    public SourceRenderer(Text layoutXml,MameLayoutManager mameLayoutManager)
    {
	this.layoutXml = layoutXml;
	this.mameLayoutManager = mameLayoutManager;
	refreshSource();
    }
    
    
    /**
     * Can be used to override the text panel
     * @param textData
     */
    public void registerTextPanel(Text textData)
    {
	layoutXml = textData;
	refreshSource();
    }
    
    /**
     * Does the deed of refreshing the XML source in the display
     * Will only work if the 2 objects are not null
     */
    public void refreshSource()
    {
//	if(layoutXml==null||mameLayoutManager==null)
//	{
//	    throw new NullPointerException("Source Renderer called will null objects");
//	}
	try
	{
	    layoutXml.setText(mameLayoutManager.toXml());
	}
	catch (LayoutParseException e)
	{
	    log.warning("Problem unmarshalling MameLayout Objects");
	    e.printStackTrace();
	}
    }
}
