package uk.co.pembo.agemame.xmlbinding;

import java.math.BigInteger;

import uk.co.pembo.agemame.xmlbinding.mamelayout.*;

/**
 * This class changes the layout based on events from the editor
 * @author Dave
 *
 */

public class LayoutChanger
{

    private MameLayoutManager layoutManager;
    
    public LayoutChanger(MameLayoutManager layoutManager)
    {
	this.layoutManager = layoutManager;
    }
    
    /**
     * Creates and returns a new element object
     * @param name
     * @param defaultState
     * @return
     */
    public Element newElement(String name, BigInteger defaultState)
    {
	Element element = new Element();
	element.setDefstate(defaultState);
	element.setName(name);
	return element;
    }
    
    /**
     * creates and returns a new image object
     * @param file
     * @param alphaFile
     * @param state
     * @return
     */
    public Image newImage(String file,String alphaFile, BigInteger state)
    {
	Image i = new Image();
	i.setAlphafile(alphaFile);
	i.setState(state);
	i.setFile(file);
	return i;
    }
    
    /**
     * Adds an image to a supplied element
     * @param element
     * @param image
     */
    public void addImageToElement(Element element, Image image)
    {
	if(element.getImage()!=null && image !=null)
	{
	    element.getImage().add(image);
	}
    }
    
    public void addElement(Element element)
    {
	layoutManager.getMameLayout().getElement().add(element);
    }
    
}
