/**
 * 
 */
package uk.co.pembo.agemame.updatemanager;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

import uk.co.pembo.agemame.info.Version;
import uk.co.pembo.util.PersistentSettings;

/**
 * @author D. Pemberton
 * Checks for updates from the ALE website
 *
 */
public class CheckForUpdates
{

    private static Logger log = Logger.getLogger(CheckForUpdates.class.getPackage().getName());
    private static String UPDATE_URL_SUFFIX = "check_agemame_version.php";

    private static String simpleHttpGet(String inUrl) throws MalformedURLException, IOException
    {
	URL url = new URL(inUrl);

	InputStream in = url.openStream();
	StringBuffer buf = new StringBuffer();

	// Create a buffered input stream for efficency

	// SAGSIS 262322 - Umlaut problems in workflow processing. Now UTF-8 support added
	BufferedReader br = new BufferedReader(new InputStreamReader(in));
	String tempBuf = null;
	while ((tempBuf = br.readLine()) != null)
	{
	    buf.append(tempBuf);
	}

	return buf.toString();
    }

    public static void GetURL(String urlStr,String filename) throws Exception
    {
	InputStream in = null;
	OutputStream out = null;
	try
	{
	    // Check the arguments
	    //filename = null;

	    // Set up the streams
	    URL url = new URL(urlStr); // Create the URL
	    in = url.openStream(); // Open a stream to it
	    if (filename != null) // Get an appropriate output stream
		out = new FileOutputStream(filename);
	    else
		out = System.out;

	    // Now copy bytes from the URL to the output stream
	    byte[] buffer = new byte[4096];
	    int bytes_read;
	    while ((bytes_read = in.read(buffer)) != -1)
		out.write(buffer, 0, bytes_read);
	}
	// On exceptions, print error message and usage message.
	catch (Exception e)
	{
	    //System.err.println(e);
	    log.log(Level.WARNING, "Error Connecting to update server" );
	    throw e;
	    //System.err.println("Usage: java GetURL <URL> [<filename>]");
	}
	finally
	{ // Always close the streams, no matter what.
	    try
	    {
		in.close();
		out.close();
	    }
	    catch (Exception e)
	    {
	    }
	}
    }

    public static UpdateDetails checkLatestVersion(String updateURL) throws IOException
    {
	if(!updateURL.endsWith("/"))updateURL = updateURL + "/";
	String fullURL = updateURL + UPDATE_URL_SUFFIX;
	UpdateDetails details = getDetails(fullURL);
	return details;
    }
    
    public static void downloadUpdate(String updateURL) throws Exception
    {
	UpdateDetails d = checkLatestVersion(updateURL);
	if(!isVersionUptoDate(d))
	{
	    if(!updateURL.endsWith("/"))updateURL = updateURL + "/";
	    
	    String savLoc = PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION");
	    GetURL(updateURL +"ALE" + d.getVersion() + ".jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "UPDATE_ALE.jar");
	    
	    
	    //Do the jaxb jars exist?
        	try
        	{
        	    Class c = Class.forName("javax.xml.bind.JAXB");
        	    log.finest("JAXB Jar files found");
        	}
        	catch (ClassNotFoundException e)
        	{
        	    // TODO Auto-generated catch block
        	    log.severe("JAXB Jar files not present - downloading files");
        	    GetURL(updateURL +"lib/jsr173_1.0_api.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "jsr173_1.0_api.jar");
        	    GetURL(updateURL +"lib/jaxb-impl.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "jaxb-impl.jar");
        	    GetURL(updateURL +"lib/jaxb-api.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "jaxb-api.jar");
        	    GetURL(updateURL +"lib/activation.jar", PersistentSettings.getPropertyValue("UPDATE.SAVELOCATION") + "activation.jar");
        	    log.info("Downloaded JAXB Jars");
        	}
	}
    }
    
    private static UpdateDetails getDetails(String updateURL) throws IOException
    {
	String result = simpleHttpGet(updateURL);
	UpdateDetails details = new UpdateDetails(result);
	return details;
    }

    public static boolean isVersionUptoDate(UpdateDetails details)
    {
	float webVersion = Float.parseFloat(details.getVersion());
	float appVersion = Float.parseFloat(Version.getNumericVersion());

	if (appVersion >= webVersion)
	{   
	    //System.out.println("Application is up to date");
	    log.log(Level.INFO, "Application is up to date");
	    return true;
	}
	else
	{
	    log.log(Level.WARNING, "Application is out of date and requires updating");
	    return false;
	}
	
    }
}
