package uk.co.pembo.agemame.ui;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.FillLayout;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class ItemSelectionPanel extends Composite
{

    private TabFolder itemSelection = null;
    private CTabFolder elementsTab = null;
    private TableColumn elementNames;
    private TableItem element1;
    private Table elementsTable;
    private CTabFolder backdropsTab = null;
    public ItemSelectionPanel(Composite parent, int style)
    {
	super(parent, style);
	initialize();
    }

    private void initialize()
    {
	GridLayout gridLayout = new GridLayout();
	gridLayout.numColumns = 1;
	gridLayout.makeColumnsEqualWidth = false;
	createItemSelection();
	this.setLayout(gridLayout);
	//this.setSize(new Point(300, 600));
    }

    /**
     * This method initializes itemSelection	
     *
     */
    private void createItemSelection()
    {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessVerticalSpace = true;
        
        itemSelection = new TabFolder(this, SWT.NONE);
        itemSelection.setLayout(new GridLayout());
        itemSelection.setLayoutData(gridData);
        
        TabItem tabItem = new TabItem(itemSelection, SWT.NONE);
        tabItem.setText("Elements");
        tabItem.setControl(elementsTab);
    {
    elementsTable = new Table(itemSelection, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);
    elementsTable.setLinesVisible(true);
	tabItem.setControl(elementsTable);
    {
	elementNames = new TableColumn(elementsTable, SWT.NONE);
	elementNames.setText("Element Names");
	elementNames.setWidth(279);
	
	
    }
{
    element1 = new TableItem(elementsTable, SWT.NONE);
    //element1.setText("The first Element");
}
    }
        TabItem tabItem2 = new TabItem(itemSelection, SWT.NONE);
        tabItem2.setText("Backdrops");
        tabItem2.setControl(backdropsTab);
        
    }
    
    
public void addElement(String elementName)
{
    TableItem t = new TableItem(elementsTable,SWT.BORDER);
    t.setText(elementName);
}

public void addElements(String[] elements)
{
    for(int i=0;i<elements.length;i++)
    {
    TableItem t = new TableItem(elementsTable,SWT.NONE);
    t.setText(elements[i]);
    }
    
    Point p = itemSelection.computeSize(SWT.DEFAULT, SWT.DEFAULT,true);
    itemSelection.setSize(p);
    
    
}

public Table getElementsTable() {
    return elementsTable;
}

}  //  @jve:decl-index=0:visual-constraint="10,10"
