package uk.co.pembo.agemame.userinterface;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uk.co.pembo.graphics.SWTResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import uk.co.pembo.util.PersistentSettings;

public class RenameFile extends org.eclipse.swt.widgets.Dialog {

	private static Text text;
	private boolean rename = false;
	private Shell dialogShell;
	private static String newFileNameStr;

	
	    /**
	     * Create the dialog
	     * @param parent
	     * @param style
	     */
	    public RenameFile(Shell parent, int style)
	    {
		super(parent, style);
	    }

	    /**
	     * Create the dialog
	     * @param parent
	     */
	    public RenameFile(Shell parent)
	    {
		this(parent, SWT.NONE);
	    }
	
	/**
	* Auto-generated main method to display this 
	* org.eclipse.swt.widgets.Dialog inside a new Shell.
	*/
	
	public void createContents() {
		try {
			Display display = Display.getDefault();
			dialogShell = new Shell(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
			
			dialogShell.setSize(500, 160);

			int guessWidth = 500;
			int guessHeigh = 160;
			
			dialogShell.setLocation((this.getParent().getSize().x - guessWidth) / 2,(this.getParent().getSize().y - guessHeigh) / 2);
			dialogShell.setText("Rename File");
			//RenameFile inst = new RenameFile(renameFileShell, SWT.NULL);

			final Label pleaseEnterNewLabel = new Label(dialogShell, SWT.NONE);
			pleaseEnterNewLabel.setText("Please enter new name For File:");
			pleaseEnterNewLabel.setBounds(10, 10, 253, 13);

			text = new Text(dialogShell, SWT.BORDER);
			text.addKeyListener(new KeyAdapter() {
				public void keyPressed(KeyEvent arg0)
				{
				    if(arg0.keyCode==13)
				    {
					rename = true;
					newFileNameStr = newFileName().getText();
					dialogShell.close();
				    }
				}
			});
			text.setBounds(10, 30, 463, 25);

			final Button okButton = new Button(dialogShell, SWT.NONE);
			okButton.setFont(SWTResourceManager.getFont("", 10, SWT.BOLD));
			okButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent arg0)
				{
				    rename = true;
				    newFileNameStr = newFileName().getText();
				    dialogShell.close();
				}
			});
			okButton.setText("OK");
			okButton.setBounds(326, 76, 68, 23);

			final Button cancelButton = new Button(dialogShell, SWT.NONE);
			cancelButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent arg0)
				{
				    rename = false;
				    dialogShell.close();
				    
				}
			});
			cancelButton.setText("Cancel");
			cancelButton.setBounds(400, 76, 73, 23);
			//inst.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public String open(String defaultValue) {
		try {
		    	createContents();
		    	this.newFileName().setText(defaultValue);
			//Shell parent = getParent();
			//dialogShell = new Shell(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

			//dialogShell.setLayout(new GridLayout());
			//dialogShell.layout();
			//dialogShell.pack();
		    	
			dialogShell.open();
			dialogShell.layout();
			this.newFileName().selectAll();
			Display display = getParent().getDisplay();
			

			
			while (!dialogShell.isDisposed())
			{
			    if (!display.readAndDispatch()) display.sleep();
			}
			
			if(rename)
			{
			//return this.newFileName().getText();
			    return newFileNameStr;
			}
			else
			{
			    return null;
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	public Text newFileName()
	{
		return text;
	}
	
}
